package com.alibaba.druid.sql.dialect.es.visitor;

import com.alibaba.druid.sql.dialect.es.ast.EsLexer;
import com.alibaba.druid.sql.dialect.es.ast.EsParser;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.tree.ParseTree;

public class EsUtils {
   public static EsParser.StatementContext parse(String uri, String json) {
      String query = uri + "\n" + json;
      return parse(query);
   }

   public static EsParser.StatementContext parse(String query) {
      CharStream stream = CharStreams.fromString(query);
      EsLexer lexer = new EsLexer(stream);
      CommonTokenStream tokenStream = new CommonTokenStream(lexer);
      EsParser parser = new EsParser(tokenStream);
      EsParser.StatementContext statement = parser.statement();
      statement.putAttribute("apiType", parser.apiType);
      statement.putAttribute("stmtType", parser.type);
      return statement;
   }

   public static ParseTree parseMappingBody(String content) {
      CharStream stream = CharStreams.fromString(content);
      EsLexer lexer = new EsLexer(stream);
      CommonTokenStream tokenStream = new CommonTokenStream(lexer);
      EsParser parser = new EsParser(tokenStream);
      return parser.mappingResponse();
   }

   public static MappingTree parseMappingTree(String content) {
      ParseTree context = parseMappingBody(content);
      MappingTree tree = new MappingTree();
      EsSchemaVisitor visitor = new EsSchemaVisitor(tree);
      visitor.visit(context);
      return tree;
   }

   public static EsParser.SearchResponseContext parseSearchResponseBody(String content) {
      CharStream stream = CharStreams.fromString(content);
      EsLexer lexer = new EsLexer(stream);
      CommonTokenStream tokenStream = new CommonTokenStream(lexer);
      EsParser parser = new EsParser(tokenStream);
      return parser.searchResponse();
   }

   public static void parseSearchResponse(String body, QueryResponseVisitor.Visitor visitor) {
      if (body != null && body.length() != 0) {
         EsParser.SearchResponseContext ctx = parseSearchResponseBody(body);
         parseSearchResponse(ctx, visitor);
      }
   }

   public static void parseGetResponse(String body, QueryResponseVisitor.Visitor visitor) {
      if (body != null && body.length() != 0) {
         CharStream stream = CharStreams.fromString(body);
         EsLexer lexer = new EsLexer(stream);
         CommonTokenStream tokenStream = new CommonTokenStream(lexer);
         EsParser parser = new EsParser(tokenStream);
         EsParser.GetResponseContext ctx = parser.getResponse();
         QueryResponseVisitor getResponseVisitor = new QueryResponseVisitor(visitor);
         getResponseVisitor.accept(ctx);
      }
   }

   public static void parseSearchResponse(EsParser.SearchResponseContext ctx, QueryResponseVisitor.Visitor visitor) {
      QueryResponseVisitor searchResponesVisitor = new QueryResponseVisitor(visitor);
      searchResponesVisitor.accept(ctx);
   }
}
