package com.alibaba.druid.sql.dialect.gauss.ast.expr.tablesource;

import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.dialect.gauss.ast.GaussSQLObject;
import com.alibaba.druid.sql.dialect.gauss.visitor.GaussASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;

public class GaussExprTableSource extends SQLExprTableSource implements GaussSQLObject, GaussTableSource {
   protected boolean only;

   public void accept0(GaussASTVisitor visitor) {
      if (visitor.visit(this)) {
         if (this.expr != null) {
            this.expr.accept(visitor);
         }

         if (this.sampling != null) {
            this.sampling.accept(visitor);
         }
      }

      visitor.endVisit(this);
   }

   public void addColumnAlias(SQLName name) {
      if (this.columns == null) {
         this.columns = new ArrayList();
      }

      this.columns.add(name);
   }

   protected void accept0(SQLASTVisitor visitor) {
      this.accept0((GaussASTVisitor)visitor);
   }

   public boolean isOnly() {
      return this.only;
   }

   public void setOnly(boolean only) {
      this.only = only;
   }

   public GaussExprTableSource clone() {
      GaussExprTableSource x = new GaussExprTableSource();
      this.cloneTo(x);
      x.only = this.only;
      return x;
   }
}
