package com.alibaba.druid.sql.dialect.gauss.ast.stmt.alterTable;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.druid.sql.dialect.gauss.ast.GaussSQLObjectImpl;
import com.alibaba.druid.sql.dialect.gauss.visitor.GaussASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class GaussAlterTableAlterColumn extends GaussSQLObjectImpl implements SQLAlterTableItem {
   private SQLExpr column;
   private Type type;
   private SQLExpr dataType;
   private SQLExpr collation;
   private SQLExpr usingExpression;
   private SQLExpr defaultExpression;
   private SQLExpr statics;

   public SQLExpr getColumn() {
      return this.column;
   }

   public void setColumn(SQLExpr column) {
      this.column = column;
      column.setParent(this);
   }

   public Type getType() {
      return this.type;
   }

   public void setType(Type type) {
      this.type = type;
   }

   public SQLExpr getDataType() {
      return this.dataType;
   }

   public void setDataType(SQLExpr dataType) {
      this.dataType = dataType;
   }

   public SQLExpr getCollation() {
      return this.collation;
   }

   public void setCollation(SQLExpr collation) {
      this.collation = collation;
      collation.setParent(this);
   }

   public SQLExpr getUsingExpression() {
      return this.usingExpression;
   }

   public void setUsingExpression(SQLExpr usingExpression) {
      this.usingExpression = usingExpression;
      usingExpression.setParent(this);
   }

   public SQLExpr getDefaultExpression() {
      return this.defaultExpression;
   }

   public void setDefaultExpression(SQLExpr defaultExpression) {
      this.defaultExpression = defaultExpression;
   }

   public SQLExpr getStatics() {
      return this.statics;
   }

   public void setStatics(SQLExpr statics) {
      this.statics = statics;
      statics.setParent(this);
   }

   public void accept0(SQLASTVisitor visitor) {
      this.accept0((GaussASTVisitor)visitor);
   }

   public void accept0(GaussASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.column);
         this.acceptChild(visitor, this.dataType);
         this.acceptChild(visitor, this.collation);
         this.acceptChild(visitor, this.usingExpression);
         this.acceptChild(visitor, this.defaultExpression);
         this.acceptChild(visitor, this.statics);
      }

      visitor.endVisit(this);
   }

   public GaussAlterTableAlterColumn clone() {
      GaussAlterTableAlterColumn c = new GaussAlterTableAlterColumn();
      c.setColumn(this.column.clone());
      c.setDataType(this.dataType.clone());
      c.setCollation(this.collation.clone());
      c.setUsingExpression(this.usingExpression.clone());
      c.setDefaultExpression(this.defaultExpression.clone());
      c.setStatics(this.statics.clone());
      c.type = this.type;
      return c;
   }

   public static enum Type {
      setType,
      setDefault,
      dropDefault,
      setNotNull,
      dropNotNull,
      setStatistics;
   }
}
