package com.alibaba.druid.sql.dialect.hive.ast.stmt;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.statement.SQLAlterDatabaseStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterStatement;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.dialect.hive.visitor.HiveASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class HiveAlterDatabaseStatement extends SQLAlterDatabaseStatement implements HiveStatement, SQLAlterStatement {
   private SQLName name;
   private boolean upgradeDataDirectoryName;
   private HiveAlterDatabaseStatement character;
   private HiveAlterDatabaseStatement item;
   private List<SQLAssignItem> properties = new ArrayList();
   public SQLExpr user;
   public SQLExpr location;
   public SQLExpr managedlocation;

   public HiveAlterDatabaseStatement() {
      this.dbType = DbType.hive;
   }

   public HiveAlterDatabaseStatement(DbType dbType) {
      this.setDbType(dbType);
   }

   public SQLName getName() {
      return this.name;
   }

   public void setName(SQLName name) {
      if (name != null) {
         name.setParent(this);
      }

      this.name = name;
   }

   public boolean isUpgradeDataDirectoryName() {
      return this.upgradeDataDirectoryName;
   }

   public void setUpgradeDataDirectoryName(boolean upgradeDataDirectoryName) {
      this.upgradeDataDirectoryName = upgradeDataDirectoryName;
   }

   protected void accept0(SQLASTVisitor visitor) {
      this.accept0((HiveASTVisitor)visitor);
   }

   public void accept0(HiveASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.name);
      }

      visitor.endVisit(this);
   }

   public List<SQLAssignItem> getProperties() {
      return this.properties;
   }

   public List<SQLObject> getChildren() {
      return Collections.singletonList(this.name);
   }
}
