package com.alibaba.druid.sql.dialect.mariadb.ast.statement;

import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.druid.sql.dialect.mariadb.ast.MariadbObjectImpl;
import com.alibaba.druid.sql.dialect.mariadb.visitor.MariadbASTVisitor;

public class MariadbAlterTableOption extends MariadbObjectImpl implements SQLAlterTableItem {
   private String name;
   private SQLObject value;

   public MariadbAlterTableOption(String name, String value) {
      this(name, (SQLObject)(new SQLIdentifierExpr(value)));
   }

   public MariadbAlterTableOption(String name, SQLObject value) {
      this.name = name;
      this.setValue(value);
   }

   public MariadbAlterTableOption() {
   }

   public void accept0(MariadbASTVisitor visitor) {
      visitor.visit(this);
      visitor.endVisit(this);
   }

   public String getName() {
      return this.name;
   }

   public void setName(String name) {
      this.name = name;
   }

   public SQLObject getValue() {
      return this.value;
   }

   public void setValue(SQLObject value) {
      this.value = value;
   }
}
