package com.alibaba.druid.sql.dialect.mysql.ast;

import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitor;
import java.util.ArrayList;
import java.util.List;

public abstract class MySqlIndexHintImpl extends MySqlObjectImpl implements MySqlIndexHint {
   private Option option;
   private List<SQLName> indexList = new ArrayList();

   public abstract void accept0(MySqlASTVisitor var1);

   public Option getOption() {
      return this.option;
   }

   public void setOption(Option option) {
      this.option = option;
   }

   public List<SQLName> getIndexList() {
      return this.indexList;
   }

   public void setIndexList(List<SQLName> indexList) {
      this.indexList = indexList;
   }

   public abstract MySqlIndexHintImpl clone();

   public void cloneTo(MySqlIndexHintImpl x) {
      x.option = this.option;

      for(SQLName name : this.indexList) {
         SQLName name2 = name.clone();
         name2.setParent(x);
         x.indexList.add(name2);
      }

   }
}
