package com.alibaba.druid.sql.dialect.mysql.ast.statement;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlObjectImpl;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitor;

public class MySqlAlterTableAlterColumn extends MySqlObjectImpl implements SQLAlterTableItem {
   private SQLName column;
   private boolean dropDefault = false;
   private SQLExpr defaultExpr;
   protected boolean visible = false;
   protected boolean invisible = false;

   public void accept0(MySqlASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.column);
         this.acceptChild(visitor, this.defaultExpr);
      }

      visitor.endVisit(this);
   }

   public boolean isDropDefault() {
      return this.dropDefault;
   }

   public void setDropDefault(boolean dropDefault) {
      this.dropDefault = dropDefault;
   }

   public SQLExpr getDefaultExpr() {
      return this.defaultExpr;
   }

   public void setDefaultExpr(SQLExpr defaultExpr) {
      this.defaultExpr = defaultExpr;
   }

   public SQLName getColumn() {
      return this.column;
   }

   public void setColumn(SQLName column) {
      this.column = column;
   }

   public boolean isVisible() {
      return this.visible;
   }

   public void setVisible(boolean visible) {
      this.visible = visible;
   }

   public boolean isInvisible() {
      return this.invisible;
   }

   public void setInvisible(boolean invisible) {
      this.invisible = invisible;
   }
}
