package com.alibaba.druid.sql.dialect.mysql.ast.statement;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class MySqlExecuteStatement extends MySqlStatementImpl {
   private SQLName statementName;
   private final List<SQLExpr> parameters = new ArrayList();

   public SQLName getStatementName() {
      return this.statementName;
   }

   public void setStatementName(SQLName statementName) {
      this.statementName = statementName;
   }

   public List<SQLExpr> getParameters() {
      return this.parameters;
   }

   public void accept0(MySqlASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.statementName);
         this.acceptChild(visitor, this.parameters);
      }

      visitor.endVisit(this);
   }

   public List<SQLObject> getChildren() {
      List<SQLObject> children = new ArrayList();
      if (this.statementName != null) {
         children.add(this.statementName);
      }

      children.addAll(this.parameters);
      return children;
   }
}
