package com.alibaba.druid.sql.dialect.oracle.ast.expr;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class OracleIsOfTypeExpr extends SQLExprImpl implements OracleExpr, SQLReplaceable {
   private SQLExpr expr;
   private List<SQLExpr> types = new ArrayList();

   public boolean equals(Object o) {
      if (this == o) {
         return true;
      } else if (o != null && this.getClass() == o.getClass()) {
         OracleIsOfTypeExpr that = (OracleIsOfTypeExpr)o;
         if (this.expr != null) {
            if (!this.expr.equals(that.expr)) {
               return false;
            }
         } else if (that.expr != null) {
            return false;
         }

         return this.types != null ? this.types.equals(that.types) : that.types == null;
      } else {
         return false;
      }
   }

   public int hashCode() {
      int result = this.expr != null ? this.expr.hashCode() : 0;
      result = 31 * result + (this.types != null ? this.types.hashCode() : 0);
      return result;
   }

   protected void accept0(SQLASTVisitor visitor) {
      this.accept0((OracleASTVisitor)visitor);
   }

   public void accept0(OracleASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.expr);
         this.acceptChild(visitor, this.types);
      }

      visitor.endVisit(this);
   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      if (this.expr == expr) {
         this.setExpr(target);
         return true;
      } else {
         for(int i = 0; i < this.types.size(); ++i) {
            if (this.types.get(i) == expr) {
               target.setParent(this);
               this.types.set(i, target);
               return true;
            }
         }

         return false;
      }
   }

   public SQLExpr clone() {
      OracleIsOfTypeExpr x = new OracleIsOfTypeExpr();
      if (this.expr != null) {
         x.setExpr(this.expr);
      }

      return null;
   }

   public List<SQLObject> getChildren() {
      List children = new ArrayList();
      if (this.expr != null) {
         children.add(this.expr);
      }

      children.addAll(this.types);
      return children;
   }

   public SQLExpr getExpr() {
      return this.expr;
   }

   public void setExpr(SQLExpr expr) {
      if (expr != null) {
         expr.setParent(this);
      }

      this.expr = expr;
   }

   public List<SQLExpr> getTypes() {
      return this.types;
   }
}
