package com.alibaba.druid.sql.dialect.oracle.ast.expr;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.dialect.oracle.ast.OracleSQLObject;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class OracleJsonArrayAggExpr extends SQLExprImpl implements OracleSQLObject {
   public static final String VERSION = "12c";
   private SQLExpr expr;
   private boolean formatJson = false;
   private SQLOrderBy orderBy;
   private OracleJsonAggArrayOnNullClause nullClause;
   private OracleJsonAggArrayReturnClause returnClause;
   private boolean strict;

   public List<SQLObject> getChildren() {
      List<SQLObject> children = new ArrayList();
      children.add(this.expr);
      if (this.orderBy != null) {
         children.add(this.orderBy);
      }

      if (this.nullClause != null) {
         children.add(this.nullClause);
      }

      if (this.returnClause != null) {
         children.add(this.returnClause);
      }

      return children;
   }

   public SQLExpr getExpr() {
      return this.expr;
   }

   public void setExpr(SQLExpr expr) {
      this.expr = expr;
   }

   public boolean isFormatJson() {
      return this.formatJson;
   }

   public void setFormatJson(boolean formatJson) {
      this.formatJson = formatJson;
   }

   public SQLOrderBy getOrderBy() {
      return this.orderBy;
   }

   public void setOrderBy(SQLOrderBy orderBy) {
      this.orderBy = orderBy;
   }

   public OracleJsonAggArrayOnNullClause getNullClause() {
      return this.nullClause;
   }

   public void setNullClause(OracleJsonAggArrayOnNullClause nullClause) {
      this.nullClause = nullClause;
   }

   public boolean isStrict() {
      return this.strict;
   }

   public void setStrict(boolean strict) {
      this.strict = strict;
   }

   public boolean equals(Object o) {
      if (o == null) {
         return false;
      } else if (o.getClass() != this.getClass()) {
         return false;
      } else {
         return o == this;
      }
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + this.expr.hashCode();
      result = 31 * result + (this.formatJson ? 1 : 2);
      result = 31 * result + (this.orderBy == null ? 0 : this.orderBy.hashCode());
      result = 31 * result + (this.nullClause == null ? 0 : this.nullClause.hashCode());
      result = 31 * result + (this.returnClause == null ? 0 : this.returnClause.hashCode());
      result = 31 * result + (this.strict ? 1 : 2);
      return result;
   }

   protected void accept0(SQLASTVisitor v) {
      this.accept0((OracleASTVisitor)v);
   }

   public void accept0(OracleASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.expr);
         if (this.orderBy != null) {
            this.acceptChild(visitor, this.orderBy);
         }

         if (this.nullClause != null) {
            this.acceptChild(visitor, this.nullClause);
         }

         if (this.returnClause != null) {
            this.acceptChild(visitor, this.returnClause);
         }
      }

   }

   public SQLExpr clone() {
      OracleJsonArrayAggExpr aggExpr = new OracleJsonArrayAggExpr();
      aggExpr.expr = this.expr.clone();
      aggExpr.formatJson = this.formatJson;
      if (this.orderBy != null) {
         aggExpr.orderBy = this.orderBy.clone();
      }

      if (this.nullClause != null) {
         aggExpr.nullClause = (OracleJsonAggArrayOnNullClause)this.nullClause.clone();
      }

      if (this.returnClause != null) {
         aggExpr.returnClause = (OracleJsonAggArrayReturnClause)this.returnClause.clone();
      }

      aggExpr.strict = this.strict;
      return aggExpr;
   }

   public OracleJsonAggArrayReturnClause getReturnClause() {
      return this.returnClause;
   }

   public void setReturnClause(OracleJsonAggArrayReturnClause returnClause) {
      this.returnClause = returnClause;
   }

   public static class OracleJsonAggArrayOnNullClause extends SQLExprImpl {
      private SQLExpr nullOrAbsent;

      public boolean equals(Object o) {
         if (o == null) {
            return false;
         } else if (o.getClass() != this.getClass()) {
            return false;
         } else {
            return o == this;
         }
      }

      public int hashCode() {
         int prime = 31;
         int result = 1;
         result = 31 * result + (this.nullOrAbsent == null ? 0 : this.nullOrAbsent.hashCode());
         return result;
      }

      protected void accept0(SQLASTVisitor v) {
         OracleASTVisitor visitor = (OracleASTVisitor)v;
         if (visitor.visit(this)) {
            this.acceptChild(v, this.nullOrAbsent);
         }

      }

      public SQLExpr clone() {
         OracleJsonAggArrayOnNullClause clause = new OracleJsonAggArrayOnNullClause();
         clause.nullOrAbsent = this.nullOrAbsent.clone();
         return clause;
      }

      public SQLExpr getNullOrAbsent() {
         return this.nullOrAbsent;
      }

      public void setNullOrAbsent(SQLExpr nullOrAbsent) {
         this.nullOrAbsent = nullOrAbsent;
      }
   }

   public static class OracleJsonAggArrayReturnClause extends SQLExprImpl {
      private SQLExpr type;
      private SQLExpr size;
      private SQLExpr byteOrChar;

      public SQLExpr getType() {
         return this.type;
      }

      public void setType(SQLExpr type) {
         this.type = type;
      }

      public SQLExpr getSize() {
         return this.size;
      }

      public void setSize(SQLExpr size) {
         this.size = size;
      }

      public SQLExpr getByteOrChar() {
         return this.byteOrChar;
      }

      public void setByteOrChar(SQLExpr byteOrChar) {
         this.byteOrChar = byteOrChar;
      }

      public boolean equals(Object o) {
         if (o == null) {
            return false;
         } else if (o.getClass() != this.getClass()) {
            return false;
         } else {
            return o == this;
         }
      }

      public int hashCode() {
         int prime = 31;
         int result = 1;
         result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
         result = 31 * result + (this.size == null ? 0 : this.size.hashCode());
         result = 31 * result + (this.byteOrChar == null ? 0 : this.byteOrChar.hashCode());
         return result;
      }

      protected void accept0(SQLASTVisitor v) {
         OracleASTVisitor visitor = (OracleASTVisitor)v;
         if (visitor.visit(this)) {
            this.acceptChild(v, this.type);
            this.acceptChild(v, this.size);
            this.acceptChild(v, this.byteOrChar);
         }

      }

      public SQLExpr clone() {
         OracleJsonAggArrayReturnClause clause = new OracleJsonAggArrayReturnClause();
         if (clause.type != null) {
            clause.type = this.type.clone();
         }

         if (clause.size != null) {
            clause.size = this.size.clone();
         }

         if (clause.byteOrChar != null) {
            clause.byteOrChar = this.byteOrChar.clone();
         }

         return clause;
      }
   }
}
