package com.alibaba.druid.sql.dialect.oracle.ast.stmt;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class OracleSelectSubqueryTableSource extends SQLSubqueryTableSource implements OracleSelectTableSource {
   protected OracleSelectPivotBase pivot;

   public OracleSelectSubqueryTableSource() {
   }

   public OracleSelectSubqueryTableSource(String alias) {
      super(alias);
   }

   public OracleSelectSubqueryTableSource(SQLSelect select, String alias) {
      super(select, alias);
   }

   public OracleSelectSubqueryTableSource(SQLSelect select) {
      super(select);
   }

   public OracleSelectPivotBase getPivot() {
      return this.pivot;
   }

   public void setPivot(OracleSelectPivotBase pivot) {
      this.pivot = pivot;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor instanceof OracleASTVisitor) {
         this.accept0((OracleASTVisitor)visitor);
      }

   }

   protected void accept0(OracleASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.getHints());
         this.acceptChild(visitor, this.select);
         this.acceptChild(visitor, this.pivot);
         this.acceptChild(visitor, this.flashback);
      }

      visitor.endVisit(this);
   }

   public String toString() {
      return SQLUtils.toOracleString(this);
   }

   public OracleSelectSubqueryTableSource clone() {
      OracleSelectSubqueryTableSource x = new OracleSelectSubqueryTableSource();
      this.cloneTo(x);
      if (this.pivot != null) {
         this.setParent(this.pivot.clone());
      }

      return x;
   }
}
