package com.alibaba.druid.stat;

import java.util.concurrent.atomic.AtomicLong;
import javax.management.JMException;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public final class JdbcStatManager {
   private final AtomicLong sqlIdSeed = new AtomicLong(1000L);
   private static final JdbcStatManager instance = new JdbcStatManager();
   private final JdbcConnectionStat connectionStat = new JdbcConnectionStat();
   private final JdbcResultSetStat resultSetStat = new JdbcResultSetStat();
   private final JdbcStatementStat statementStat = new JdbcStatementStat();
   private final AtomicLong resetCount = new AtomicLong();
   public final ThreadLocal<JdbcStatContext> contextLocal = new ThreadLocal();
   private static CompositeType COMPOSITE_TYPE = null;

   private JdbcStatManager() {
   }

   public JdbcStatContext getStatContext() {
      return (JdbcStatContext)this.contextLocal.get();
   }

   public void setStatContext(JdbcStatContext context) {
      this.contextLocal.set(context);
   }

   public JdbcStatContext createStatContext() {
      return new JdbcStatContext();
   }

   public long generateSqlId() {
      return this.sqlIdSeed.incrementAndGet();
   }

   public static JdbcStatManager getInstance() {
      return instance;
   }

   public JdbcStatementStat getStatementStat() {
      return this.statementStat;
   }

   public JdbcResultSetStat getResultSetStat() {
      return this.resultSetStat;
   }

   public JdbcConnectionStat getConnectionStat() {
      return this.connectionStat;
   }

   public static CompositeType getDataSourceCompositeType() throws JMException {
      if (COMPOSITE_TYPE != null) {
         return COMPOSITE_TYPE;
      } else {
         OpenType<?>[] indexTypes = new OpenType[]{SimpleType.LONG, SimpleType.STRING, SimpleType.STRING, new ArrayType(SimpleType.STRING, false), SimpleType.DATE, SimpleType.STRING, SimpleType.STRING, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.STRING, SimpleType.LONG, SimpleType.INTEGER, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.DATE, SimpleType.LONG, SimpleType.DATE, SimpleType.STRING, SimpleType.STRING, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.LONG, SimpleType.LONG, SimpleType.DATE, SimpleType.STRING, SimpleType.STRING, SimpleType.LONG, SimpleType.INTEGER, SimpleType.DATE, SimpleType.LONG, SimpleType.LONG, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.LONG, SimpleType.DATE, SimpleType.LONG, SimpleType.LONG, SimpleType.DATE, SimpleType.STRING, SimpleType.STRING, SimpleType.LONG, SimpleType.STRING, SimpleType.STRING, SimpleType.LONG, SimpleType.INTEGER, SimpleType.LONG, SimpleType.DATE, SimpleType.LONG, SimpleType.LONG, new ArrayType(SimpleType.LONG, true), new ArrayType(SimpleType.LONG, true)};
         String[] indexNames = new String[]{"ID", "URL", "Name", "FilterClasses", "CreatedTime", "RawUrl", "RawDriverClassName", "RawDriverMajorVersion", "RawDriverMinorVersion", "Properties", "ConnectionActiveCount", "ConnectionActiveCountMax", "ConnectionCloseCount", "ConnectionCommitCount", "ConnectionRollbackCount", "ConnectionConnectLastTime", "ConnectionConnectErrorCount", "ConnectionConnectErrorLastTime", "ConnectionConnectErrorLastMessage", "ConnectionConnectErrorLastStackTrace", "StatementCreateCount", "StatementPrepareCount", "StatementPreCallCount", "StatementExecuteCount", "StatementRunningCount", "StatementConcurrentMax", "StatementCloseCount", "StatementErrorCount", "StatementLastErrorTime", "StatementLastErrorMessage", "StatementLastErrorStackTrace", "StatementExecuteMillisTotal", "ConnectionConnectingCount", "StatementExecuteLastTime", "ResultSetCloseCount", "ResultSetOpenCount", "ResultSetOpenningCount", "ResultSetOpenningMax", "ResultSetFetchRowCount", "ResultSetLastOpenTime", "ResultSetErrorCount", "ResultSetOpenningMillisTotal", "ResultSetLastErrorTime", "ResultSetLastErrorMessage", "ResultSetLastErrorStackTrace", "ConnectionConnectCount", "ConnectionErrorLastMessage", "ConnectionErrorLastStackTrace", "ConnectionConnectMillisTotal", "ConnectionConnectingCountMax", "ConnectionConnectMillisMax", "ConnectionErrorLastTime", "ConnectionAliveMillisMax", "ConnectionAliveMillisMin", "ConnectionHistogram", "StatementHistogram"};
         COMPOSITE_TYPE = new CompositeType("DataSourceStatistic", "DataSource Statistic", indexNames, indexNames, indexTypes);
         return COMPOSITE_TYPE;
      }
   }
}
