package com.alibaba.druid.wall;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.util.Utils;
import com.alibaba.druid.wall.spi.WallVisitorUtils;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;

public class WallConfig implements WallConfigMBean {
   private boolean noneBaseStatementAllow;
   private boolean callAllow;
   private boolean selelctAllow;
   private boolean selectIntoAllow;
   private boolean selectIntoOutfileAllow;
   private boolean selectWhereAlwayTrueCheck;
   private boolean selectHavingAlwayTrueCheck;
   private boolean selectUnionCheck;
   private boolean selectMinusCheck;
   private boolean selectExceptCheck;
   private boolean selectIntersectCheck;
   private boolean createTableAllow;
   private boolean dropTableAllow;
   private boolean alterTableAllow;
   private boolean renameTableAllow;
   private boolean hintAllow;
   private boolean lockTableAllow;
   private boolean startTransactionAllow;
   private boolean blockAllow;
   private boolean conditionAndAlwayTrueAllow;
   private boolean conditionAndAlwayFalseAllow;
   private boolean conditionDoubleConstAllow;
   private boolean conditionLikeTrueAllow;
   private boolean selectAllColumnAllow;
   private boolean deleteAllow;
   private boolean deleteWhereAlwayTrueCheck;
   private boolean deleteWhereNoneCheck;
   private boolean updateAllow;
   private boolean updateWhereAlayTrueCheck;
   private boolean updateWhereNoneCheck;
   private boolean insertAllow;
   private boolean mergeAllow;
   private boolean minusAllow;
   private boolean intersectAllow;
   private boolean replaceAllow;
   private boolean setAllow;
   private boolean commitAllow;
   private boolean rollbackAllow;
   private boolean useAllow;
   private boolean multiStatementAllow;
   private boolean truncateAllow;
   private boolean commentAllow;
   private boolean strictSyntaxCheck;
   private boolean constArithmeticAllow;
   private boolean limitZeroAllow;
   private boolean describeAllow;
   private boolean showAllow;
   private boolean schemaCheck;
   private boolean tableCheck;
   private boolean functionCheck;
   private boolean objectCheck;
   private boolean variantCheck;
   private boolean mustParameterized;
   private boolean doPrivilegedAllow;
   protected final Set<String> denyFunctions;
   protected final Set<String> denyTables;
   protected final Set<String> denySchemas;
   protected final Set<String> denyVariants;
   protected final Set<String> denyObjects;
   protected final Set<String> permitFunctions;
   protected final Set<String> permitTables;
   protected final Set<String> permitSchemas;
   protected final Set<String> permitVariants;
   protected final Set<String> readOnlyTables;
   private String dir;
   private boolean inited;
   private String tenantTablePattern;
   private String tenantColumn;
   private TenantCallBack tenantCallBack;
   private boolean wrapAllow;
   private boolean metadataAllow;
   private boolean conditionOpXorAllow;
   private boolean conditionOpBitwseAllow;
   private boolean caseConditionConstAllow;
   private boolean completeInsertValuesCheck;
   private int insertValuesCheckSize;
   private int selectLimit;
   protected Map<String, Set<String>> updateCheckColumns;
   protected WallUpdateCheckHandler updateCheckHandler;

   public WallConfig() {
      this.noneBaseStatementAllow = false;
      this.callAllow = true;
      this.selelctAllow = true;
      this.selectIntoAllow = true;
      this.selectIntoOutfileAllow = false;
      this.selectWhereAlwayTrueCheck = true;
      this.selectHavingAlwayTrueCheck = true;
      this.selectUnionCheck = true;
      this.selectMinusCheck = true;
      this.selectExceptCheck = true;
      this.selectIntersectCheck = true;
      this.createTableAllow = true;
      this.dropTableAllow = true;
      this.alterTableAllow = true;
      this.renameTableAllow = true;
      this.hintAllow = true;
      this.lockTableAllow = true;
      this.startTransactionAllow = true;
      this.blockAllow = true;
      this.conditionAndAlwayTrueAllow = false;
      this.conditionAndAlwayFalseAllow = false;
      this.conditionDoubleConstAllow = false;
      this.conditionLikeTrueAllow = true;
      this.selectAllColumnAllow = true;
      this.deleteAllow = true;
      this.deleteWhereAlwayTrueCheck = true;
      this.deleteWhereNoneCheck = false;
      this.updateAllow = true;
      this.updateWhereAlayTrueCheck = true;
      this.updateWhereNoneCheck = false;
      this.insertAllow = true;
      this.mergeAllow = true;
      this.minusAllow = true;
      this.intersectAllow = true;
      this.replaceAllow = true;
      this.setAllow = true;
      this.commitAllow = true;
      this.rollbackAllow = true;
      this.useAllow = true;
      this.multiStatementAllow = false;
      this.truncateAllow = true;
      this.commentAllow = false;
      this.strictSyntaxCheck = true;
      this.constArithmeticAllow = true;
      this.limitZeroAllow = false;
      this.describeAllow = true;
      this.showAllow = true;
      this.schemaCheck = true;
      this.tableCheck = true;
      this.functionCheck = true;
      this.objectCheck = true;
      this.variantCheck = true;
      this.mustParameterized = false;
      this.doPrivilegedAllow = false;
      this.denyFunctions = new ConcurrentSkipListSet();
      this.denyTables = new ConcurrentSkipListSet();
      this.denySchemas = new ConcurrentSkipListSet();
      this.denyVariants = new ConcurrentSkipListSet();
      this.denyObjects = new ConcurrentSkipListSet();
      this.permitFunctions = new ConcurrentSkipListSet();
      this.permitTables = new ConcurrentSkipListSet();
      this.permitSchemas = new ConcurrentSkipListSet();
      this.permitVariants = new ConcurrentSkipListSet();
      this.readOnlyTables = new ConcurrentSkipListSet();
      this.wrapAllow = true;
      this.metadataAllow = true;
      this.conditionOpXorAllow = false;
      this.conditionOpBitwseAllow = true;
      this.caseConditionConstAllow = false;
      this.completeInsertValuesCheck = false;
      this.insertValuesCheckSize = 3;
      this.selectLimit = -1;
      this.updateCheckColumns = new HashMap();
      this.configFromProperties(System.getProperties());
   }

   public boolean isCaseConditionConstAllow() {
      return this.caseConditionConstAllow;
   }

   public void setCaseConditionConstAllow(boolean caseConditionConstAllow) {
      this.caseConditionConstAllow = caseConditionConstAllow;
   }

   public boolean isConditionDoubleConstAllow() {
      return this.conditionDoubleConstAllow;
   }

   public void setConditionDoubleConstAllow(boolean conditionDoubleConstAllow) {
      this.conditionDoubleConstAllow = conditionDoubleConstAllow;
   }

   public boolean isConditionLikeTrueAllow() {
      return this.conditionLikeTrueAllow;
   }

   public void setConditionLikeTrueAllow(boolean conditionLikeTrueAllow) {
      this.conditionLikeTrueAllow = conditionLikeTrueAllow;
   }

   public boolean isLimitZeroAllow() {
      return this.limitZeroAllow;
   }

   public void setLimitZeroAllow(boolean limitZero) {
      this.limitZeroAllow = limitZero;
   }

   public boolean isUseAllow() {
      return this.useAllow;
   }

   public void setUseAllow(boolean useAllow) {
      this.useAllow = useAllow;
   }

   public boolean isCommitAllow() {
      return this.commitAllow;
   }

   public void setCommitAllow(boolean commitAllow) {
      this.commitAllow = commitAllow;
   }

   public boolean isRollbackAllow() {
      return this.rollbackAllow;
   }

   public void setRollbackAllow(boolean rollbackAllow) {
      this.rollbackAllow = rollbackAllow;
   }

   public boolean isIntersectAllow() {
      return this.intersectAllow;
   }

   public void setIntersectAllow(boolean intersectAllow) {
      this.intersectAllow = intersectAllow;
   }

   public boolean isMinusAllow() {
      return this.minusAllow;
   }

   public void setMinusAllow(boolean minusAllow) {
      this.minusAllow = minusAllow;
   }

   public boolean isConditionOpXorAllow() {
      return this.conditionOpXorAllow;
   }

   public void setConditionOpXorAllow(boolean conditionOpXorAllow) {
      this.conditionOpXorAllow = conditionOpXorAllow;
   }

   public String getTenantTablePattern() {
      return this.tenantTablePattern;
   }

   public void setTenantTablePattern(String tenantTablePattern) {
      this.tenantTablePattern = tenantTablePattern;
   }

   public String getTenantColumn() {
      return this.tenantColumn;
   }

   public void setTenantColumn(String tenantColumn) {
      this.tenantColumn = tenantColumn;
   }

   public TenantCallBack getTenantCallBack() {
      return this.tenantCallBack;
   }

   public void setTenantCallBack(TenantCallBack tenantCallBack) {
      this.tenantCallBack = tenantCallBack;
   }

   public boolean isMetadataAllow() {
      return this.metadataAllow;
   }

   public void setMetadataAllow(boolean metadataAllow) {
      this.metadataAllow = metadataAllow;
   }

   public boolean isWrapAllow() {
      return this.wrapAllow;
   }

   public void setWrapAllow(boolean wrapAllow) {
      this.wrapAllow = wrapAllow;
   }

   public boolean isDoPrivilegedAllow() {
      return this.doPrivilegedAllow;
   }

   public void setDoPrivilegedAllow(boolean doPrivilegedAllow) {
      this.doPrivilegedAllow = doPrivilegedAllow;
   }

   public boolean isSelectAllColumnAllow() {
      return this.selectAllColumnAllow;
   }

   public void setSelectAllColumnAllow(boolean selectAllColumnAllow) {
      this.selectAllColumnAllow = selectAllColumnAllow;
   }

   public boolean isInited() {
      return this.inited;
   }

   public WallConfig(String dir) {
      this();
      this.dir = dir;
      this.init();
   }

   public String getDir() {
      return this.dir;
   }

   public void setDir(String dir) {
      this.dir = dir;
   }

   public final void init() {
      this.loadConfig(this.dir);
   }

   public void loadConfig(String dir) {
      if (dir.endsWith("/")) {
         dir = dir.substring(0, dir.length() - 1);
      }

      WallVisitorUtils.loadResource(this.denyVariants, dir + "/deny-variant.txt");
      WallVisitorUtils.loadResource(this.denySchemas, dir + "/deny-schema.txt");
      WallVisitorUtils.loadResource(this.denyFunctions, dir + "/deny-function.txt");
      WallVisitorUtils.loadResource(this.denyTables, dir + "/deny-table.txt");
      WallVisitorUtils.loadResource(this.denyObjects, dir + "/deny-object.txt");
      WallVisitorUtils.loadResource(this.readOnlyTables, dir + "/readonly-table.txt");
      WallVisitorUtils.loadResource(this.permitFunctions, dir + "/permit-function.txt");
      WallVisitorUtils.loadResource(this.permitTables, dir + "/permit-table.txt");
      WallVisitorUtils.loadResource(this.permitSchemas, dir + "/permit-schema.txt");
      WallVisitorUtils.loadResource(this.permitVariants, dir + "/permit-variant.txt");
   }

   public boolean isNoneBaseStatementAllow() {
      return this.noneBaseStatementAllow;
   }

   public void setNoneBaseStatementAllow(boolean noneBaseStatementAllow) {
      this.noneBaseStatementAllow = noneBaseStatementAllow;
   }

   public boolean isDescribeAllow() {
      return this.describeAllow;
   }

   public void setDescribeAllow(boolean describeAllow) {
      this.describeAllow = describeAllow;
   }

   public boolean isShowAllow() {
      return this.showAllow;
   }

   public void setShowAllow(boolean showAllow) {
      this.showAllow = showAllow;
   }

   public boolean isTruncateAllow() {
      return this.truncateAllow;
   }

   public void setTruncateAllow(boolean truncateAllow) {
      this.truncateAllow = truncateAllow;
   }

   public boolean isSelectIntoAllow() {
      return this.selectIntoAllow;
   }

   public void setSelectIntoAllow(boolean selectIntoAllow) {
      this.selectIntoAllow = selectIntoAllow;
   }

   public boolean isSelectIntoOutfileAllow() {
      return this.selectIntoOutfileAllow;
   }

   public void setSelectIntoOutfileAllow(boolean selectIntoOutfileAllow) {
      this.selectIntoOutfileAllow = selectIntoOutfileAllow;
   }

   public boolean isCreateTableAllow() {
      return this.createTableAllow;
   }

   public void setCreateTableAllow(boolean createTableAllow) {
      this.createTableAllow = createTableAllow;
   }

   public boolean isDropTableAllow() {
      return this.dropTableAllow;
   }

   public void setDropTableAllow(boolean dropTableAllow) {
      this.dropTableAllow = dropTableAllow;
   }

   public boolean isAlterTableAllow() {
      return this.alterTableAllow;
   }

   public void setAlterTableAllow(boolean alterTableAllow) {
      this.alterTableAllow = alterTableAllow;
   }

   public boolean isRenameTableAllow() {
      return this.renameTableAllow;
   }

   public void setRenameTableAllow(boolean renameTableAllow) {
      this.renameTableAllow = renameTableAllow;
   }

   public boolean isSelectUnionCheck() {
      return this.selectUnionCheck;
   }

   public void setSelectUnionCheck(boolean selectUnionCheck) {
      this.selectUnionCheck = selectUnionCheck;
   }

   public boolean isSelectMinusCheck() {
      return this.selectMinusCheck;
   }

   public void setSelectMinusCheck(boolean selectMinusCheck) {
      this.selectMinusCheck = selectMinusCheck;
   }

   public boolean isSelectExceptCheck() {
      return this.selectExceptCheck;
   }

   public void setSelectExceptCheck(boolean selectExceptCheck) {
      this.selectExceptCheck = selectExceptCheck;
   }

   public boolean isSelectIntersectCheck() {
      return this.selectIntersectCheck;
   }

   public void setSelectIntersectCheck(boolean selectIntersectCheck) {
      this.selectIntersectCheck = selectIntersectCheck;
   }

   public boolean isDeleteAllow() {
      return this.deleteAllow;
   }

   public void setDeleteAllow(boolean deleteAllow) {
      this.deleteAllow = deleteAllow;
   }

   public boolean isDeleteWhereNoneCheck() {
      return this.deleteWhereNoneCheck;
   }

   public void setDeleteWhereNoneCheck(boolean deleteWhereNoneCheck) {
      this.deleteWhereNoneCheck = deleteWhereNoneCheck;
   }

   public boolean isUpdateAllow() {
      return this.updateAllow;
   }

   public void setUpdateAllow(boolean updateAllow) {
      this.updateAllow = updateAllow;
   }

   public boolean isUpdateWhereNoneCheck() {
      return this.updateWhereNoneCheck;
   }

   public void setUpdateWhereNoneCheck(boolean updateWhereNoneCheck) {
      this.updateWhereNoneCheck = updateWhereNoneCheck;
   }

   public boolean isInsertAllow() {
      return this.insertAllow;
   }

   public void setInsertAllow(boolean insertAllow) {
      this.insertAllow = insertAllow;
   }

   public boolean isReplaceAllow() {
      return this.replaceAllow;
   }

   public void setReplaceAllow(boolean replaceAllow) {
      this.replaceAllow = replaceAllow;
   }

   public boolean isSetAllow() {
      return this.setAllow;
   }

   public void setSetAllow(boolean value) {
      this.setAllow = value;
   }

   public boolean isMergeAllow() {
      return this.mergeAllow;
   }

   public void setMergeAllow(boolean mergeAllow) {
      this.mergeAllow = mergeAllow;
   }

   public boolean isMultiStatementAllow() {
      return this.multiStatementAllow;
   }

   public void setMultiStatementAllow(boolean multiStatementAllow) {
      this.multiStatementAllow = multiStatementAllow;
   }

   public boolean isSchemaCheck() {
      return this.schemaCheck;
   }

   public void setSchemaCheck(boolean schemaCheck) {
      this.schemaCheck = schemaCheck;
   }

   public boolean isTableCheck() {
      return this.tableCheck;
   }

   public void setTableCheck(boolean tableCheck) {
      this.tableCheck = tableCheck;
   }

   public boolean isFunctionCheck() {
      return this.functionCheck;
   }

   public void setFunctionCheck(boolean functionCheck) {
      this.functionCheck = functionCheck;
   }

   public boolean isVariantCheck() {
      return this.variantCheck;
   }

   public void setVariantCheck(boolean variantCheck) {
      this.variantCheck = variantCheck;
   }

   public boolean isObjectCheck() {
      return this.objectCheck;
   }

   public void setObjectCheck(boolean objectCheck) {
      this.objectCheck = objectCheck;
   }

   public boolean isCommentAllow() {
      return this.commentAllow;
   }

   public void setCommentAllow(boolean commentAllow) {
      this.commentAllow = commentAllow;
   }

   public boolean isStrictSyntaxCheck() {
      return this.strictSyntaxCheck;
   }

   public void setStrictSyntaxCheck(boolean strictSyntaxCheck) {
      this.strictSyntaxCheck = strictSyntaxCheck;
   }

   public boolean isConstArithmeticAllow() {
      return this.constArithmeticAllow;
   }

   public void setConstArithmeticAllow(boolean constArithmeticAllow) {
      this.constArithmeticAllow = constArithmeticAllow;
   }

   public Set<String> getDenyFunctions() {
      return this.denyFunctions;
   }

   public Set<String> getDenyTables() {
      return this.denyTables;
   }

   public Set<String> getDenySchemas() {
      return this.denySchemas;
   }

   public Set<String> getDenyVariants() {
      return this.denyVariants;
   }

   public Set<String> getDenyObjects() {
      return this.denyObjects;
   }

   public Set<String> getReadOnlyTables() {
      return this.readOnlyTables;
   }

   public void addReadOnlyTable(String tableName) {
      this.readOnlyTables.add(tableName);
   }

   public boolean isReadOnly(String tableName) {
      return this.readOnlyTables.contains(tableName);
   }

   public Set<String> getPermitFunctions() {
      return this.permitFunctions;
   }

   public Set<String> getPermitTables() {
      return this.permitTables;
   }

   public Set<String> getPermitSchemas() {
      return this.permitSchemas;
   }

   public Set<String> getPermitVariants() {
      return this.permitVariants;
   }

   public boolean isMustParameterized() {
      return this.mustParameterized;
   }

   public void setMustParameterized(boolean mustParameterized) {
      this.mustParameterized = mustParameterized;
   }

   public boolean isDenyObjects(String name) {
      if (!this.objectCheck) {
         return false;
      } else {
         name = WallVisitorUtils.form(name);
         return this.denyObjects.contains(name);
      }
   }

   public boolean isDenySchema(String name) {
      if (!this.schemaCheck) {
         return false;
      } else {
         name = WallVisitorUtils.form(name);
         return this.denySchemas.contains(name);
      }
   }

   public boolean isDenyFunction(String name) {
      if (!this.functionCheck) {
         return false;
      } else {
         name = WallVisitorUtils.form(name);
         return this.denyFunctions.contains(name);
      }
   }

   public boolean isCallAllow() {
      return this.callAllow;
   }

   public void setCallAllow(boolean callAllow) {
      this.callAllow = callAllow;
   }

   public boolean isHintAllow() {
      return this.hintAllow;
   }

   public void setHintAllow(boolean hintAllow) {
      this.hintAllow = hintAllow;
   }

   public boolean isSelectAllow() {
      return this.selelctAllow;
   }

   public void setSelectAllow(boolean selelctAllow) {
      this.selelctAllow = selelctAllow;
   }

   /** @deprecated */
   public boolean isSelelctAllow() {
      return this.isSelectAllow();
   }

   /** @deprecated */
   public void setSelelctAllow(boolean selelctAllow) {
      this.setSelectAllow(selelctAllow);
   }

   public boolean isSelectWhereAlwayTrueCheck() {
      return this.selectWhereAlwayTrueCheck;
   }

   public void setSelectWhereAlwayTrueCheck(boolean selectWhereAlwayTrueCheck) {
      this.selectWhereAlwayTrueCheck = selectWhereAlwayTrueCheck;
   }

   public boolean isSelectHavingAlwayTrueCheck() {
      return this.selectHavingAlwayTrueCheck;
   }

   public void setSelectHavingAlwayTrueCheck(boolean selectHavingAlwayTrueCheck) {
      this.selectHavingAlwayTrueCheck = selectHavingAlwayTrueCheck;
   }

   public boolean isConditionAndAlwayTrueAllow() {
      return this.conditionAndAlwayTrueAllow;
   }

   public void setConditionAndAlwayTrueAllow(boolean conditionAndAlwayTrueAllow) {
      this.conditionAndAlwayTrueAllow = conditionAndAlwayTrueAllow;
   }

   public boolean isConditionAndAlwayFalseAllow() {
      return this.conditionAndAlwayFalseAllow;
   }

   public void setConditionAndAlwayFalseAllow(boolean conditionAndAlwayFalseAllow) {
      this.conditionAndAlwayFalseAllow = conditionAndAlwayFalseAllow;
   }

   public boolean isDeleteWhereAlwayTrueCheck() {
      return this.deleteWhereAlwayTrueCheck;
   }

   public void setDeleteWhereAlwayTrueCheck(boolean deleteWhereAlwayTrueCheck) {
      this.deleteWhereAlwayTrueCheck = deleteWhereAlwayTrueCheck;
   }

   public boolean isUpdateWhereAlayTrueCheck() {
      return this.updateWhereAlayTrueCheck;
   }

   public void setUpdateWhereAlayTrueCheck(boolean updateWhereAlayTrueCheck) {
      this.updateWhereAlayTrueCheck = updateWhereAlayTrueCheck;
   }

   public boolean isConditionOpBitwseAllow() {
      return this.conditionOpBitwseAllow;
   }

   public void setConditionOpBitwseAllow(boolean conditionOpBitwseAllow) {
      this.conditionOpBitwseAllow = conditionOpBitwseAllow;
   }

   public void setInited(boolean inited) {
      this.inited = inited;
   }

   public boolean isLockTableAllow() {
      return this.lockTableAllow;
   }

   public void setLockTableAllow(boolean lockTableAllow) {
      this.lockTableAllow = lockTableAllow;
   }

   public boolean isStartTransactionAllow() {
      return this.startTransactionAllow;
   }

   public void setStartTransactionAllow(boolean startTransactionAllow) {
      this.startTransactionAllow = startTransactionAllow;
   }

   public boolean isCompleteInsertValuesCheck() {
      return this.completeInsertValuesCheck;
   }

   public void setCompleteInsertValuesCheck(boolean completeInsertValuesCheck) {
      this.completeInsertValuesCheck = completeInsertValuesCheck;
   }

   public int getInsertValuesCheckSize() {
      return this.insertValuesCheckSize;
   }

   public void setInsertValuesCheckSize(int insertValuesCheckSize) {
      this.insertValuesCheckSize = insertValuesCheckSize;
   }

   public boolean isBlockAllow() {
      return this.blockAllow;
   }

   public void setBlockAllow(boolean blockAllow) {
      this.blockAllow = blockAllow;
   }

   public int getSelectLimit() {
      return this.selectLimit;
   }

   public void setSelectLimit(int selectLimit) {
      this.selectLimit = selectLimit;
   }

   public void configFromProperties(Properties properties) {
       {
           String propertyValue = properties.getProperty("druid.wall.tenantColumn");
           if (propertyValue != null) {
               this.setTenantColumn(propertyValue);
           }
       }
       {
           Boolean propertyValue = Utils.getBoolean(properties, "druid.wall.selelctAllow");
           if (propertyValue != null) {
               this.setSelectAllow(propertyValue);
           }

           propertyValue = Utils.getBoolean(properties, "druid.wall.updateAllow");
           if (propertyValue != null) {
               this.setUpdateAllow(propertyValue);
           }

           propertyValue = Utils.getBoolean(properties, "druid.wall.deleteAllow");
           if (propertyValue != null) {
               this.setDeleteAllow(propertyValue);
           }

           propertyValue = Utils.getBoolean(properties, "druid.wall.insertAllow");
           if (propertyValue != null) {
               this.setInsertAllow(propertyValue);
           }

           propertyValue = Utils.getBoolean(properties, "druid.wall.multiStatementAllow");
           if (propertyValue != null) {
               this.setMultiStatementAllow(propertyValue);
           }
       }
       {
           Integer propertyValue = Utils.getInteger(properties, "druid.wall.selectLimit");
           if (propertyValue != null) {
               this.setSelectLimit(propertyValue);
           }
       }
       {
           String propertyValue = properties.getProperty("druid.wall.updateCheckColumns");
           if (propertyValue != null) {
               String[] items = propertyValue.split(",");

               for (String item : items) {
                   this.addUpdateCheckCoumns(item);
               }
           }
       }
       {
           Boolean propertyValue = Utils.getBoolean(properties, "druid.wall.updateWhereNoneCheck");
           if (propertyValue != null) {
               this.setUpdateWhereNoneCheck(propertyValue);
           }

           propertyValue = Utils.getBoolean(properties, "druid.wall.deleteWhereNoneCheck");
           if (propertyValue != null) {
               this.setDeleteWhereNoneCheck(propertyValue);
           }
       }
   }

   public void addUpdateCheckCoumns(String columnInfo) {
      String[] items = columnInfo.split("\\.");
      if (items.length == 2) {
         String table = SQLUtils.normalize(items[0]).toLowerCase();
         String column = SQLUtils.normalize(items[1]).toLowerCase();
         Set<String> columns = (Set)this.updateCheckColumns.get(table);
         if (columns == null) {
            columns = new LinkedHashSet();
            this.updateCheckColumns.put(table, columns);
         }

         columns.add(column);
      }
   }

   public boolean isUpdateCheckTable(String tableName) {
      if (this.updateCheckColumns.isEmpty()) {
         return false;
      } else {
         String tableNameLower = SQLUtils.normalize(tableName).toLowerCase();
         return this.updateCheckColumns.containsKey(tableNameLower);
      }
   }

   public Set<String> getUpdateCheckTable(String tableName) {
      if (this.updateCheckColumns.isEmpty()) {
         return null;
      } else {
         String tableNameLower = SQLUtils.normalize(tableName).toLowerCase();
         return (Set)this.updateCheckColumns.get(tableNameLower);
      }
   }

   public WallUpdateCheckHandler getUpdateCheckHandler() {
      return this.updateCheckHandler;
   }

   public void setUpdateCheckHandler(WallUpdateCheckHandler updateCheckHandler) {
      this.updateCheckHandler = updateCheckHandler;
   }

   public interface TenantCallBack {
      Object getTenantValue(StatementType var1, String var2);

      String getTenantColumn(StatementType var1, String var2);

      String getHiddenColumn(String var1);

      void filterResultsetTenantColumn(Object var1);

      public static enum StatementType {
         SELECT,
         UPDATE,
         INSERT,
         DELETE;
      }
   }
}
