package com.palacesun.engine.gateway.netty.framework;

import com.palacesun.engine.gateway.netty.SSLContextFactory;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.ssl.SslHandler;
import javax.net.ssl.SSLEngine;

public class HttpInitializer extends ChannelInitializer<SocketChannel> {
   protected void initChannel(SocketChannel channel) throws Exception {
      ChannelPipeline pipeline = channel.pipeline();
      SSLEngine sslEngine = SSLContextFactory.getSslContext().createSSLEngine();
      sslEngine.setUseClientMode(false);
      pipeline.addLast(new ChannelHandler[]{new SslHandler(sslEngine)});
      pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
      pipeline.addLast("httpAggregator", new HttpObjectAggregator(524288));
      pipeline.addLast(new ChannelHandler[]{new HttpRequestHandler()});
   }
}
