package com.palacesun.engine.maskingtool;

import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringTool {
   public static final String[] EMPTY_STRING_ARRAY = new String[0];
   private static final String[] hexDigits = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};

   public static String generatePassword(String inputString) {
      return encodeByMD5(inputString);
   }

   public static String getTablePrimaryKey() {
      String uuid = UUID.randomUUID().toString().replace("-", "");
      return uuid;
   }

   public static String encodeByMD5(String originString) {
      if (originString != null) {
         try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] results = md.digest(originString.getBytes());
            String resultString = byteArrayToHexString(results);
            return resultString.toUpperCase();
         } catch (Exception var4) {
         }
      }

      return null;
   }

   private static String byteArrayToHexString(byte[] b) {
      StringBuffer resultSb = new StringBuffer();

      for(int i = 0; i < b.length; ++i) {
         resultSb.append(byteToHexString(b[i]));
      }

      return resultSb.toString();
   }

   private static String byteToHexString(byte b) {
      int n = b;
      if (b < 0) {
         n = 256 + b;
      }

      int d1 = n / 16;
      int d2 = n % 16;
      return hexDigits[d1] + hexDigits[d2];
   }

   public static String charTransfor(String s) {
      String str = null;
      if (".".equals(s)) {
         str = "u002E";
      } else if ("$".equals(s)) {
         str = "u0024";
      } else if ("^".equals(s)) {
         str = "u005E";
      } else if ("{".equals(s)) {
         str = "u007B";
      } else if ("[".equals(s)) {
         str = "u005B";
      } else if ("(".equals(s)) {
         str = "u0028";
      } else if ("|".equals(s)) {
         str = "\\|";
      } else if (")".equals(s)) {
         str = "u0029";
      } else if ("*".equals(s)) {
         str = "u002A";
      } else if ("+".equals(s)) {
         str = "u002B";
      } else if ("?".equals(s)) {
         str = "u003F";
      }

      return str != null ? str : s;
   }

   public static String stringToAscii(String str) {
      char[] chars = str.toCharArray();

      for(int i = 0; i < chars.length; ++i) {
      }

      return null;
   }

   public static boolean emptyOrNull(String str) {
      return str != null && !"".equals(str) ? Boolean.FALSE : Boolean.TRUE;
   }

   public static List<Integer> getSubStringIndex(String str, String substring) {
      int length = substring.length();
      if (length == 0) {
         return null;
      } else {
         List<Integer> list = new ArrayList();
         int index = 0;

         for(int i = 0; i < str.length(); index = i++) {
            String temp = str.substring(index, index + length);
            if (temp.equals(substring)) {
               list.add(index);
               i += length;
            }
         }

         return list;
      }
   }

   public static List<String> widthSpliter(String inputString, int byteLength) {
      List list = null;
      int length = inputString.length();
      int size = length / byteLength;

      for(int i = 0; i < size; ++i) {
         if (list == null) {
            list = new ArrayList();
         }

         String substring = inputString.substring(i * byteLength, i * byteLength + byteLength);
         list.add(substring);
      }

      return list;
   }

   public static List<String> charSpliter(String inputString, String ch) {
      String[] array = inputString.split(ch);
      List<String> list = Arrays.asList(array);
      return list;
   }

   public static List<String> widthSpliter(String str, String w) {
      List<String> list = new ArrayList();
      String[] width = w.split(",");
      int start = 0;

      for(int i = 0; i < width.length; ++i) {
         int end = Integer.valueOf(width[i]);
         list.add(str.substring(start, end));
         start = end;
      }

      return list;
   }

   public static List<String> widthSpliter(String str, List<String> w) {
      StringBuffer sb = new StringBuffer();
      int temp = 0;

      for(int i = 0; i < w.size(); ++i) {
         if (i == 0) {
            sb.append(String.valueOf(Integer.valueOf((String)w.get(i))));
            temp = Integer.valueOf((String)w.get(i));
         } else {
            sb.append(",");
            temp += Integer.valueOf((String)w.get(i));
            sb.append(String.valueOf(temp));
         }
      }

      return widthSpliter(str, sb.toString());
   }

   public static List<List<String>> widthSpliter(List<String> str, List<String> w) {
      List<List<String>> list = new ArrayList();

      for(String item : str) {
         List<String> temp = widthSpliter(item, w);
         list.add(temp);
      }

      List<List<String>> result = new ArrayList();

      for(int i = 0; i < w.size(); ++i) {
         List<String> temp = new ArrayList();

         for(List<String> item : list) {
            temp.add(item.get(i));
         }

         result.add(temp);
      }

      return result;
   }

   public static int substringNumbers(String str, String substring) {
      if (str.indexOf(substring) == -1) {
         return 0;
      } else if (str.indexOf(substring) != -1) {
         String uuid = UUID.randomUUID().toString().replaceAll("-", "");
         String s = str.replaceAll(substring, uuid);
         String[] arr = s.split(uuid);
         return arr.length - 1;
      } else {
         return 0;
      }
   }

   public static List<String> splitString(String str, char split) {
      List<String> list = new ArrayList();
      int index = 0;

      for(int i = 0; i < str.length(); ++i) {
         if (str.charAt(i) == split) {
            list.add(str.substring(index, i));
            index = i + 1;
         }
      }

      list.add(str.substring(index, str.length()));
      return list;
   }

   public static List<List<String>> splitString(List<String> str, String split, int num) {
      List<List<String>> list = new ArrayList();
      List<List<String>> result = new ArrayList();

      for(String item : str) {
         List<String> temp = splitString(item, split, false);
         if (temp.size() == num) {
            list.add(temp);
         }
      }

      int size = ((List)list.get(0)).size();

      for(int i = 0; i < size; ++i) {
         List<String> temp = new ArrayList();

         for(List<String> item : list) {
            temp.add(item.get(i));
         }

         result.add(temp);
      }

      return result;
   }

   public static List<String> splitString(String str, String split, boolean group) {
      List<String> list = new ArrayList();
      int index = 0;
      if (group) {
         for(int i = 0; i < str.length() && split.length() + i <= str.length(); ++i) {
            StringBuffer ac = new StringBuffer();

            for(int j = 0; j < split.length(); ++j) {
               if (!isLetterDigitOrChinese(split.substring(j, j + 1))) {
                  ac.append("\\");
               }

               ac.append(split.substring(j, j + 1));
            }

            String[] arr = str.split(ac.toString());
            list = Arrays.asList(arr);
         }
      } else {
         char[] c = split.toCharArray();
         Arrays.sort(c);

         for(int i = 0; i < str.length(); ++i) {
            if (Arrays.binarySearch(c, str.charAt(i)) >= 0) {
               list.add(str.substring(index, i));
               index = i + 1;
            }
         }

         list.add(str.substring(index, str.length()));
      }

      return list;
   }

   public static List<String> splitString(String str, String split, boolean group, String escape) {
      if (escape != null && !"".equals(escape)) {
         List<String> list = new ArrayList();
         int index = 0;
         if (group) {
            for(int i = 0; i < str.length() && split.length() + i <= str.length(); ++i) {
               StringBuffer ac = new StringBuffer();

               for(int j = 0; j < split.length(); ++j) {
                  if (!isLetterDigitOrChinese(split.substring(j, j + 1))) {
                     ac.append("\\");
                  }

                  ac.append(split.substring(j, j + 1));
               }

               String[] arr = str.split(ac.toString());
               list = Arrays.asList(arr);
            }
         } else {
            char[] c = split.toCharArray();
            Arrays.sort(c);

            for(int i = 0; i < str.length(); ++i) {
               if (i > 0) {
                  String last = str.substring(i - 1, i);
                  if (last.equals(escape)) {
                     continue;
                  }
               }

               if (Arrays.binarySearch(c, str.charAt(i)) >= 0) {
                  list.add(str.substring(index, i));
                  index = i + 1;
               }
            }

            list.add(str.substring(index, str.length()));
         }

         return list;
      } else {
         return splitString(str, split, group);
      }
   }

   public static boolean isLetterDigitOrChinese(String str) {
      String regex = "^[a-z0-9A-Z一-龥]+$";
      return str.matches(regex);
   }

   public static List<String> splitString(String str, String split, boolean group, String escape, String limit) {
      if (limit != null && !"".equals(limit)) {
         List<Integer> indexlist = getSubStringIndex(str, limit);
         List<String> list = new ArrayList();
         int index = 0;
         if (group) {
            for(int i = 0; i < str.length() && split.length() + i <= str.length(); ++i) {
               StringBuffer ac = new StringBuffer();

               for(int j = 0; j < split.length(); ++j) {
                  if (!isLetterDigitOrChinese(split.substring(j, j + 1))) {
                     ac.append("\\");
                  }

                  ac.append(split.substring(j, j + 1));
               }

               String[] arr = str.split(ac.toString());
               list = Arrays.asList(arr);
            }
         } else {
            char[] c = split.toCharArray();
            Arrays.sort(c);

            for(int i = 0; i < str.length(); ++i) {
               if (i > 0) {
                  String last = str.substring(i - 1, i);
                  if (last.equals(escape)) {
                     continue;
                  }
               }

               if (Arrays.binarySearch(c, str.charAt(i)) >= 0 && !checkLimit(i, indexlist)) {
                  list.add(str.substring(index, i));
                  index = i + 1;
               }
            }

            list.add(str.substring(index, str.length()));
         }

         return list;
      } else {
         return splitString(str, split, group, escape);
      }
   }

   public static boolean checkLimit(int index, List<Integer> indexlist) {
      boolean result = false;

      for(int i = 0; i < indexlist.size(); ++i) {
         if (index > (Integer)indexlist.get(i) && index < (Integer)indexlist.get(i + 1)) {
            result = true;
            break;
         }

         ++i;
      }

      return result;
   }

   public static List<String> toUpperCaseList(List<String> list) {
      List<String> newlist = new ArrayList();

      for(String str : list) {
         newlist.add(str.toUpperCase());
      }

      return newlist;
   }

   public static String parseQuoteCharacter(String quoteCharacter) {
      if ("none".equalsIgnoreCase(quoteCharacter)) {
         quoteCharacter = "";
      } else if ("Single".equalsIgnoreCase(quoteCharacter)) {
         quoteCharacter = "'";
      } else if ("Double".equalsIgnoreCase(quoteCharacter)) {
         quoteCharacter = "\"";
      } else {
         quoteCharacter = "";
      }

      return quoteCharacter;
   }

   public static boolean isEnglish(String charaString) {
      return charaString.matches("^[a-zA-Z]*");
   }

   public static boolean isChinese(String str) {
      String regEx = "[\\u4e00-\\u9fa5]+";
      Pattern p = Pattern.compile(regEx);
      Matcher m = p.matcher(str);
      return m.find();
   }

   public static int getCharacterPosition(String str, String paramString, int paramInt) {
      Matcher slashMatcher = Pattern.compile(paramString).matcher(str);
      int mIdx = 0;

      while(slashMatcher.find()) {
         ++mIdx;
         if (mIdx == paramInt) {
            break;
         }
      }

      return slashMatcher.start();
   }

   public static String[] arraySort(String[] input) {
      for(int i = 0; i < input.length - 1; ++i) {
         for(int j = 0; j < input.length - i - 1; ++j) {
            if (input[j].compareTo(input[j + 1]) > 0) {
               String temp = input[j];
               input[j] = input[j + 1];
               input[j + 1] = temp;
            }
         }
      }

      return input;
   }

   private static String[] splitWorker(String str, String separatorChars, int max, boolean preserveAllTokens) {
      if (str == null) {
         return null;
      } else {
         int len = str.length();
         if (len == 0) {
            return EMPTY_STRING_ARRAY;
         } else {
            List list = new ArrayList();
            int sizePlus1 = 1;
            int i = 0;
            int start = 0;
            boolean match = false;
            boolean lastMatch = false;
            if (separatorChars != null) {
               if (separatorChars.length() != 1) {
                  while(i + separatorChars.length() <= len) {
                     if (separatorChars.indexOf(str.substring(i, i + separatorChars.length())) >= 0) {
                        if (match || preserveAllTokens) {
                           lastMatch = true;
                           if (sizePlus1++ == max) {
                              i = len;
                              lastMatch = false;
                           }

                           list.add(str.substring(start, i));
                           match = false;
                        }

                        i += separatorChars.length();
                        start = i;
                     } else {
                        lastMatch = false;
                        match = true;
                        ++i;
                     }
                  }
               } else {
                  char sep = separatorChars.charAt(0);

                  while(i < len) {
                     if (str.charAt(i) == sep) {
                        if (match || preserveAllTokens) {
                           lastMatch = true;
                           if (sizePlus1++ == max) {
                              i = len;
                              lastMatch = false;
                           }

                           list.add(str.substring(start, i));
                           match = false;
                        }

                        ++i;
                        start = i;
                     } else {
                        lastMatch = false;
                        match = true;
                        ++i;
                     }
                  }
               }
            } else {
               while(i < len) {
                  if (Character.isWhitespace(str.charAt(i))) {
                     if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                           i = len;
                           lastMatch = false;
                        }

                        list.add(str.substring(start, i));
                        match = false;
                     }

                     ++i;
                     start = i;
                  } else {
                     lastMatch = false;
                     match = true;
                     ++i;
                  }
               }
            }

            if (match || preserveAllTokens && lastMatch) {
               list.add(str.substring(start, len));
            }

            return (String[])list.toArray(new String[list.size()]);
         }
      }
   }

   public static String[] splitPreserveAllTokens(String str, String separatorChars, int i) {
      return splitWorker(str, separatorChars, i, true);
   }
}
