package com.palacesun.engine.wrapper;

import bean.Column;
import com.palacesun.engine.common.PreparedStatementInformation;
import com.palacesun.engine.common.ResultSetInformation;
import com.palacesun.engine.common.StatementInformation;
import com.palacesun.engine.event.JdbcEventListener;
import com.palacesun.engine.gateway.EncryptionGatewayManager;
import com.palacesun.engine.gateway.GatewayContext;
import com.palacesun.engine.test.DbCache;
import com.palacesun.engine.test.TestJdbcEventListener;
import com.alibaba.fastjson.JSON;
import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.parser.SQLParserUtils;
import com.alibaba.druid.sql.parser.SQLType;
import com.alibaba.druid.stat.TableStat;
import com.palacesun.masking.log.access.AccessContext;
import com.palacesun.masking.tools.EngineUtil;
import com.palacesun.masking.tools.InsertSqlVaulesUtil;
import com.palacesun.masking.tools.JdbcUtil;
import com.palacesun.masking.tools.ruleload.RuleLoadUtil;
import com.palacesun.masking.tools.thkms.util.gmhelper.SM3Utils;
import com.palacesun.masking.vo.Columninfo;
import com.palacesun.masking.vo.ConnectionInfo;
import com.palacesun.masking.vo.JsonRootBean;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import util.SqlUtil;
import util.sqlparse.visitor.common.scope.ReplaceInfo;

public class PreparedStatementWrapper extends StatementWrapper implements PreparedStatement {
    private final PreparedStatement delegate;

    private final PreparedStatementInformation statementInformation;

    protected static Logger logger = Logger.getLogger(PreparedStatementWrapper.class.getName());

    public static Map<String, Columninfo> sqlIndexKeyMap = new HashMap<String, Columninfo>();

    private static final String ENCRYPT_LIKE_OPEN = EncryptionGatewayManager.getParameterValue("encryption.like.open");

    private static final String ENCRYPT_SEPARATOR = EncryptionGatewayManager.getParameterValue("encryption.separator");

    public static PreparedStatement wrap(PreparedStatement delegate, PreparedStatementInformation preparedStatementInformation, JdbcEventListener eventListener) {
        if (delegate == null)
            return null;
        return new PreparedStatementWrapper(delegate, preparedStatementInformation, eventListener);
    }

    protected PreparedStatementWrapper(PreparedStatement delegate, PreparedStatementInformation preparedStatementInformation, JdbcEventListener eventListener) {
        super(delegate, (StatementInformation)preparedStatementInformation, eventListener);
        this.delegate = delegate;
        this.statementInformation = preparedStatementInformation;
        if (this.statementInformation.context == null)
            this.statementInformation.context = new AccessContext((StatementInformation)this.statementInformation);
        this.sqlBuffer = this.statementInformation.context.getBuffer();
    }

    public ResultSet executeQuery() throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        try {
            this.eventListener.onBeforeExecuteQuery(this.statementInformation);
            return ResultSetWrapper.wrap(this.delegate.executeQuery(), new ResultSetInformation((StatementInformation)this.statementInformation), this.eventListener);
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            this.eventListener.onAfterExecuteQuery(this.statementInformation, System.nanoTime() - start, e);
        }
    }

    public int executeUpdate() throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        int rowCount = 0;
        try {
            this.eventListener.onBeforeExecuteUpdate(this.statementInformation);
            rowCount = this.delegate.executeUpdate();
            return rowCount;
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            this.eventListener.onAfterExecuteUpdate(this.statementInformation, System.nanoTime() - start, rowCount, e);
        }
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        SQLException e = null;
        try {
            parameterIndex = getParameterIndex(parameterIndex);
            this.sqlBuffer.setValueSqlType(0, parameterIndex, sqlType);
            this.delegate.setNull(parameterIndex, sqlType);
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, null, e);
        }
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        SQLException e = null;
        try {
            parameterIndex = getParameterIndex(parameterIndex);
            this.sqlBuffer.setValue(1, parameterIndex, Boolean.valueOf(x));
            this.delegate.setBoolean(parameterIndex, x);
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, Boolean.valueOf(x), e);
        }
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        SQLException e = null;
        try {
            parameterIndex = getParameterIndex(parameterIndex);
            this.sqlBuffer.setValue(2, parameterIndex, Byte.valueOf(x));
            this.delegate.setByte(parameterIndex, x);
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, Byte.valueOf(x), e);
        }
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        SQLException e = null;
        try {
            parameterIndex = getParameterIndex(parameterIndex);
            this.sqlBuffer.setValue(7, parameterIndex, Short.valueOf(x));
            this.delegate.setShort(parameterIndex, x);
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, Short.valueOf(x), e);
        }
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        SQLException e = null;
        try {
            parameterIndex = getParameterIndex(parameterIndex);
            this.sqlBuffer.setValue(4, parameterIndex, Integer.valueOf(x));
            this.delegate.setInt(parameterIndex, x);
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, Integer.valueOf(x), e);
        }
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        SQLException e = null;
        try {
            parameterIndex = getParameterIndex(parameterIndex);
            this.sqlBuffer.setValue(3, parameterIndex, Long.valueOf(x));
            this.delegate.setLong(parameterIndex, x);
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, Long.valueOf(x), e);
        }
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        SQLException e = null;
        try {
            parameterIndex = getParameterIndex(parameterIndex);
            this.sqlBuffer.setValue(5, parameterIndex, Float.valueOf(x));
            this.delegate.setFloat(parameterIndex, x);
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, Float.valueOf(x), e);
        }
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        SQLException e = null;
        try {
            parameterIndex = getParameterIndex(parameterIndex);
            this.sqlBuffer.setValue(6, parameterIndex, Double.valueOf(x));
            this.delegate.setDouble(parameterIndex, x);
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, Double.valueOf(x), e);
        }
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        SQLException e = null;
        try {
            parameterIndex = getParameterIndex(parameterIndex);
            this.sqlBuffer.setValue(8, parameterIndex, x);
            this.delegate.setBigDecimal(parameterIndex, x);
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    private int getParameterIndex(int parameterIndex) {
        int whereLocation = 100000000;
        boolean where = false;
        Map<String, Integer> digestMap = this.statementInformation.getDigestMap();
        if (!digestMap.isEmpty()) {
            for (String key : digestMap.keySet()) {
                Integer value = digestMap.get(key);
                if (value.intValue() < whereLocation)
                    whereLocation = value.intValue();
            }
            if (parameterIndex >= whereLocation)
                where = true;
        }
        if (where)
            parameterIndex += digestMap.size();
        return parameterIndex;
    }

    public void setString(int parameterIndex, String x1) throws SQLException {
        SQLException e = null;
        String x = null;
        Map<String, Integer> digestMap = null;
        Map<String, String> map = null;
        boolean where = false;
        String tableAndColumnName = null;
        String mathKey = null;
        try {
            String sql = this.statementInformation.getSql();
            boolean needSqlParse = DbCache.isNeedSqlParse(sql, (StatementInformation)this.statementInformation);
            RuleLoadUtil.writeLog("@@"+ sql);
                    RuleLoadUtil.writeLog("@@"+ needSqlParse);
            if (!needSqlParse) {
                this.sqlBuffer.setValue(9, parameterIndex, x1, x1);
                this.delegate.setString(parameterIndex, x1);
                return;
            }
            Columninfo columninfo = sqlIndexKeyMap.get(sql + "_" + parameterIndex);
            if (columninfo == null) {
                map = encData(this.statementInformation, parameterIndex, x1);
                x = map.get("x");
                tableAndColumnName = map.get("tableAndColumnName");
                mathKey = map.get("mathKey");
            } else if (columninfo.getSecretkey() != null) {
                x = (String)EngineUtil.exeEngine(columninfo, null, Boolean.valueOf(false), x1, Boolean.valueOf(true));
                tableAndColumnName = columninfo.getColumnname();
                mathKey = columninfo.getId();
            } else {
                x = x1;
                tableAndColumnName = columninfo.getColumnname();
                mathKey = columninfo.getId();
            }
            this.sqlBuffer.setValue(9, parameterIndex, x, x1);
            this.delegate.setString(parameterIndex, x);
            if (EngineUtil.digestMap.isEmpty())
                return;
            int whereLocation = 100000000;
            digestMap = this.statementInformation.getDigestMap();
            if (!digestMap.isEmpty()) {
                for (String key : digestMap.keySet()) {
                    Integer value = digestMap.get(key);
                    if (value.intValue() < whereLocation)
                        whereLocation = value.intValue();
                }
                if (parameterIndex >= whereLocation)
                    where = true;
            }
        } catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.sqlBuffer.setValue(9, parameterIndex, x, x1);
            this.delegate.setString(parameterIndex, x);
            if (!digestMap.isEmpty() && !where && tableAndColumnName != null && digestMap.get(tableAndColumnName) != null) {
                String digestValue = abstractData(mathKey, x);
                this.sqlBuffer.setValue(9, ((Integer)digestMap.get(tableAndColumnName)).intValue(), digestValue, null);
                this.delegate.setString(((Integer)digestMap.get(tableAndColumnName)).intValue(), digestValue);
            }
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } catch (Exception ex) {
            ex.printStackTrace();
        } finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        SQLException e = null;
        try {
            parameterIndex = getParameterIndex(parameterIndex);
            this.sqlBuffer.setValue(10, parameterIndex, x);
            this.delegate.setBytes(parameterIndex, x);
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        SQLException e = null;
        try {
            parameterIndex = getParameterIndex(parameterIndex);
            this.sqlBuffer.setValue(11, parameterIndex, x);
            this.delegate.setDate(parameterIndex, x);
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        SQLException e = null;
        try {
            parameterIndex = getParameterIndex(parameterIndex);
            this.sqlBuffer.setValue(12, parameterIndex, x);
            this.delegate.setTime(parameterIndex, x);
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        SQLException e = null;
        try {
            parameterIndex = getParameterIndex(parameterIndex);
            this.sqlBuffer.setValue(13, parameterIndex, x);
            this.delegate.setTimestamp(parameterIndex, x);
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(14, parameterIndex, x, length, "byte[ascii]");
            this.delegate.setAsciiStream(parameterIndex, x, length);
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(14, parameterIndex, x, length, "byte[ascii]");
            this.delegate.setUnicodeStream(parameterIndex, x, length);
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(14, parameterIndex, x, length, "byte[]");
            this.delegate.setBinaryStream(parameterIndex, x, length);
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    public void clearParameters() throws SQLException {
        this.delegate.clearParameters();
    }

    public void setObject(int parameterIndex, Object x1, int targetSqlType) throws SQLException {
        SQLException e = null;
        Object x = null;
        Map<String, Integer> digestMap = null;
        Map<String, String> map = null;
        boolean where = false;
        String tableAndColumnName = null;
        String mathKey = null;
        try {
            String sql = this.statementInformation.getSql();
            Columninfo columninfo = sqlIndexKeyMap.get(sql + "_" + parameterIndex);
            if (columninfo == null) {
                if (x1 instanceof String) {
                    map = encData(this.statementInformation, parameterIndex, x1.toString());
                    x = map.get("x");
                    tableAndColumnName = map.get("tableAndColumnName");
                    mathKey = map.get("mathKey");
                } else {
                    x = x1;
                }
            } else if (columninfo.getSecretkey() != null) {
                x = EngineUtil.exeEngine(columninfo, null, Boolean.valueOf(false), x1, Boolean.valueOf(true));
                tableAndColumnName = columninfo.getColumnname();
                mathKey = columninfo.getId();
            } else {
                x = x1;
                tableAndColumnName = columninfo.getColumnname();
                mathKey = columninfo.getId();
            }
            this.sqlBuffer.setValue(-1, parameterIndex, x, x1, targetSqlType);
            this.delegate.setObject(parameterIndex, x, targetSqlType);
            if (EngineUtil.digestMap.isEmpty())
                return;
            int whereLocation = 100000000;
            digestMap = this.statementInformation.getDigestMap();
            if (!digestMap.isEmpty()) {
                for (String key : digestMap.keySet()) {
                    Integer value = digestMap.get(key);
                    if (value.intValue() < whereLocation)
                        whereLocation = value.intValue();
                }
                if (parameterIndex >= whereLocation)
                    where = true;
            }
            if (!digestMap.isEmpty() && !where && tableAndColumnName != null && digestMap.get(tableAndColumnName) != null) {
                String digestValue = abstractData(mathKey, x.toString());
                this.sqlBuffer.setValue(-1, ((Integer)digestMap.get(tableAndColumnName)).intValue(), digestValue, null);
                this.delegate.setString(((Integer)digestMap.get(tableAndColumnName)).intValue(), digestValue);
            }
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } catch (Exception ex) {
            ex.printStackTrace();
        } finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    public void setObject(int parameterIndex, Object x1) throws SQLException {
        SQLException e = null;
        Object x = null;
        Map<String, Integer> digestMap = null;
        Map<String, String> map = null;
        boolean where = false;
        String tableAndColumnName = null;
        String mathKey = null;
        try {
            String sql = this.statementInformation.getSql();
            boolean needSqlParse = DbCache.isNeedSqlParse(sql, (StatementInformation)this.statementInformation);
            if (!needSqlParse) {
                this.sqlBuffer.setValue(-1, parameterIndex, x1, x1);
                this.delegate.setObject(parameterIndex, x1);
                return;
            }
            Columninfo columninfo = sqlIndexKeyMap.get(sql + "_" + parameterIndex);
            if (columninfo == null) {
                if (x1 instanceof String) {
                    map = encData(this.statementInformation, parameterIndex, x1.toString());
                    x = map.get("x");
                    tableAndColumnName = map.get("tableAndColumnName");
                    mathKey = map.get("mathKey");
                } else {
                    x = x1;
                }
            } else if (columninfo.getSecretkey() != null) {
                x = EngineUtil.exeEngine(columninfo, null, Boolean.valueOf(false), x1, Boolean.valueOf(true));
                tableAndColumnName = columninfo.getColumnname();
                mathKey = columninfo.getId();
            } else {
                x = x1;
                tableAndColumnName = columninfo.getColumnname();
                mathKey = columninfo.getId();
            }
            this.sqlBuffer.setValue(-1, parameterIndex, x, x1);
            this.delegate.setObject(parameterIndex, x);
            if (EngineUtil.digestMap.isEmpty())
                return;
            int whereLocation = 100000000;
            digestMap = this.statementInformation.getDigestMap();
            if (!digestMap.isEmpty()) {
                for (String key : digestMap.keySet()) {
                    Integer value = digestMap.get(key);
                    if (value.intValue() < whereLocation)
                        whereLocation = value.intValue();
                }
                if (parameterIndex >= whereLocation)
                    where = true;
            }
            if (!digestMap.isEmpty() && !where && tableAndColumnName != null && digestMap.get(tableAndColumnName) != null) {
                String digestValue = abstractData(mathKey, x.toString());
                this.sqlBuffer.setValue(-1, ((Integer)digestMap.get(tableAndColumnName)).intValue(), digestValue, null);
                this.delegate.setString(((Integer)digestMap.get(tableAndColumnName)).intValue(), digestValue);
            }
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } catch (Exception ex) {
            ex.printStackTrace();
        } finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    public boolean execute() throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        try {
            this.eventListener.onBeforeExecute(this.statementInformation);
            return this.delegate.execute();
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            this.eventListener.onAfterExecute(this.statementInformation, System.nanoTime() - start, e);
        }
    }

    public void addBatch() throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        try {
            this.eventListener.onBeforeAddBatch(this.statementInformation);
            this.delegate.addBatch();
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            this.eventListener.onAfterAddBatch(this.statementInformation, System.nanoTime() - start, e);
        }
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(15, parameterIndex, reader, Integer.valueOf(length));
            this.delegate.setCharacterStream(parameterIndex, reader, length);
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, reader, e);
        }
    }

    public void setRef(int parameterIndex, Ref x) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(16, parameterIndex, x);
            this.delegate.setRef(parameterIndex, x);
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(18, parameterIndex, x);
            this.delegate.setBlob(parameterIndex, x);
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    public void setClob(int parameterIndex, Clob x2) throws SQLException {
        SQLException e = null;
        String x = null;
        String x1 = null;
        try {
            x1 = clobToString(x2);
        } catch (Exception exception) {
            exception.printStackTrace();
        }
        Map<String, Integer> digestMap = null;
        Map<String, String> map = null;
        boolean where = false;
        try {
            map = encData(this.statementInformation, parameterIndex, x1);
            x = map.get("x");
            int whereLocation = 100000000;
            digestMap = this.statementInformation.getDigestMap();
            if (!digestMap.isEmpty()) {
                for (String key : digestMap.keySet()) {
                    Integer value = digestMap.get(key);
                    if (value.intValue() < whereLocation)
                        whereLocation = value.intValue();
                }
                if (parameterIndex >= whereLocation)
                    where = true;
            }
        } catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.sqlBuffer.setValue(9, parameterIndex, x, x1);
            this.delegate.setString(parameterIndex, x);
            RuleLoadUtil.writeLog("@@"+ digestMap);
                    RuleLoadUtil.writeLog("@@"+ where);
            if (digestMap != null && !digestMap.isEmpty() && !where && map != null && map.get("tableAndColumnName") != null && digestMap.get(map.get("tableAndColumnName")) != null)
                try {
                    String digestValue = abstractData(map.get("mathKey"), x);
                    this.sqlBuffer.setValue(9, ((Integer)digestMap.get(map.get("tableAndColumnName"))).intValue(), digestValue, null);
                    this.delegate.setString(((Integer)digestMap.get(map.get("tableAndColumnName"))).intValue(), digestValue);
                } catch (Exception exception) {
                    exception.printStackTrace();
                }
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    public String clobToString(Clob clob) throws Exception {
        StringWriter writer = new StringWriter();
        Reader reader = null;
        try {
            reader = clob.getCharacterStream();
            char[] buffer = new char[1024];
            int bytesRead;
            while ((bytesRead = reader.read(buffer)) != -1)
                writer.write(buffer, 0, bytesRead);
        } finally {
            if (reader != null)
                reader.close();
        }
        return writer.toString();
    }

    public void setArray(int parameterIndex, Array x) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(20, parameterIndex, x);
            this.delegate.setArray(parameterIndex, x);
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(11, parameterIndex, x, cal);
            this.delegate.setDate(parameterIndex, x, cal);
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(12, parameterIndex, x, cal);
            this.delegate.setTime(parameterIndex, x, cal);
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(13, parameterIndex, x, cal);
            this.delegate.setTimestamp(parameterIndex, x, cal);
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(0, parameterIndex, sqlType, typeName);
            this.delegate.setNull(parameterIndex, sqlType, typeName);
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, null, e);
        }
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(21, parameterIndex, x);
            this.delegate.setURL(parameterIndex, x);
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(17, parameterIndex, x);
            this.delegate.setRowId(parameterIndex, x);
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    public void setNString(int parameterIndex, String value) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(9, parameterIndex, value);
            this.delegate.setNString(parameterIndex, value);
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, value, e);
        }
    }

    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(15, parameterIndex, value, length, "string");
            this.delegate.setNCharacterStream(parameterIndex, value, length);
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, value, e);
        }
    }

    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(22, parameterIndex, value);
            this.delegate.setNClob(parameterIndex, value);
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, value, e);
        }
    }

    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(19, parameterIndex, reader, length, "string");
            this.delegate.setClob(parameterIndex, reader, length);
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, reader, e);
        }
    }

    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(14, parameterIndex, inputStream, length, "byte[]");
            this.delegate.setBlob(parameterIndex, inputStream, length);
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, inputStream, e);
        }
    }

    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(15, parameterIndex, reader, length, "string");
            this.delegate.setNClob(parameterIndex, reader, length);
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, reader, e);
        }
    }

    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(23, parameterIndex, xmlObject);
            this.delegate.setSQLXML(parameterIndex, xmlObject);
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, xmlObject, e);
        }
    }

    public void setObject(int parameterIndex, Object x1, int targetSqlType, int scaleOrLength) throws SQLException {
        SQLException e = null;
        Object x = null;
        Map<String, Integer> digestMap = null;
        Map<String, String> map = null;
        boolean where = false;
        String tableAndColumnName = null;
        String mathKey = null;
        try {
            String sql = this.statementInformation.getSql();
            boolean needSqlParse = DbCache.isNeedSqlParse(sql, (StatementInformation)this.statementInformation);
            if (!needSqlParse) {
                this.sqlBuffer.setValue(-1, parameterIndex, x1, x1, targetSqlType, scaleOrLength);
                this.delegate.setObject(parameterIndex, x1, targetSqlType, scaleOrLength);
                return;
            }
            Columninfo columninfo = sqlIndexKeyMap.get(sql + "_" + parameterIndex);
            if (columninfo == null) {
                if (x1 instanceof String) {
                    map = encData(this.statementInformation, parameterIndex, x1.toString());
                    x = map.get("x");
                    tableAndColumnName = map.get("tableAndColumnName");
                    mathKey = map.get("mathKey");
                } else {
                    x = x1;
                }
            } else if (columninfo.getSecretkey() != null) {
                x = EngineUtil.exeEngine(columninfo, null, Boolean.valueOf(false), x1, Boolean.valueOf(true));
                tableAndColumnName = columninfo.getColumnname();
                mathKey = columninfo.getId();
            } else {
                x = x1;
                tableAndColumnName = columninfo.getColumnname();
                mathKey = columninfo.getId();
            }
            this.sqlBuffer.setValue(-1, parameterIndex, x, x1, targetSqlType, scaleOrLength);
            this.delegate.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
            if (EngineUtil.digestMap.isEmpty())
                return;
            int whereLocation = 100000000;
            digestMap = this.statementInformation.getDigestMap();
            if (!digestMap.isEmpty()) {
                for (String key : digestMap.keySet()) {
                    Integer value = digestMap.get(key);
                    if (value.intValue() < whereLocation)
                        whereLocation = value.intValue();
                }
                if (parameterIndex >= whereLocation)
                    where = true;
            }
            if (!digestMap.isEmpty() && !where && tableAndColumnName != null && digestMap.get(tableAndColumnName) != null) {
                String digestValue = abstractData(mathKey, x.toString());
                this.sqlBuffer.setValue(-1, ((Integer)digestMap.get(tableAndColumnName)).intValue(), digestValue, null);
                this.delegate.setString(((Integer)digestMap.get(tableAndColumnName)).intValue(), digestValue);
            }
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } catch (Exception ex) {
            ex.printStackTrace();
        } finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(14, parameterIndex, x, length, "byte[ascii]");
            this.delegate.setAsciiStream(parameterIndex, x, length);
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(14, parameterIndex, x, length, "byte[]");
            this.delegate.setBinaryStream(parameterIndex, x, length);
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(15, parameterIndex, reader, length, "byte[string]");
            this.delegate.setCharacterStream(parameterIndex, reader, length);
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, reader, e);
        }
    }

    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(14, parameterIndex, x, "byte[ascii]");
            this.delegate.setAsciiStream(parameterIndex, x);
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(14, parameterIndex, x, "byte[]");
            this.delegate.setBinaryStream(parameterIndex, x);
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, x, e);
        }
    }

    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(15, parameterIndex, reader, "byte[string]");
            this.delegate.setCharacterStream(parameterIndex, reader);
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, reader, e);
        }
    }

    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(15, parameterIndex, value, "byte[string]");
            this.delegate.setNCharacterStream(parameterIndex, value);
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, value, e);
        }
    }

    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(15, parameterIndex, reader, "byte[string]");
            this.delegate.setClob(parameterIndex, reader);
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, reader, e);
        }
    }

    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(14, parameterIndex, inputStream, "byte[]");
            this.delegate.setBlob(parameterIndex, inputStream);
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, inputStream, e);
        }
    }

    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        SQLException e = null;
        try {
            this.sqlBuffer.setValue(15, parameterIndex, reader, "byte[string]");
            this.delegate.setNClob(parameterIndex, reader);
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            this.eventListener.onAfterPreparedStatementSet(this.statementInformation, parameterIndex, reader, e);
        }
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.delegate.getParameterMetaData();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.delegate.getMetaData();
    }

    public Map<String, String> encData(PreparedStatementInformation statementInformation, int parameterIndex, String x) throws Exception {
        Map<String, String> encDataMap = new HashMap<String, String>();
        encDataMap.put("x", x);
        if (!GatewayContext.isPluginEnabled())
            return encDataMap;
        String dbType = "";
        String urlDbType = statementInformation.getConnectionInformation().getUrl();
        String driverName = statementInformation.getConnectionInformation().getConnection().getMetaData().getDriverName();
        dbType = ConnectionWrapper.getDbType(driverName, urlDbType, dbType);
        List<Object> insertValueList = new ArrayList();
        try {
            String sqlAll;
            Connection connection = statementInformation.getConnectionInformation().getConnection();
            String urlTemp = connection.getMetaData().getURL();
            String ip = (String)TestJdbcEventListener.getIpAndPort(urlTemp).get("ip");
            String port = (String)TestJdbcEventListener.getIpAndPort(urlTemp).get("port");
            String schema = "";
            String tableName = "";
            if ("oracle".equals(dbType)) {
                schema = connection.getMetaData().getUserName();
            } else if ("postgresql".equals(dbType) || "greenplum".equals(dbType) || "gauss".equals(dbType) || "gaussdb".equalsIgnoreCase(dbType)) {
                String url = connection.getMetaData().getURL();
                if (url.indexOf("searchpath") > 0) {
                    schema = url.substring(url.indexOf("searchpath") + 11);
                } else if (url.indexOf("currentSchema") > 0) {
                    schema = url.substring(url.indexOf("currentSchema") + 14);
                } else if (url.toLowerCase().indexOf("schema=") > 0) {
                    schema = url.substring(url.indexOf("schema=") + 7);
                } else {
                    schema = "public";
                }
            } else if ("sql server".equals(dbType)) {
                String url = connection.getMetaData().getURL();
                if (url.indexOf("applicationName") > 0) {
                    schema = url.substring(url.indexOf("applicationName") + "applicationName".length() + 1);
                    if (schema.indexOf(";") != -1)
                        schema = schema.substring(0, schema.indexOf(";"));
                } else {
                    schema = "dbo";
                }
            } else if ("dm".equals(dbType)) {
                String url = connection.getMetaData().getURL();
                if (url.toLowerCase().contains("schema=")) {
                    schema = url.substring(url.toLowerCase().indexOf("schema=") + 7);
                } else {
                    int from = url.indexOf("://");
                    int end = url.indexOf("?");
                    String address = (end == -1) ? url.substring(from + 3) : url.substring(from + 3, end);
                    int idx = address.lastIndexOf("/");
                    schema = address.substring(idx + 1);
                }
            } else if ("db2".equals(dbType)) {
                Statement stmt = connection.createStatement();
                ResultSet rs = stmt.executeQuery("SELECT CURRENT SCHEMA FROM SYSIBM.SYSDUMMY1");
                if (rs.next()) {
                    schema = rs.getString(1).trim();
                } else {
                    schema = connection.getMetaData().getUserName();
                }
                rs.close();
                stmt.close();
            } else if ("kingbase".equals(dbType)) {
                String url = connection.getMetaData().getURL();
                if (url.indexOf("searchpath") > 0) {
                    schema = url.substring(url.indexOf("searchpath") + 11);
                } else if (url.indexOf("currentSchema") > 0) {
                    schema = url.substring(url.indexOf("currentSchema") + 14);
                } else {
                    schema = "public";
                }
            } else if ("mysql".equals(dbType)) {
                String url = connection.getMetaData().getURL();
                int from = url.indexOf("://");
                int end = url.indexOf("?");
                String address = (end == -1) ? url.substring(from + 3) : url.substring(from + 3, end);
                int idx = address.lastIndexOf("/");
                schema = address.substring(idx + 1);
            } else if ("mariadb".equals(dbType)) {
                String url = connection.getMetaData().getURL();
                int from = url.indexOf("://");
                int end = url.indexOf("?");
                String address = (end == -1) ? url.substring(from + 3) : url.substring(from + 3, end);
                int idx = address.lastIndexOf("/");
                schema = address.substring(idx + 1);
            } else if ("hive".equals(dbType)) {
                String url = connection.getMetaData().getURL();
                int from = url.indexOf("://");
                int end = url.indexOf("?");
                String address = (end == -1) ? url.substring(from + 3) : url.substring(from + 3, end);
                int idx = address.lastIndexOf("/");
                schema = address.substring(idx + 1);
                if (schema.indexOf(";") > 0)
                    schema = schema.substring(0, schema.indexOf(";"));
            } else {
                schema = connection.getCatalog();
            }
            String sql1 = statementInformation.getSql();
            if (sql1.indexOf("-- appUsername=") > 0) {
                sqlAll = sql1.substring(0, sql1.indexOf("-- appUsername=")).trim();
            } else {
                sqlAll = sql1;
            }
            int indexColumnAll = 0;
            int lastIndexColumn = 0;
            String[] split = sqlAll.split(";\r\n");
            for (int i = 0; i < split.length; i++) {
                String sql = split[i];
                SQLType sqlType = SQLParserUtils.getSQLType(sql, DbType.of(dbType));
                int sqlParamNum = (sql.concat("t").split("\\?")).length - 1;
                indexColumnAll += sqlParamNum;
                lastIndexColumn = indexColumnAll - sqlParamNum;
                if (parameterIndex > lastIndexColumn && parameterIndex <= indexColumnAll) {
                    ArrayList<Column> columnList = new ArrayList<Column>();
                    List<Map<String, Object>> whereList = new ArrayList<Map<String, Object>>();
                    List<Map<String, Object>> stringObjectMapList = ConnectionWrapper.sqlParseMap.get(sqlAll);
                    if (stringObjectMapList == null || stringObjectMapList.isEmpty())
                        stringObjectMapList = statementInformation.sqlParse;
                    if (stringObjectMapList == null || stringObjectMapList.isEmpty())
                        stringObjectMapList = getColumns(statementInformation, sql, dbType, schema);
                    Map<String, Object> stringObjectMap = stringObjectMapList.get(0);
                    columnList = (ArrayList<Column>)stringObjectMap.get("columnList");
                    if (columnList == null || columnList.isEmpty())
                        RuleLoadUtil.writeLog("@@");
                                whereList = (List<Map<String, Object>>)stringObjectMap.get("whereList");
                    if (whereList == null || whereList.isEmpty())
                        RuleLoadUtil.writeLog("@@");
                                Object value = null;
                    Boolean encFlag = Boolean.valueOf(false);
                    parameterIndex -= lastIndexColumn;
                    encDataMap = encryption(sql1, insertValueList, sqlType, ip, port, schema, tableName, columnList, value, encFlag, whereList, parameterIndex, x, statementInformation.getReplaceInfo());
                    break;
                }
            }
        } catch (Exception e1) {
            e1.printStackTrace();
            throw e1;
        }
        return encDataMap;
    }

    public String abstractData(String mathKey, String x) throws Exception {
        String hashStr = "";
        try {
            boolean isDigest = EngineUtil.digestMapBak.containsKey(mathKey);
            if (isDigest) {
                Columninfo map = (Columninfo)EngineUtil.digestMapBak.get(mathKey);
                hashStr = SM3Utils.encrypt(x, map.getSecretkey());
            } else {
                hashStr = x;
            }
        } catch (Exception e1) {
            e1.printStackTrace();
            throw e1;
        }
        return hashStr;
    }

    private ArrayList<Column> sortColumns(ArrayList<Column> columnList, Collection<TableStat.Column> insertFields) {
        ArrayList<Column> sortColumnList = new ArrayList<Column>();
        if (insertFields instanceof ArrayList) {
            List<TableStat.Column> insertList = (ArrayList)insertFields;
            for (int i = 0; i < insertList.size(); i++) {
                for (Column column : columnList) {
                    if (column.getColumnName().equalsIgnoreCase(((TableStat.Column)insertList.get(i)).getName())) {
                        sortColumnList.add(column);
                        break;
                    }
                }
            }
            return sortColumnList;
        }
        return columnList;
    }

    private void getUpdateSetFields(PreparedStatementInformation statementInformation, String dbType, String schema, String tableName, ArrayList<Column> updateList) throws SQLException {
        List<Column> columnList = null;
        List<TableStat.Column> columnL = new ArrayList<TableStat.Column>();
        if ("mysql".equals(dbType) || "mariadb".equals(dbType)) {
            columnList = JdbcUtil.getColumnOfMysql(statementInformation.getConnectionInformation().getConnection().createStatement(), schema, tableName);
        } else if ("oracle".equals(dbType)) {
            columnList = JdbcUtil.getColumnOfOracle(statementInformation.getConnectionInformation().getConnection().createStatement(), schema, tableName);
        } else if ("postgresql".equals(dbType) || "greenplum".equals(dbType) || "gauss".equals(dbType)) {
            columnList = JdbcUtil.getColumnOfPostgresql(statementInformation.getConnectionInformation().getConnection().createStatement(), schema, tableName);
        } else if ("hive".equals(dbType)) {
            columnList = JdbcUtil.getColumnOfHive(statementInformation.getConnectionInformation().getConnection().createStatement(), schema, tableName);
        } else if ("dm".equals(dbType)) {
            columnList = JdbcUtil.getColumnOfDm(statementInformation.getConnectionInformation().getConnection().createStatement(), schema, tableName);
        } else if ("db2".equals(dbType)) {
            columnList = JdbcUtil.getColumnOfDb2(statementInformation.getConnectionInformation().getConnection().createStatement(), schema, tableName);
        } else if ("sql server".equals(dbType)) {
            columnList = JdbcUtil.getColumnOfSqlserver(statementInformation.getConnectionInformation().getConnection().createStatement(), schema, tableName);
        } else if ("kingbase".equals(dbType)) {
            columnList = JdbcUtil.getColumnOfKingbase(statementInformation.getConnectionInformation().getConnection().createStatement(), schema, tableName);
        } else if ("gbase".equals(dbType)) {

        }
        ArrayList<Column> finalUpdateList = updateList;
        for (Column col : columnList) {
            Column tm = new Column(col.getColumnName(), col.getSchema(), col.getTable(), col.getDataType());
            finalUpdateList.add(tm);
        }
    }

    private List<Map<String, Object>> getColumns(PreparedStatementInformation statementInformation, String sql, String dbType, String schema) throws SQLException {
        Map<String, String> params = new HashMap<String, String>();
        params.put("sql", sql);
        params.put("dbType", dbType);
        params.put("schema", schema);
        params.put("encryption", "1");
        String url = statementInformation.getConnectionInformation().getConnection().getMetaData().getURL();
        params.put("url", url);
        SqlUtil sqlUtil = new SqlUtil();
        List<Map<String, Object>> maps = sqlUtil.parseSqlStructureEnc(params);
        if (maps != null && !maps.isEmpty()) {
            Map<String, Object> stringObjectMap = maps.get(0);
            if (!stringObjectMap.isEmpty()) {
                String trim = sql.toLowerCase().trim();
                if ((trim.startsWith("insert") || trim.startsWith("update")) && trim.contains("?")) {
                    ConnectionWrapper.sqlParseMap.put(sql, maps);
                } else if (trim.startsWith("select")) {
                    ConnectionWrapper.sqlParseMap.put(sql, maps);
                }
                statementInformation.sqlParse = maps;
            }
        }
        return maps;
    }

    private String getDbType(PreparedStatementInformation statementInformation, String dbType) throws Exception {
        try {
            String hiveurl = statementInformation.getConnectionInformation().getUrl();
            if (hiveurl.toLowerCase().contains("hive"))
                return "hive";
            String driverName = statementInformation.getConnectionInformation().getConnection().getMetaData().getDriverName();
            if (driverName.toLowerCase().contains("mysql")) {
                dbType = "mysql";
            } else if (driverName.toLowerCase().contains("oracle")) {
                dbType = "oracle";
            } else if (driverName.toLowerCase().contains("postgresql")) {
                String url = statementInformation.getConnectionInformation().getConnection().getMetaData().getURL();
                if (url.contains("gauss")) {
                    dbType = "gauss";
                    return dbType;
                }
                if (url.contains("greenplum")) {
                    dbType = "greenplum";
                    return dbType;
                }
                dbType = "postgresql";
            } else if (driverName.toLowerCase().contains("hive")) {
                dbType = "hive";
            } else if (driverName.toLowerCase().contains("dm")) {
                dbType = "dm";
            } else if (driverName.toLowerCase().contains("ibm")) {
                dbType = "db2";
            } else if (driverName.toLowerCase().contains("sql server")) {
                dbType = "sql server";
            } else if (driverName.toLowerCase().contains("kingbase")) {
                dbType = "kingbase";
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return dbType;
    }

    public Boolean find(String empNumber, Collection<TableStat.Column> list) {
        Iterator<TableStat.Column> iterator = list.iterator();
        while (iterator.hasNext()) {
            TableStat.Column column = iterator.next();
            if (column.getName().equalsIgnoreCase(empNumber))
                return Boolean.valueOf(true);
        }
        return Boolean.valueOf(false);
    }

    private List<Object> getInsertSqlValueList(String sql, List<Object> valueList) {
        if (sql.indexOf("-- appUsername=") > 0)
            sql = sql.substring(0, sql.indexOf("-- appUsername=")).trim();
        String lowerSql = sql.toLowerCase();
        String[] split = lowerSql.split(";\r\n");
        for (String s : split) {
            if (s.contains("values")) {
                String tempsql = s.substring(s.indexOf("values") + 6);
                tempsql = tempsql.replaceFirst("\\(", "");
                tempsql = tempsql.replaceFirst("[\\\\)]+$", "");
                if (tempsql.trim().endsWith(";"))
                    tempsql = tempsql.trim().substring(0, tempsql.trim().length() - 1);
                valueList.addAll(InsertSqlVaulesUtil.getTableColumnValueByMatchingSingleQuotes((Object[])tempsql.split(",")));
            } else if (s.contains("value")) {
                String tempsql = s.substring(s.indexOf("value") + 5);
                tempsql = tempsql.replaceFirst("\\(", "");
                tempsql = tempsql.replaceFirst("[\\\\)]+$", "");
                if (tempsql.trim().endsWith(";"))
                    tempsql = tempsql.trim().substring(0, tempsql.trim().length() - 1);
                valueList = InsertSqlVaulesUtil.getTableColumnValueByMatchingSingleQuotes((Object[])tempsql.split(","));
            }
        }
        return valueList;
    }

    private Map<String, String> encryption(String sql, List<Object> insertValueList, SQLType sqlType, String ip, String port, String schema, String tableName, ArrayList<Column> columnList, Object value, Boolean encFlag, List<Map<String, Object>> whereList, int parameterIndex, String x, ReplaceInfo replaceInfo) throws SQLException {
        Map<String, Object> whereMap;
        Map<Object, Object> hashMap = new HashMap<Object, Object>();
        boolean ismaksing = false;
        HashMap<Integer, Integer> ids = new HashMap<Integer, Integer>();
        int m = 1;
        Column column = null;
        if (sqlType == SQLType.INSERT);
        if (sqlType == SQLType.UPDATE)
            for (int k = 0; k < columnList.size(); k++) {
                String v = ((Column)columnList.get(k)).getValue();
                if (v != null)
                    if (String.valueOf(((Column)columnList.get(k)).getValue()).trim().equals("?")) {
                        ids.put(Integer.valueOf(m), Integer.valueOf(k));
                        m++;
                    }
            }
        if (null != ids && ids.containsKey(Integer.valueOf(parameterIndex))) {
            if (sqlType == SQLType.INSERT)
                parameterIndex = (parameterIndex % ids.size() == 0) ? ids.size() : (parameterIndex % ids.size());
            column = columnList.get(((Integer)ids.get(Integer.valueOf(parameterIndex))).intValue() % columnList.size());
        }
        if (null != column) {
            String str1 = column.getColumnName().contains(".") ? column.getColumnName().split("\\.")[1] : column.getColumnName();
            String str2 = (ip + "_" + port + "_" + schema + "_" + tableName + "_" + str1).toLowerCase().replace("`", "").replace("\"", "");
            RuleLoadUtil.writeLog("@@"+ str2);
            if (EngineUtil.encryptionMap.isEmpty())
                EngineUtil.keyCacheFromFile();
            ismaksing = EngineUtil.encryptionMap.containsKey(str2);
            if (ismaksing) {
                Boolean flag = Boolean.valueOf(false);
                try {
                    Columninfo map = (Columninfo)EngineUtil.encryptionMap.get(str2);
                    if (sqlType == SQLType.INSERT) {
                        value = x;
                        RuleLoadUtil.writeLog("@@"+ x);
                                value = EngineUtil.exeEngine(map, null, flag, value, Boolean.valueOf(true));
                        x = (String)value;
                        RuleLoadUtil.writeLog("@@"+ x);
                    } else if (sqlType == SQLType.UPDATE) {
                        value = x;
                        value = EngineUtil.exeEngine(map, null, flag, value, Boolean.valueOf(true));
                        x = (String)value;
                    }
                } catch (Exception e1) {
                    e1.printStackTrace();
                    throw new SQLException(e1);
                } finally {
                    hashMap.put("x", x);
                }
            }
            return (Map)hashMap;
        }
        int computeParameterIndex = parameterIndex - 1;
        if (sqlType == SQLType.UPDATE) {
            for (int i = 0; i < columnList.size(); i++) {
                Column column1 = columnList.get(i);
                if (column1.getValue() != null)
                    if (column1.getValue().equals("?")) {
                        Map<String, Object> map = new HashMap<String, Object>();
                        map.put("column", schema + "." + column1.getColumnName());
                        map.put("columnValue", "?");
                        map.put("type", "Equality");
                        whereList.add(i, map);
                    }
            }
            computeParameterIndex = parameterIndex - 1 - ids.size();
        }
        if (whereList == null || whereList.isEmpty()) {
            hashMap.put("tableAndColumnName", "");
            hashMap.put("x", x);
            hashMap.put("mathKey", "");
            return (Map)hashMap;
        }
        Iterator<Map<String, Object>> iterator = whereList.iterator();
        while (iterator.hasNext()) {
            Map<String, Object> y = iterator.next();
            if ((!(y.get("columnValue") instanceof String) || !y.get("columnValue").equals("?")) && (!(y.get("columnValue") instanceof SQLVariantRefExpr) || !((SQLVariantRefExpr)y.get("columnValue")).getName().equals("?")))
                iterator.remove();
        }
        if (whereList == null || whereList.isEmpty()) {
            hashMap.put("tableAndColumnName", "");
            hashMap.put("x", x);
            hashMap.put("mathKey", "");
            return (Map)hashMap;
        }
        if (computeParameterIndex >= whereList.size()) {
            whereMap = whereList.get(whereList.size() - 1);
        } else {
            whereMap = whereList.get(computeParameterIndex);
        }
        String key = (String)whereMap.get("column");
        String columnName = key.contains(".") ? key.split("\\.")[2].replace("\"", "") : key.replace("\"", "");
        tableName = key.contains(".") ? key.split("\\.")[1] : tableName;
        schema = key.contains(".") ? key.split("\\.")[0] : schema;
        String mathKey = (ip + "_" + port + "_" + schema + "_" + tableName + "_" + columnName).toLowerCase().replace("`", "").replace("\"", "");
        if (EngineUtil.encryptionMap.isEmpty())
            EngineUtil.keyCacheFromFile();
        if ("1".equals(EncryptionGatewayManager.getParameterValue("replaceSql")) &&
                replaceInfo != null) {
            String replaceColumn = ip + "_" + port + "_" + replaceInfo.getPrefix() + "_" + replaceInfo.getColumnName();
            if (mathKey.equals(replaceColumn)) {
                hashMap.put("tableAndColumnName", (tableName + "@@" + columnName).toLowerCase());
                hashMap.put("x", x);
                hashMap.put("mathKey", mathKey);
                return (Map)hashMap;
            }
        }
        RuleLoadUtil.writeLog("@@"+ mathKey);
                ismaksing = EngineUtil.encryptionMap.containsKey(mathKey);
        if (ismaksing) {
            Boolean flag = Boolean.valueOf(false);
            Columninfo map = (Columninfo)EngineUtil.encryptionMap.get(mathKey);
            map.setColumnname((tableName + "@@" + columnName).toLowerCase());
            map.setId(mathKey);
            String type = (String)whereMap.get("type");
            if (!type.toUpperCase().equals("LIKE"))
                sqlIndexKeyMap.put(sql + "_" + parameterIndex, map);
            if (x != null && !"".equals(x))
                try {
                    value = x;
                    if (type.toUpperCase().equals("LIKE")) {
                        String likeValue = ((String)value).trim();
                        boolean beforeLike = false;
                        boolean afterLike = false;
                        if (!likeValue.equals("%%")) {
                            if (likeValue.startsWith("%")) {
                                likeValue = likeValue.substring(1);
                                beforeLike = true;
                            }
                            if (likeValue.endsWith("%")) {
                                likeValue = likeValue.substring(0, likeValue.length() - 1);
                                afterLike = true;
                            }
                            value = likeValue;
                            value = EngineUtil.exeEngine(map, null, flag, value, Boolean.valueOf(true));
                            if (afterLike)
                                value = value.toString().replace(ENCRYPT_SEPARATOR, "");
                            if (ENCRYPT_LIKE_OPEN.equals(map.getIsLike())) {
                                if (beforeLike)
                                    value = "%" + value;
                                if (afterLike)
                                    value = value + "%";
                            }
                        }
                    } else {
                        RuleLoadUtil.writeLog("@@"+ value);
                                value = EngineUtil.exeEngine(map, null, flag, value, Boolean.valueOf(true));
                        RuleLoadUtil.writeLog("@@"+ value);
                    }
                    x = (String)value;
                    return (Map)hashMap;
                } catch (Exception e1) {
                    e1.printStackTrace();
                    throw new SQLException(e1);
                } finally {
                    Exception exception = null;
                    hashMap.put("tableAndColumnName", (tableName + "@@" + columnName).toLowerCase());
                    hashMap.put("x", x);
                    hashMap.put("mathKey", mathKey);
                }
        } else {
            Columninfo columninfo = new Columninfo();
            columninfo.setColumnname((tableName + "@@" + columnName).toLowerCase());
            columninfo.setId(mathKey);
            sqlIndexKeyMap.put(sql + "_" + parameterIndex, columninfo);
        }
        hashMap.put("tableAndColumnName", (tableName + "@@" + columnName).toLowerCase());
        hashMap.put("x", x);
        hashMap.put("mathKey", mathKey);
        return (Map)hashMap;
    }

    public static void main(String[] args) {
        String key = "\t{\n\t\t\"datasystemid\": \"ff808081920fb5af0192101fe06c0005\",\n\t\t\"dbip\": \"10.130.136.63\",\n\t\t\"dbport\": \"1521\",\n\t\t\"dbservername\": \"orcl\",\n\t\t\"schema\": \"VENUS\",\n\t\t\"tableInfo\": [\n\t\t\t{\n\t\t\t\t\"columninfo\": [\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"DESCRIPTION\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af019210feca3a0030\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"EMAIL\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af019210feca7c0031\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"IMGPATH\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af019210fecb090033\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"IP\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af019210fecb560034\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"IS5G\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af019210fecba10035\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"ISSHARE\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af019210fecbe80036\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"LOGIN_AUTH_MODE\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af019210fecc2e0037\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"MASTERID\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af019210fecc7b0038\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"MASTERNAME\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af019210feccbb0039\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"MASTERREALNAME\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af019210feccfa003a\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"NAME\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af019210fecd33003b\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"NFV_TYPE\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af019210fecd76003c\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"OPERSTEL\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af019210fecdc5003d\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"PARAMETER\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af019210fece02003e\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"PHYLOCA\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af019210fece47003f\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"PORT\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af019210fece840040\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"PROTOCOL\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af019210fecec20041\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"RESMODE\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af019210fecefc0042\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"SUPPORTTYPE\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af019210fecf410043\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"SYNSTATUS\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af019210fecf870044\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"TYPE\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af019210fecfc20045\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"URL\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af019210fed0000046\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"URL_IPV6\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af019210fed0440047\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"VERSION\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af019210fed07e0048\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t}\n\t\t\t\t],\n\t\t\t\t\"tablename\": \"VENUS_AUTH_APP_RES\"\n\t\t\t},\n\t\t\t{\n\t\t\t\t\"columninfo\": [\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"USERNAME\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081922429a90192295877a2003e\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"USERREALNAME\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081922429a9019229590dd60040\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"ORGPATH\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081922429a9019229596a630043\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"LOGINIP\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081922429a901922959be370045\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"MAC\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081922429a90192295a23450047\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"OPERATIONOBJ\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081922429a90192295a9ce8004a\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"RESOURCENAME\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081922429a90192295b05f2004c\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"SERVERIP\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081922429a90192295b8ff1004f\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t}\n\t\t\t\t],\n\t\t\t\t\"tablename\": \"VENUS_LOG_RESOURCE_LOGIN\"\n\t\t\t},\n\t\t\t{\n\t\t\t\t\"columninfo\": [\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"DB_ROLE\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081922429a901922432be97000b\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"DEPARTMENT\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081922429a901922432bede000c\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"DESCRIBE\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081922429a901922432bf22000d\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"EXPIRYTIME\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081922429a901922432bf6e000e\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"MODIFYBY\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081922429a901922432bfae000f\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"NAME\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081922429a901922432bfea0010\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"NFVROLEID\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081922429a901922432c0380011\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"NFVSYNSTATUS\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081922429a901922432c07e0012\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"PWD\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081922429a901922432c0ba0013\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"RESERVE1\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081922429a901922432c0f70014\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"RESERVE2\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081922429a901922432c1360015\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"RESERVE3\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081922429a901922432c1770016\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"RESERVE4\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081922429a901922432c1bc0017\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"WORKNUMBER\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081922429a901922432c2150018\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t}\n\t\t\t\t],\n\t\t\t\t\"tablename\": \"VENUS_ACC_SLAVE\"\n\t\t\t},\n\t\t\t{\n\t\t\t\t\"columninfo\": [\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"CHECKRESULT\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d0b4e00ba\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"CLASSIFICATIONRES\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d0b9d00bb\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"DB_CONAS\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d0be100bc\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"DB_LOCALSID\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d0c2400bd\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"DB_PASSWORD\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d0c6b00be\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"DB_PORT\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d0caf00bf\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"DB_PROFILE\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d0cf000c0\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"DB_SERVERNAME\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d0d3f00c1\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"DB_SID\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d0d7e00c2\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"DB_TYPE\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d0dbd00c3\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"DB_USER\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d0dfe00c4\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"DB_VERSION\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d0e3d00c5\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"DESCRIPTION\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d0e7b00c6\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"FORTIP\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d0f0000c8\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"HOSTPASSWORD\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d0f4500c9\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"HOSTNAME\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d0f8d00ca\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"HOSTSHORTNAME\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d0fd900cb\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"HOSTUSER\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d101a00cc\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"IMGPATH\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d105a00cd\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"IP\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d109500ce\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"IPV6\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d10e300cf\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"IS5G\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d113100d0\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"ISSHARE\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d117f00d1\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"MASTERID\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d11bf00d2\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"MASTERREALNAME\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d123900d4\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"MIDDLESERVICEIP\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d128500d5\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"MODEL\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d12d200d6\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"NAME\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d130d00d7\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"NOTSUPSYSLOGDESC\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d135800d8\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"PATH\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d13aa00d9\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"PHYLOCA\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d13e700da\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"PORT\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d142500db\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"PRIPWDESCROW\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d147300dc\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"RANDOM\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d14f600de\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"RANGEIP\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d152f00df\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"RESMODE\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d156a00e0\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"TYPE\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d15a600e1\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"UNIX_ANAME\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d15ea00e2\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"UNIX_APASSWORD\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d162d00e3\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"UNIX_BNAME\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d167200e4\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"UNIX_BPASSWORD\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d16b800e5\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"UNIX_GROUP\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d16fd00e6\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"UNIX_SYSTYPE\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d174200e7\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"UNIX_SYSVERSION\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d178400e8\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"UNIX_UID\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d17cd00e9\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"VERSION\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081920fb5af0192113d184b00eb\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t}\n\t\t\t\t],\n\t\t\t\t\"tablename\": \"VENUS_AUTH_SYS_RES\"\n\t\t\t},\n\t\t\t{\n\t\t\t\t\"columninfo\": [\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"STATE\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081922429a90192242ea7130003\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"columnType\": \"VARCHAR2\",\n\t\t\t\t\t\t\"columnname\": \"WORKNUMBER\",\n\t\t\t\t\t\t\"encdigit\": \"0\",\n\t\t\t\t\t\t\"encryptiontype\": \"SM4_ECB\",\n\t\t\t\t\t\t\"id\": \"ff808081922429a90192242ea7830004\",\n\t\t\t\t\t\t\"isLike\": \"0\",\n\t\t\t\t\t\t\"keepfirst\": \"0\",\n\t\t\t\t\t\t\"secretkey\": \"B892513BA980BDC35C5DCE5F60B278D6\",\n\t\t\t\t\t\t\"twoindex\": \"0\"\n\t\t\t\t\t}\n\t\t\t\t],\n\t\t\t\t\"tablename\": \"VENUS_AUTH_MASTERAUTH\"\n\t\t\t}\n\t\t]\n\t}\n";
        JsonRootBean jsonRootBean = (JsonRootBean)JSON.parseObject(key.toString(), JsonRootBean.class);
        System.out.println(jsonRootBean.toString());
    }
}
