package test;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLStatement;

public class GPTest {
   public static void main(String[] args) {
      parseTestLty();
   }

   static void parseGrant() {
      testGram("GRANT INSERT(c1,c2) ON mytable TO PUBLIC;");
      testGram("GRANT ALL PRIVILEGES(c1,c2) ON topten TO sally;");
      testGram("GRANT SELECT(c1,c2),insert(c1,c2)  on  mytable1 TO sally  with grant option;");
      testGram("GRANT SELECT(c1,c2),insert(c1,c2)  on  mytable1 TO sally;");
      testGram("GRANT SELECT(c1,c2),insert(c1,c2)  on  TB1,tb2 TO sally;");
      testGram("GRANT SELECT(c1,c2),insert(c1,c2)  on  ALL TABLES IN SCHEMA myschema TO sally;");
   }

   static void parseDdl() {
      testGram("alter schema myschema rename to myschema1");
      testGram("alter schema myschema owner to myuser");
   }

   static void parseAlterTable() {
      testGram("alter table if exists only mytable OWNER to root ");
      testGram("alter table if exists only mytable set tablespace my_new_tablespace ");
      testGram("alter table if exists only mytable OWNER to root ,set tablespace my_new_tablespace ");
   }

   static void parseCreateDatabase() {
      testGram("create database mydb with owner=root template mytemp encoding=utf8 CONNECTION LIMIT =1");
   }

   static void parseCreateSchema() {
      testGram("create schema IF NOT EXISTS my_schema_name");
      testGram("create schema IF NOT EXISTS my_schema_name AUTHORIZATION  root");
      testGram("CREATE SCHEMA IF NOT EXISTS AUTHORIZATION root");
   }

   static void parseSelect() {
      testGram("SELECT varchar 'Hello World', '1' AS hello;");
      testGram("SELECT CHARACTER 'Hello World', '1' AS hello;");
      testGram("SELECT CHAR 'Hello World', '1' AS hello;");
      testGram("SELECT text 'Hello World' hello;");
      testGram("select integer '1' as hello;");
      testGram("select SMALLINT '1' as hello;");
      testGram("select BIGINT '1' as hello;");
      testGram("select float '1' as hello;");
      testGram("select DECIMAL '1' as hello;");
      testGram("select NUMERIC '1' as hello;");
      testGram("select NUMERIC(38,0) '1' as hello;");
      testGram("select DOUBLE PRECISION '1' as hello;");
      testGram("select int '1' as hello;");
      testGram("select json '1' as hello;");
      testGram("select  DATE '2023/4/26' as hello;");
      testGram("select  TIME '14:05' as hello;");
      testGram("select  TIMESTAMP '2023.4.26 14:05' as hello;");
      testGram("select  INTERVAL '1 year' as hello;");
      testGram("select  BOOLEAN 'true' as hello;");
      testGram("select  POINT '(1,5)' as hello;");
      testGram("select * into temporary person_temp  from public.person ");
      testGram("select * into xxx from t1 as t(xx,n1,n2,n3)");
      testGram("select * into temporary person_temp1  from public.person ;");
      testGram("select * into temp person_temp2  from public.person ;");
      testGram("select * into UNLOGGED person_temp3  from public.person ;");
      testGram("select * into temporary table person_temp1  from public.person ;");
      testGram("select * into temp table person_temp2  from public.person ;");
      testGram("select * into UNLOGGED table person_temp3  from public.person ;");
      testGram("select * into UNLOGGED table person_temp3  from public.person for update;");
   }

   static void parseCreateTable() {
      testGram("CREATE TABLE baby.rank (id int, rank int, year smallint, \ngender char(1), count int ) DISTRIBUTED BY (rank, gender, \nyear);");
      testGram("CREATE TABLE films (\ncode        char(5) CONSTRAINT firstkey PRIMARY KEY,\ntitle       varchar(40) NOT NULL,\ndid         integer NOT NULL,\ndate_prod   date,\nkind        varchar(10)\n);");
      testGram("CREATE TABLE distributors (\ndid    integer PRIMARY KEY DEFAULT nextval('serial'),\nname   varchar(40) NOT NULL CHECK (name <> '')\n);");
      testGram("CREATE TABLE sales (txn_id int, qty int, date date) \nWITH (appendoptimized=true, compresslevel=5) \nDISTRIBUTED BY (txn_id);");
      testGram("");
      testGram("");
      testGram("");
      testGram("");
      testGram("");
      testGram("");
      testGram("");
      testGram("");
      testGram("");
   }

   static void testGram(String sql) {
      if (sql != null && sql.length() != 0) {
         for(SQLStatement statement : SQLUtils.parseStatements(sql, DbType.greenplum)) {
            System.out.println("-----------------------------------");
            String s = statement.toString();
            System.out.println(s);
         }

      }
   }

   static void parseTest() {
      testGram("SELECT f.title, f.did, d.name, f.date_prod, f.kind FROM distributors d, films f WHERE f.did = d.did");
   }

   static void parseTestLty() {
      testGram("ALTER INDEX distributors RENAME TO suppliers;");
      testGram("ALTER INDEX distributors SET TABLESPACE fasttablespace;");
      testGram("ALTER INDEX IF EXISTS distributors SET TABLESPACE fasttablespace;");
      testGram("ALTER INDEX distributors SET (fillfactor = 75);");
      testGram("ALTER INDEX distributors SET (fillfactor = 75, param1 =1, param2 =2);");
      testGram("ALTER INDEX distributors RESET (fillfactor, param1, param2);");
      testGram("ALTER INDEX ALL IN TABLESPACE distributors  OWNED BY own1,own2,own3 SET TABLESPACE space1 NOWAIT;");
      testGram("ALTER INDEX ALL IN TABLESPACE distributors  SET TABLESPACE space1;");
      testGram("ALTER SEQUENCE serial RESTART WITH 105 ;");
      testGram("ALTER SEQUENCE serial RESTART WITH 105 OWNED BY NONE;");
      testGram("ALTER SEQUENCE IF EXISTS serial INCREMENT BY 1 MINVALUE 1 MAXVALUE 10000 START WITH 1 RESTART WITH 105 CACHE 20 NO CYCLE OWNED BY table.column ;");
      testGram("ALTER SEQUENCE IF EXISTS serial START WITH 1 RESTART WITH 105 CACHE 10 NO CYCLE OWNED BY table.column ;");
      testGram("ALTER SEQUENCE IF EXISTS serial NO MINVALUE NO MAXVALUE START WITH 1 RESTART WITH 105 CACHE  20 CYCLE NONE;");
      testGram("ALTER SEQUENCE serial OWNER TO new_owner;");
      testGram("ALTER SEQUENCE IF EXISTS serial RENAME TO new_name;");
      testGram("ALTER SEQUENCE IF EXISTS serial SET SCHEMA new_SCHEMA;");
      testGram("ALTER SEQUENCE  serial INCREMENT BY 1  MAXVALUE 10000 START WITH 1 RESTART WITH 105 CACHE 20 NO CYCLE;");
      testGram("ALTER SEQUENCE IF EXISTS serial INCREMENT BY 1  NO MINVALUE START WITH 1 RESTART WITH 105 CACHE 20 NO CYCLE;");
      testGram("ALTER SEQUENCE IF EXISTS serial INCREMENT BY 1  NO MAXVALUE START WITH 1 RESTART WITH 105 CACHE 20 NO CYCLE;");
      testGram("ALTER SEQUENCE IF EXISTS serial INCREMENT BY 1  NO MAXVALUE START WITH 1 RESTART  105 CACHE 20 NO CYCLE;");
      testGram("ALTER VIEW myview RENAME TO newview;");
      testGram("ALTER VIEW foo RENAME TO bar;");
      testGram("ALTER VIEW IF EXISTS a_view ALTER COLUMN ts SET DEFAULT now(); ");
      testGram("ALTER VIEW a_view ALTER COLUMN ts SET DEFAULT 1; ");
      testGram("ALTER VIEW a_view ALTER COLUMN ts DROP DEFAULT; ");
      testGram("ALTER VIEW a_view OWNER TO new_owner; ");
      testGram("ALTER VIEW a_view SET SCHEMA  new_schema; ");
      testGram("ALTER VIEW a_view SET(fillfactor = 75, param1 =1, param2 =2);");
      testGram("ALTER VIEW a_view SET(fillfactor , param1 , param2);");
      testGram("ALTER VIEW a_view RESET(fillfactor , param1 , param2);");
      testGram("CREATE UNIQUE INDEX title_idx ON films (title int4_ops asc);");
      testGram("CREATE INDEX gender_bmp_idx ON employee USING bitmap (gender);");
      testGram("CREATE INDEX ON films ((lower(title)));");
      testGram("CREATE INDEX title_idx_german ON films (title COLLATE \"de_DE\" int4_ops,kind asc);");
      testGram("CREATE UNIQUE INDEX title_idx ON films (title) WITH (fillfactor = 70);");
      testGram("CREATE INDEX gin_idx ON documents_table USING gin (locations) WITH (fastupdate = off);");
      testGram("CREATE INDEX code_idx ON films(code) TABLESPACE indexspace;");
      testGram("CREATE INDEX pointloc ON points USING gist (box(location,location)); ");
      testGram("CREATE UNIQUE INDEX title_idx ON films (title COLLATE \"de_DE\" asc NULLS FIRST) WITH (fillfactor = 70,param2=80) where comune1=1;");
      testGram("CREATE UNIQUE INDEX title_idx ON films (title int4_ops asc,kind desc nulls last);");
      testGram("CREATE SEQUENCE myseq INCREMENT 1;");
      testGram("CREATE SEQUENCE myseq START 101;");
      testGram("CREATE TEMPORARY SEQUENCE myseq INCREMENT BY 1 ;");
      testGram("CREATE TEMP SEQUENCE myseq MINVALUE 1 NO MAXVALUE START WITH 1;");
      testGram("CREATE TEMP SEQUENCE myseq  NO MAXVALUE START WITH 1;");
      testGram("CREATE TEMP SEQUENCE myseq  NO MINVALUE START WITH 1;");
      testGram("CREATE TEMP SEQUENCE myseq  MINVALUE 1 NO MAXVALUE START WITH 1;");
      testGram("CREATE TEMP SEQUENCE myseq  MINVALUE 1  MAXVALUE 10000 START WITH 1;");
      testGram("CREATE TEMP SEQUENCE myseq  MINVALUE 1  START WITH 1;");
      testGram("CREATE TEMP SEQUENCE myseq START 1 CACHE 5 NO CYCLE;");
      testGram("CREATE TEMP SEQUENCE myseq START 1 CACHE 5 CYCLE;");
      testGram("CREATE SEQUENCE myseq START WITH 1 OWNED BY userinfo.id;");
      testGram("CREATE SEQUENCE myseq START 1 OWNED BY NONE;");
      testGram("CREATE TABLESPACE mytblspace LOCATION '/gpdbtspc/mytestspace';");
      testGram("CREATE TABLESPACE mytblspace LOCATION '/gpdbtspc/mytestspace' WITH (content0='/temp/mytest',seq_page_cost=2,random_page_cost=200);");
      testGram("CREATE TABLESPACE mytblspace OWNER OWNER1 LOCATION '/gpdbtspc/mytestspace' WITH (content0='/temp/mytest', content1='/temp/mytest')");
      testGram("CREATE VIEW vista AS SELECT 'Hello World';");
      testGram("CREATE OR REPLACE VIEW vista AS SELECT 'Hello World';");
      testGram("CREATE OR REPLACE TEMP VIEW vista with (check_option=CASCADED) AS SELECT 'Hello World';");
      testGram("CREATE TEMP VIEW vista AS SELECT 'Hello World';");
      testGram("CREATE TEMPORARY VIEW vista with (security_barrier=true) AS SELECT 'Hello World';");
      testGram("CREATE TEMP VIEW vista AS SELECT 'Hello World' WITH CASCADED CHECK OPTION;");
      testGram("CREATE VIEW vista AS SELECT text 'Hello World' AS hello;");
      testGram("CREATE VIEW comedies AS SELECT * FROM films WHERE kind = 'comedy';");
      testGram("CREATE VIEW comedies AS SELECT * FROM films WHERE kind = 'comedy' WITH LOCAL CHECK OPTION;");
      testGram("CREATE VIEW topten AS SELECT name, rank, gender, year FROM names, rank WHERE rank < '11' AND names.id=rank.id;");
      testGram("CREATE RECURSIVE VIEW public.nums_1_100 (n) AS VALUES (1) UNION ALL SELECT n+1 FROM nums_1_100 WHERE n < 100;");
      testGram("CREATE VIEW public.foo AS WITH RECURSIVE foo(i) AS (SELECT 1 UNION ALL SELECT i+1 from (SELECT * FROM foo UNION SELECT 0) bar ) SELECT * FROM foo LIMIT 5;");
      testGram("WITH RECURSIVE foo(i) AS (SELECT 1 UNION ALL SELECT i+1 from (SELECT * FROM foo UNION SELECT 0) bar ) SELECT * FROM foo LIMIT 5;");
      testGram("CREATE OR REPLACE RECURSIVE VIEW public.nums_1_100 (n) AS VALUES (1) UNION ALL SELECT n+1 FROM nums_1_100 WHERE n < 100;");
      testGram("CREATE OR REPLACE TEMP RECURSIVE VIEW public.nums_1_100 (n) AS VALUES (1) UNION ALL SELECT n+1 FROM nums_1_100 WHERE n < 100;");
      testGram("CREATE TEMP RECURSIVE VIEW public.nums_1_100 (n) AS VALUES (1) UNION ALL SELECT n+1 FROM nums_1_100 WHERE n < 100;");
      testGram("CREATE TEMPORARY RECURSIVE VIEW public.nums_1_100 (n) AS VALUES (1) UNION ALL SELECT n+1 FROM nums_1_100 WHERE n < 100;");
      testGram("DROP DATABASE testdb;");
      testGram("DROP DATABASE IF EXISTS testdb;");
      testGram("DROP SCHEMA IF EXISTS mystuff CASCADE;");
      testGram("DROP SCHEMA mystuff,public RESTRICT;");
      testGram("DROP SEQUENCE IF EXISTS myserial RESTRICT;");
      testGram("DROP SEQUENCE myserial,public CASCADE;");
      testGram("DROP TABLE IF EXISTS mytable RESTRICT;");
      testGram("DROP TABLE mytable,mystuff CASCADE;");
      testGram("DROP TABLESPACE mystuff;");
      testGram("DROP TABLESPACE IF EXISTS mystuff;");
      testGram("DROP VIEW topten;");
      testGram("DROP VIEW IF EXISTS topten RESTRICT;");
      testGram("DROP VIEW topten,myview CASCADE;");
      testGram("COMMIT; ");
      testGram("COMMIT WORK;");
      testGram("COMMIT TRANSACTION;");
      testGram("ROLLBACK;");
      testGram("ROLLBACK TO my_savepoint;");
      testGram("ROLLBACK  WORK  TO SAVEPOINT my_savepoint;");
      testGram("ROLLBACK  TRANSACTION  TO SAVEPOINT my_savepoint;");
      testGram("CREATE TABLE sales (id int, year int, qtr int, c_rank int, code char(1), region text) DISTRIBUTED BY (id) PARTITION BY RANGE (id) ( PARTITION p1  start (int '60') inclusive end (80) inclusive, PARTITION p2  start (80) inclusive end (90) exclusive );");
      testGram("CREATE TABLE sales (id int, year int, qtr int, c_rank int, code char(1), region text) DISTRIBUTED BY (id) PARTITION BY RANGE (id) ( PARTITION p1  start ( '60') inclusive end (80) , PARTITION p2  start ( '60') inclusive end (80) every(1));");
      testGram("CREATE TABLE sales (id int, year int, qtr int, c_rank int, code char(1), region text) DISTRIBUTED BY (id) PARTITION BY RANGE (id) ( PARTITION p1  start ( '60') inclusive end (80) , PARTITION p2  start ( '60') inclusive end (80) every(int 1));");
      testGram("CREATE TABLE sales (id int, year int, qtr int, c_rank int, code char(1), region text) DISTRIBUTED BY (id) PARTITION BY RANGE (id) ( PARTITION p1  start ( '60') inclusive end (80) , PARTITION p2  start ( '60') inclusive end (80) every(interval '1 day'));");
      testGram("CREATE TABLE sales (id int, year int, qtr int, c_rank int, code char(1), region text) DISTRIBUTED BY (id) PARTITION BY LIST (code) ( PARTITION sales VALUES ('S'), PARTITION returns VALUES ('R')  WITH (checksum =true)  TABLESPACE my_space;");
      testGram("CREATE TABLE sales1 (id int, year int, qtr int, c_rank int, code char(1), region text) DISTRIBUTED BY (id) PARTITION BY LIST (code) SUBPARTITION BY RANGE (c_rank) SUBPARTITION TEMPLATE ( SUBPARTITION cr1 START (1) END (2), SUBPARTITION cr2 START (3) END (4) ) SUBPARTITION BY LIST (region) SUBPARTITION TEMPLATE ( SUBPARTITION ca VALUES ('CA') ) ( PARTITION sales VALUES ('S'), PARTITION returns VALUES ('R') );");
      testGram("CREATE TABLE sales (id int, year int, qtr int, c_rank int, code char(1), region text) DISTRIBUTED BY (id) PARTITION BY LIST (code) SUBPARTITION BY RANGE (c_rank) SUBPARTITION by LIST (region) ( PARTITION sales VALUES ('S') ( SUBPARTITION cr1 START (1) END (2) ( SUBPARTITION ca VALUES ('CA') ), SUBPARTITION cr2 START (3) END (4) ( SUBPARTITION ca VALUES ('CA') ) ), PARTITION returns VALUES ('R') ( SUBPARTITION cr1 START (1) END (2) ( SUBPARTITION ca VALUES ('CA') ), SUBPARTITION cr2 START (3) END (4) ( SUBPARTITION ca VALUES ('CA') ) ) );");
      testGram("CREATE TABLE sales (id int, year int, qtr int, c_rank int, code char(1), region text) DISTRIBUTED BY (id) PARTITION BY RANGE (year) SUBPARTITION BY RANGE (qtr) SUBPARTITION TEMPLATE ( START (1) END (5) EVERY (1), DEFAULT SUBPARTITION bad_qtr ) SUBPARTITION BY LIST (region) SUBPARTITION TEMPLATE ( SUBPARTITION usa VALUES ('usa'), SUBPARTITION europe VALUES ('europe'), SUBPARTITION asia VALUES ('asia'), DEFAULT SUBPARTITION other_regions) ( START (2009) END (2011) EVERY (1), DEFAULT PARTITION outlying_years);");
   }
}
