package util.sqlparse.visitor.common.memo;

import com.alibaba.druid.sql.ast.SQLObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import util.StringJoin;
import util.sqlparse.visitor.common.ID;
import util.sqlparse.visitor.common.scope.Scope;

public class FieldMemo extends ID {
   public String name;
   public String alias;
   private String qualifiedName;
   public List<FieldMemo> children = new ArrayList();
   public boolean isSelectItem;
   public TableMemo table;
   public List<TableMemo> tables = new ArrayList();
   public SQLObject ref;
   public List<SQLObject> exprs = new ArrayList();
   public List<AliasField> aliasFields = new ArrayList();
   public FieldMemo typeField;
   public Scope scope;
   public boolean complex;
   public boolean atom;
   public boolean isConstant;
   public FieldMemo refField;
   public boolean outside;
   private Set<Integer> fieldIds = new HashSet();

   public String getQualifiedName() {
      Iterator<TableMemo> iterator = this.tables.iterator();

      while(iterator.hasNext()) {
         TableMemo next = (TableMemo)iterator.next();
         if (next == null) {
            iterator.remove();
         }
      }

      if (this.qualifiedName == null) {
         if (this.table != null) {
            this.qualifiedName = this.table.getQualifiedName() + "." + this.alias;
         } else {
            if (this.tables.size() <= 0) {
               return this.alias;
            }

            ArrayList<String> nameList = new ArrayList();

            for(TableMemo tableMemo : this.tables) {
               nameList.add(tableMemo.getQualifiedName());
            }

            this.qualifiedName = "[" + StringJoin.join(nameList, ",") + "]." + this.alias;
         }
      }

      return this.qualifiedName;
   }

   public void setQualifiedName(String qualifiedName) {
      this.qualifiedName = qualifiedName;
   }

   public String getFullName() {
      return this.ref.toString();
   }

   public String getAtomName() {
      return this.table == null ? this.name : this.table.getAtomName() + "." + this.name;
   }

   public List<FieldMemo> getChildren() {
      return this.children;
   }

   public String getUniqueName() {
      return this.scope.id + ":" + this.getQualifiedName();
   }

   public Set<String> tableNames() {
      Set<String> atomNameSet = new HashSet();

      for(TableMemo x : this.tables) {
         if (!x.isSub && x.refTable == null) {
            atomNameSet.add(x.getAtomName());
         }
      }

      return atomNameSet;
   }

   public Set<String> childNames() {
      Set<String> atomNameSet = new HashSet();

      for(FieldMemo child : this.children) {
         atomNameSet.add(child.getAtomName());
      }

      return atomNameSet;
   }

   public FieldMemo copy() {
      FieldMemo field = new FieldMemo();
      field.name = this.name;
      field.alias = this.name;
      field.isSelectItem = this.isSelectItem;
      field.qualifiedName = null;
      field.ref = null;
      field.scope = null;
      if (this.attributes != null) {
         field.attributes = new HashMap(this.attributes);
      }

      return field;
   }

   public Set<Integer> getFieldIds() {
      return this.fieldIds;
   }

   public void setFieldIds(Set<Integer> fieldIds) {
      this.fieldIds = fieldIds;
   }
}
