package util.sqlparse.visitor.hive.visitor;

import bean.Column;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLPartition;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumericLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLValuableExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddColumn;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddIndex;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLCheck;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCreateIndexStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLLateralViewTableSource;
import com.alibaba.druid.sql.ast.statement.SQLPrivilegeItem;
import com.alibaba.druid.sql.ast.statement.SQLReplaceStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.ast.statement.SQLUnionQueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.ast.statement.SQLValuesTableSource;
import com.alibaba.druid.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.druid.sql.dialect.hive.ast.expr.HiveCharExpr;
import com.alibaba.druid.sql.dialect.hive.ast.stmt.HiveCreateTableStatement;
import com.alibaba.druid.sql.dialect.hive.ast.stmt.HiveGrantStatement;
import com.alibaba.druid.sql.dialect.hive.ast.stmt.HiveInsertStatement;
import com.alibaba.druid.sql.dialect.hive.ast.stmt.HiveSelectQueryBlock;
import com.alibaba.druid.sql.dialect.hive.ast.stmt.HiveUpdateStatement;
import com.alibaba.druid.stat.TableStat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import util.sqlparse.visitor.common.Owner;
import util.sqlparse.visitor.common.memo.AliasField;
import util.sqlparse.visitor.common.memo.FieldMemo;
import util.sqlparse.visitor.common.memo.TableMemo;
import util.sqlparse.visitor.common.scope.ClauseScope;
import util.sqlparse.visitor.common.scope.Scope;
import util.sqlparse.visitor.common.scope.TableScope;
import util.sqlparse.visitor.common.utils.Alias;

public class ScopeVisitor extends ParseVisitor {
   private final Alias alias = new Alias();
   private boolean debug = false;

   public ScopeVisitor(Scope scope) {
      super(scope);
   }

   public boolean visit(SQLSelectStatement x) {
      if (this.scope.context.sqlType == null) {
         this.scope.context.sqlType = TableStat.Mode.Select;
      }

      if (this.debug) {
         System.out.println("enter SQLSelectStatement " + x.toString());
      }

      this.enterClauseScope(x);
      return true;
   }

   public boolean visit(HiveInsertStatement x) {
      if (this.scope.context.sqlType == null) {
         this.scope.context.sqlType = TableStat.Mode.Insert;
      }

      this.enterClauseScope(x);
      this.visitChild(x.getWith());
      this.visitChild(x.getTableSource());
      if (x.getColumns().size() == 0) {
         String schema = null;
         String table = null;
         SQLName tableName = x.getTableName();
         if (tableName instanceof SQLIdentifierExpr) {
            SQLIdentifierExpr expr = (SQLIdentifierExpr)tableName;
            table = expr.getName();
            schema = this.scope.context.getSchema();
         } else if (tableName instanceof SQLPropertyExpr) {
            SQLPropertyExpr expr = (SQLPropertyExpr)tableName;
            table = expr.getName();
            schema = expr.getOwnerName();
         }

         if (table != null && schema != null) {
            List<Column> columns = this.scope.context.getColumns(schema, table);
            if (columns != null && columns.size() > 0) {
               for(Column column : columns) {
                  SQLExpr expr = new SQLIdentifierExpr(column.getRawName());
                  x.getColumns().add(expr);
                  expr.setParent(x);
               }
            }
         }
      }

      for(SQLExpr column : x.getColumns()) {
         this.visitChild(column);
         FieldMemo field = (FieldMemo)column.getAttribute("field");
         if (field != null) {
            field.isSelectItem = true;
         }
      }

      this.visitChild(x.getValuesList());
      this.visitChild(x.getQuery());
      return false;
   }

   public boolean visit(SQLCreateViewStatement x) {
      if (this.scope.context.sqlType == null) {
         this.scope.context.sqlType = TableStat.Mode.CreateView;
      }

      this.visitChild(x.getSubQuery());
      return false;
   }

   public boolean visit(SQLColumnDefinition x) {
      this.visitChild(x.getName());
      this.visitChild(x.getDataType());
      this.visitChild(x.getDefaultExpr());
      this.visitChild(x.getConstraints());
      this.visitChild(x.getGeneratedAlawsAs());
      return false;
   }

   public boolean visit(SQLAlterViewStatement x) {
      if (this.scope.context.sqlType == null) {
         this.scope.context.sqlType = TableStat.Mode.AlterView;
      }

      this.visitChild(x.getSubQuery());
      return false;
   }

   public boolean visit(SQLDropViewStatement x) {
      if (this.scope.context.sqlType == null) {
         this.scope.context.sqlType = TableStat.Mode.DropView;
      }

      return false;
   }

   public void endVisit(HiveCreateTableStatement x) {
      this.scope.exitScope();
   }

   public boolean visit(SQLCreateIndexStatement x) {
      if (this.scope.context.sqlType == null) {
         this.scope.context.sqlType = TableStat.Mode.CreateIndex;
      }

      this.enterClauseScope(x);
      this.visitChild(x.getIndexDefinition().getTable());
      List<SQLSelectOrderByItem> columns = x.getIndexDefinition().getColumns();
      if (columns != null && columns.size() > 0) {
         for(SQLSelectOrderByItem item : columns) {
            boolean isNotEmpty = ((SQLMethodInvokeExpr)item.getExpr()).getArguments() != null && ((SQLMethodInvokeExpr)item.getExpr()).getArguments().size() > 0;
            if (item.getExpr() instanceof SQLMethodInvokeExpr && isNotEmpty && ((SQLMethodInvokeExpr)item.getExpr()).getArguments().get(0) instanceof SQLIntegerExpr) {
               SQLIdentifierExpr identifierExpr = new SQLIdentifierExpr(((SQLMethodInvokeExpr)item.getExpr()).getMethodName());
               this.createField(identifierExpr, null, true);
            } else {
               this.visitChild(item.getExpr());
            }
         }
      }

      return false;
   }

   public void endVisit(SQLCreateIndexStatement x) {
      this.scope.exitScope();
   }

   public boolean visit(SQLAlterTableStatement x) {
      if (this.scope.context.sqlType == null) {
         this.scope.context.sqlType = TableStat.Mode.Alter;
      }

      this.enterClauseScope(x);
      this.visitChild(x.getTableSource());

      for(SQLAlterTableItem alterTableItem : x.getItems()) {
         this.visitChild(alterTableItem);
      }

      return false;
   }

   public boolean visit(SQLAlterTableAddColumn x) {
      this.visitChild(x.getColumns());
      this.visitChild(x.getFirstColumn());
      this.visitChild(x.getAfterColumn());
      return false;
   }

   public boolean visit(HiveGrantStatement x) {
      if (this.scope.context.sqlType == null) {
         this.scope.context.sqlType = TableStat.Mode.Other;
      }

      this.enterClauseScope(x);

      for(SQLPrivilegeItem privilegeItem : x.getPrivileges()) {
         SQLExpr action = privilegeItem.getAction();
         if (action instanceof SQLIdentifierExpr) {
            String name = ((SQLIdentifierExpr)action).getName();
            if ("PROXY".equalsIgnoreCase(name)) {
               return false;
            }
         }
      }

      this.visitChild(x.getResource());

      for(SQLPrivilegeItem privilegeItem : x.getPrivileges()) {
         this.visitChild(privilegeItem.getColumns());
      }

      return false;
   }

   public void endVisit(HiveGrantStatement x) {
   }

   public boolean visit(SQLAlterTableAddIndex x) {
      this.visitChild(x.getColumns());
      return false;
   }

   public boolean visit(SQLCheck x) {
      this.visitChild(x.getExpr());
      return false;
   }

   public void endVisit(SQLAlterTableStatement x) {
      this.scope.exitScope();
   }

   public boolean visit(SQLInsertStatement x) {
      if (this.scope.context.sqlType == null) {
         this.scope.context.sqlType = TableStat.Mode.Insert;
      }

      this.enterClauseScope(x);
      this.visitChild(x.getWith());
      this.visitChild(x.getTableSource());
      if (x.getColumns().size() == 0) {
         String schema = null;
         String table = null;
         SQLName tableName = x.getTableName();
         if (tableName instanceof SQLIdentifierExpr) {
            SQLIdentifierExpr expr = (SQLIdentifierExpr)tableName;
            table = expr.getName();
            schema = this.scope.context.getSchema();
         } else if (tableName instanceof SQLPropertyExpr) {
            SQLPropertyExpr expr = (SQLPropertyExpr)tableName;
            table = expr.getName();
            schema = expr.getOwnerName();
         }

         if (table != null && schema != null) {
            List<Column> columns = this.scope.context.getColumns(schema, table);
            if (columns != null && columns.size() > 0) {
               for(Column column : columns) {
                  SQLExpr expr = new SQLIdentifierExpr(column.getColumnName());
                  x.getColumns().add(expr);
                  expr.setParent(x);
               }
            }
         }
      }

      for(SQLExpr column : x.getColumns()) {
         this.visitChild(column);
         FieldMemo field = (FieldMemo)column.getAttribute("field");
         if (field != null) {
            field.isSelectItem = true;
         }
      }

      this.visitChild(x.getValuesList());
      this.visitChild(x.getQuery());
      return false;
   }

   public boolean visit(SQLUpdateStatement x) {
      if (this.scope.context.sqlType == null) {
         this.scope.context.sqlType = TableStat.Mode.Update;
      }

      this.enterClauseScope(x);
      this.visitChild(x.getTableSource());
      this.visitChild(x.getFrom());
      this.visitChild(x.getItems());
      this.visitChild(x.getWhere());
      this.visitChild(x.getOrderBy());
      return false;
   }

   public boolean visit(HiveUpdateStatement x) {
      return this.visit((SQLUpdateStatement)x);
   }

   public boolean visit(SQLReplaceStatement x) {
      if (this.scope.context.sqlType == null) {
         this.scope.context.sqlType = TableStat.Mode.Replace;
      }

      this.enterClauseScope(x);
      this.visitChild(x.getTableSource());
      if (x.getColumns().size() == 0) {
         TableMemo table = (TableMemo)x.getTableSource().getAttribute("table");

         for(FieldMemo field : this.scope.getCurrent().expandAllColumns(table, false)) {
            SQLIdentifierExpr expr = new SQLIdentifierExpr();
            expr.setName(field.name);
            x.addColumn(expr);
         }
      }

      for(SQLExpr column : x.getColumns()) {
         this.visitChild(column);
         FieldMemo field = (FieldMemo)column.getAttribute("field");
         if (field != null) {
            field.isSelectItem = true;
         }
      }

      this.visitChild(x.getValuesList());
      this.visitChild(x.getQuery());
      return false;
   }

   public boolean visit(SQLDeleteStatement x) {
      if (this.scope.context.sqlType == null) {
         this.scope.context.sqlType = TableStat.Mode.Delete;
      }

      this.enterClauseScope(x);
      this.visitChild(x.getWith());
      this.visitChild(x.getTableSource());
      this.visitChild(x.getWhere());
      return false;
   }

   public boolean visit(SQLWithSubqueryClause x) {
      if (this.debug) {
         System.out.println("enter SQLWithSubqueryClause  " + x.toString());
      }

      Scope scope = this.enterClauseScope(x);
      scope.top = true;
      scope.fromField = scope.isFromField(x);
      return true;
   }

   public boolean visit(SQLWithSubqueryClause.Entry x) {
      TableScope scope = this.enterTableScope(x);
      scope.fromField = scope.isFromField(x);
      scope.top = true;
      TableMemo table = this.registerTable(x);
      this.visitChild(x.getSubQuery());
      table.topTable = true;
      x.putAttribute("table", table);
      x.putAttribute("scope", scope);
      scope.table = table;
      return false;
   }

   public void endVisit(SQLWithSubqueryClause.Entry x) {
      if (this.debug) {
         System.out.println("enter SQLWithSubqueryClause.Entry  " + x.toString());
      }

      Scope current = this.scope.getCurrent();
      TableMemo table = (TableMemo)x.getAttribute("table");
      boolean addColumns = x.getColumns().size() == 0;
      List<FieldMemo> fields = new ArrayList();
      current.getSubFieldsForWith(fields);

      for(Scope child : current.getChildren()) {
         table.getChildren().addAll(child.getBranchTables());
      }

      current = this.scope.getCurrent();
      int k = 0;

      for(FieldMemo field : fields) {
         FieldMemo newNameField = field.copy();
         newNameField.name = field.alias;
         newNameField.alias = field.alias;
         if (!addColumns) {
            SQLExpr expr = (SQLExpr)x.getColumns().get(k);
            SQLName exprName = (SQLName)expr;
            String fieldName = exprName.getSimpleName();
            if (!this.isEqual(fieldName, field.alias)) {
               newNameField.name = fieldName;
               newNameField.alias = fieldName;
            }

            newNameField.ref = expr;
            newNameField.exprs.add(expr);
         } else {
            SQLIdentifierExpr name = new SQLIdentifierExpr();
            String fieldName = newNameField.name;

            for(AliasField aliasField : field.aliasFields) {
               if (aliasField.isOutput) {
                  fieldName = aliasField.alias;
                  break;
               }
            }

            newNameField.name = fieldName;
            newNameField.alias = fieldName;
            name.setName(fieldName);
            x.getColumns().add(name);
            name.setParent(x);
            newNameField.ref = name;
            newNameField.exprs.add(name);
         }

         newNameField.table = table;
         newNameField.scope = current;
         newNameField.tables.add(table);
         newNameField.children.add(field);
         current.addField(newNameField);
         ++k;
      }

      this.scope.exitScope();
   }

   public boolean visit(HiveSelectQueryBlock x) {
      if (this.debug) {
         System.out.println("enter HiveSelectQueryBlock  " + x.toString());
      }

      this.enterClauseScope(x);
      this.scope.fromField = this.scope.isFromField(x);
      if (x.getFrom() != null) {
         this.parseView(x.getFrom(), x);
         this.replaceUsing(x.getFrom());
      } else {
         SQLIdentifierExpr tableName = new SQLIdentifierExpr();
         tableName.setName("dual");
         SQLExprTableSource tableSource = new SQLExprTableSource();
         tableSource.setExpr((SQLExpr)tableName);
         tableSource.setParent(x);
         x.setFrom(tableSource);
      }

      this.visitChild(x.getFrom());
      this.parseSelectList(x);
      this.visitChild(x.getWindows());
      this.visitChild(x.getWhere());
      this.visitChild(x.getStartWith());
      this.visitChild(x.getConnectBy());
      this.visitChild(x.getGroupBy());
      this.visitChild(x.getOrderBy());
      this.visitChild(x.getDistributeBy());
      this.visitChild(x.getSortBy());
      this.visitChild(x.getWaitTime());
      return false;
   }

   private void parseSelectList(HiveSelectQueryBlock x) {
      Scope current = this.scope.getCurrent();
      List<SQLSelectItem> selectList = x.getSelectList();

      for(int i = 0; i < selectList.size(); ++i) {
         SQLSelectItem item = (SQLSelectItem)selectList.get(i);
         boolean isAll = this.scope.isAllColumn(item.getExpr());
         if (item.getAlias() == null && !isAll) {
            this.setAlias(item);
         }

         if (isAll && item.getAttribute("expanded") == null) {
            item.putAttribute("expanded", true);
            SQLObject parent = item.getParent();
            Owner owner = this.scope.getAllOwner(item.getExpr());
            TableMemo table = owner.alias == null ? null : current.getTable(item.getExpr());
            SQLTableSource tableSource = x.getFrom();
            boolean isSub = table != null && table.isSub || tableSource instanceof SQLSubqueryTableSource || tableSource instanceof SQLUnionQueryTableSource;
            List<FieldMemo> fields = current.expandAllColumns(table, isSub);
            if (fields.size() != 0) {
               int k = 0;
               selectList.remove(i);
               String alias = x.getFrom().getAlias();
               if (alias == null) {
                  alias = owner.alias;
               }

               for(FieldMemo field : fields) {
                  TableMemo fieldTable = field.table;
                  SQLPropertyExpr propExpr = new SQLPropertyExpr();
                  propExpr.setOwner(alias == null ? fieldTable.alias : alias);
                  propExpr.setName(field.alias);
                  SQLSelectItem newItem = new SQLSelectItem();
                  newItem.setParent(parent);
                  newItem.setExpr(propExpr);
                  newItem.setAlias(field.alias);
                  field.scope = current;
                  field.isSelectItem = true;
                  field.ref = newItem;
                  field.exprs.add(propExpr);
                  selectList.add(i + k++, newItem);
               }
            }
         }
      }

      int k = Integer.MIN_VALUE;

      for(SQLSelectItem item : selectList) {
         SQLExpr sqlExpr = item.getExpr();
         boolean isPrimitive = this.scope.isPrimitive(sqlExpr);
         item.putAttribute("isPrimitive", isPrimitive);
         this.visitChild(item);
         FieldMemo field = (FieldMemo)sqlExpr.getAttribute("field");
         if (sqlExpr instanceof SQLValuableExpr) {
            field.isConstant = true;
         }

         field.id = k++;
      }

   }

   private SQLTableSource parseView(SQLTableSource ts, SQLObject parent) {
      if (ts instanceof SQLExprTableSource) {
         SQLTableSource viewTableSource = this.getViewTableSource(ts);
         if (viewTableSource != null) {
            if (parent instanceof HiveSelectQueryBlock) {
               HiveSelectQueryBlock block = (HiveSelectQueryBlock)parent;
               block.setFrom(viewTableSource);
               viewTableSource.setParent(parent);
            }

            return viewTableSource;
         }
      } else if (ts instanceof SQLJoinTableSource) {
         SQLJoinTableSource jts = (SQLJoinTableSource)ts;
         SQLTableSource left = this.parseView(jts.getLeft(), jts);
         if (left != null) {
            jts.setLeft(left);
            left.setParent(jts);
         }

         SQLTableSource right = this.parseView(jts.getRight(), jts);
         if (right != null) {
            jts.setRight(right);
            right.setParent(jts);
         }
      }

      return null;
   }

   private void replaceUsing(SQLTableSource ts) {
      if (ts instanceof SQLJoinTableSource) {
         this.parseUsing((SQLJoinTableSource)ts);
      }
   }

   private void parseUsing(SQLJoinTableSource jts) {
      SQLTableSource leftTable = jts.getLeft();
      if (leftTable instanceof SQLJoinTableSource) {
         this.parseUsing((SQLJoinTableSource)leftTable);
      }

      SQLTableSource rightTable = jts.getRight();
      String rightAlias = rightTable.getAlias();
      if (rightAlias == null) {
         rightAlias = rightTable.toString();
      }

      String leftAlias = (String)leftTable.getAttribute("join-alias");
      if (leftAlias == null) {
         leftAlias = leftTable.getAlias();
      }

      if (leftAlias == null) {
         leftAlias = leftTable.toString();
      }

      jts.putAttribute("join-alias", rightAlias);
      if (jts.getUsing() != null && jts.getUsing().size() != 0) {
         SQLBinaryOpExpr link = jts.getUsing().size() > 1 ? new SQLBinaryOpExpr() : null;

         for(int i = 0; i < jts.getUsing().size(); ++i) {
            SQLExpr sqlExpr = (SQLExpr)jts.getUsing().get(i);
            sqlExpr.setParent((SQLObject)null);
            SQLBinaryOpExpr eqExpr = new SQLBinaryOpExpr();
            eqExpr.setOperator(SQLBinaryOperator.Equality);
            SQLPropertyExpr left = new SQLPropertyExpr();
            left.setOwner(leftAlias);
            left.setName(sqlExpr.toString());
            eqExpr.setLeft(left);
            SQLPropertyExpr right = new SQLPropertyExpr();
            right.setOwner(rightAlias);
            right.setName(sqlExpr.toString());
            eqExpr.setRight(right);
            if (link == null) {
               link = eqExpr;
               break;
            }

            if (i == 0) {
               link.setLeft(eqExpr);
               link.setOperator(SQLBinaryOperator.BooleanAnd);
            } else {
               link.setRight(eqExpr);
               if (i < jts.getUsing().size() - 1) {
                  SQLBinaryOpExpr chain = new SQLBinaryOpExpr();
                  chain.setOperator(SQLBinaryOperator.BooleanAnd);
                  chain.setLeft(link);
                  link = chain;
               }
            }
         }

         SQLExpr conditon = jts.getCondition();
         if (conditon == null) {
            jts.setCondition(link);
         } else {
            SQLBinaryOpExpr operator = new SQLBinaryOpExpr();
            operator.setOperator(SQLBinaryOperator.BooleanAnd);
            operator.setLeft(link);
            operator.setRight(conditon);
         }

         jts.getUsing().clear();
      }
   }

   private SQLTableSource getViewTableSource(SQLTableSource ts) {
      SQLExprTableSource e = (SQLExprTableSource)ts;
      String name = e.getTableName();
      String schema = e.getSchema() == null ? this.scope.getDefaultSchema() : e.getSchema();
      if (name != null) {
         SQLSelect view = this.scope.context.getView(schema.toLowerCase(), name.toLowerCase());
         if (view != null && this.scope.context.sqlType == TableStat.Mode.Select) {
            SQLSubqueryTableSource subQuery = new SQLSubqueryTableSource();
            String alias = e.getAlias() == null ? e.getTableName() : e.getAlias();
            subQuery.setAlias(alias);
            subQuery.setSelect(view.clone());
            return subQuery;
         }
      }

      return null;
   }

   public boolean visit(SQLUnionQuery x) {
      Scope scope = this.enterClauseScope(x);
      scope.union = true;
      scope.isolated = false;
      this.visitChild(x.getRelations());

      for(Scope s1 : scope.getChildren()) {
         s1.isolated = false;
      }

      this.visitChild(x.getOrderBy());
      this.visitChild(x.getLimit());
      return false;
   }

   public boolean visit(SQLLateralViewTableSource x) {
      TableMemo table = this.registerTable((SQLTableSource)x);
      TableScope scope = this.enterTableScope(x);
      scope.table = table;
      scope.isolated = false;
      return true;
   }

   public boolean visit(SQLSubqueryTableSource x) {
      if (this.debug) {
         System.out.println("enter SQLSubqueryTableSource  " + x.toString());
      }

      if (x.getAlias() == null) {
         x.setAlias(this.alias.aliasTable());
      }

      TableMemo table = this.registerTable((SQLTableSource)x);
      TableScope scope = this.enterTableScope(x);
      scope.table = table;
      scope.isolated = false;
      return true;
   }

   public boolean visit(SQLValuesTableSource x) {
      if (this.debug) {
         System.out.println("begin SQLValuesTableSource  " + x.toString());
      }

      return true;
   }

   public boolean visit(SQLJoinTableSource x) {
      this.scope.getCurrent().join = true;
      return true;
   }

   public boolean visit(SQLUnionQueryTableSource x) {
      TableMemo table = this.registerTable((SQLTableSource)x);
      TableScope scope = this.enterTableScope(x);
      scope.union = true;
      scope.fromField = scope.isFromField(x);
      scope.isolated = false;
      x.putAttribute("table", table);
      x.putAttribute("scope", scope);
      scope.table = table;
      return true;
   }

   public boolean visit(SQLExprTableSource x) {
      this.registerTable((SQLTableSource)x);
      return true;
   }

   public boolean visit(HiveCharExpr x) {
      return false;
   }

   public boolean visit(SQLSelectItem x) {
      FieldMemo field = this.createField(x.getExpr(), x.getAlias(), true);
      field.ref = x;
      return false;
   }

   public boolean visit(SQLMethodInvokeExpr x) {
      if (x.getAttribute("parsed") == null) {
         SQLObject parent = x.getParent();
         if (parent != null && parent instanceof SQLBinaryOpExpr) {
            SQLBinaryOpExpr binaryOpExpr = (SQLBinaryOpExpr)parent;
            switch (binaryOpExpr.getOperator()) {
               case Like:
               case Like2:
               case Like4:
               case Likec:
               case NotLike:
               case NotEqual:
               case LessThanOrGreater:
               case Equality:
               case GreaterThan:
               case GreaterThanOrEqual:
               case LessThan:
               case LessThanOrEqual:
               case BooleanAnd:
               case BooleanOr:
                  x.putAttribute("parsed", 1);
                  this.createField(x, "", false);
                  return true;
            }
         }

         return true;
      } else {
         List<SQLExpr> arguments = x.getArguments();
         if (arguments == null) {
            return false;
         } else {
            for(SQLExpr argument : arguments) {
               argument.accept(this);
            }

            return false;
         }
      }
   }

   public boolean visit(SQLIdentifierExpr x) {
      if (this.scope.getCurrent().isFieldState()) {
         FieldMemo field = this.createField(x, x.getName(), false);
         x.putAttribute("field", field);
      } else if (!(x.getParent() instanceof SQLTableSource) && !(x.getParent() instanceof SQLPartition)) {
         x.putAttribute("orderBy", x.getParent() instanceof SQLSelectOrderByItem);
         FieldMemo field = this.createField(x, x.getName(), false);
         x.putAttribute("field", field);
         if (x.getParent() instanceof SQLUpdateSetItem) {
            field.isSelectItem = true;
         }
      }

      return false;
   }

   public boolean visit(SQLPropertyExpr x) {
      if (this.scope.getCurrent().isFieldState()) {
         FieldMemo field = this.createField(x, x.getName(), false);
         x.putAttribute("field", field);
      } else if (!(x.getParent() instanceof SQLTableSource) && !(x.getParent() instanceof SQLPartition)) {
         x.putAttribute("orderBy", x.getParent() instanceof SQLSelectOrderByItem);
         FieldMemo field = this.createField(x, x.getName(), false);
         x.putAttribute("field", field);
         if (x.getParent() instanceof SQLUpdateSetItem) {
            field.isSelectItem = true;
         }
      }

      return false;
   }

   private FieldMemo createField(SQLExpr expr, String alias, boolean isSelectItem) {
      Scope current = this.scope.getCurrent();
      FieldMemo field = new FieldMemo();
      if (expr instanceof SQLIdentifierExpr) {
         SQLIdentifierExpr idExpr = (SQLIdentifierExpr)expr;
         boolean isOrderBy = expr.getAttribute("orderBy") != null && (Boolean)expr.getAttribute("orderBy");
         if (isOrderBy) {
            String name = current.dialector.wrap(idExpr.getSimpleName());
            FieldMemo exist = current.getFieldByAlias(name);
            if (exist != null) {
               return exist;
            }
         }

         field.name = idExpr.getName();
         field.atom = true;
         this.setField(field, alias, isSelectItem, expr);
         field.children = this.scope.getCurrent().getSubRelationFields(field);
         this.setConstant(field);
         this.setAtom(field);
         field = current.addField(field);
      } else if (expr instanceof SQLPropertyExpr) {
         SQLPropertyExpr prop = (SQLPropertyExpr)expr;
         field.name = prop.getName();
         field.atom = true;
         this.setField(field, alias, isSelectItem, expr);
         field.children = this.scope.getCurrent().getSubRelationFields(field);
         this.setConstant(field);
         this.setAtom(field);
         field = current.addField(field);
      } else if (expr instanceof SQLValuableExpr) {
         field.name = alias;
         field.isConstant = true;
         this.setField(field, alias, isSelectItem, expr);
         field = current.addField(field);
      } else {
         alias = current.dialector.wrapAlias(alias);
         field.name = alias;
         field.alias = alias;
         field.isSelectItem = isSelectItem;
         field.complex = true;
         field.ref = expr;
         if (expr instanceof SQLSelectItem) {
            field.exprs.add(((SQLSelectItem)expr).getExpr());
            AliasField aliasField = new AliasField();
            aliasField.alias = alias;
            aliasField.field = field;
            aliasField.expr = expr;
            aliasField.isOutput = true;
            aliasField.scope = this.scope.getCurrent();
         } else {
            field.exprs.add(expr);
            AliasField aliasField = new AliasField();
            aliasField.alias = alias;
            aliasField.field = field;
            aliasField.expr = expr;
            aliasField.scope = this.scope.getCurrent();
         }

         current.openFieldState();
         this.visitChild(expr);
         current.closeFieldState();
         List<SQLExpr> exprs = current.getSubFieldExprs(expr);
         List<FieldMemo> subFields = new ArrayList();
         current.getFieldsByExprs(exprs, subFields);
         List<TableMemo> tables = new ArrayList();
         List<FieldMemo> children = new ArrayList();
         Set<String> names = new HashSet();
         boolean isPrimitive = this.scope.isPrimitive(expr);
         if (!isPrimitive) {
            current.getSubBranchFields(subFields);
         }

         if (subFields.size() <= 0) {
            tables.addAll(current.getBranchTables());
         } else {
            for(FieldMemo subField : subFields) {
               if (!names.contains(subField.getUniqueName())) {
                  children.add(subField);
                  names.add(subField.getUniqueName());
               }

               if (subField.table != null && !names.contains(subField.table.getQualifiedName())) {
                  tables.add(subField.table);
                  names.add(subField.table.getQualifiedName());
               } else if (subField.tables.size() > 0) {
                  for(TableMemo table : subField.tables) {
                     if (!names.contains(table.getQualifiedName())) {
                        tables.add(table);
                        names.add(table.getQualifiedName());
                     }
                  }
               }
            }
         }

         field.tables = tables;
         if (tables.size() == 1) {
            field.table = (TableMemo)tables.get(0);
         }

         field.children = children;
         this.setAtom(field);
         field = current.addField(field);
      }

      expr.putAttribute("field", field);
      return field;
   }

   private void setConstant(FieldMemo field) {
      if (field.children != null && field.children.size() > 0) {
         boolean flag = true;

         for(FieldMemo child : field.children) {
            if (!child.isConstant) {
               flag = false;
               break;
            }
         }

         field.isConstant = flag;
      }

   }

   private void setAtom(FieldMemo field) {
      if (field.children.size() != 0) {
         if (field.name == null) {
            field.atom = false;
         } else {
            Set<String> fdNames = field.tableNames();
            boolean found = false;

            for(FieldMemo child : field.children) {
               if (child.name != null && this.isEqual(field.name, child.alias)) {
                  Set<String> cdNames = child.tableNames();
                  cdNames.retainAll(fdNames);
                  if (cdNames.size() > 0) {
                     found = true;
                  }
               }
            }

            if (!found) {
               field.atom = false;
            }

         }
      }
   }

   private void setField(FieldMemo field, String alias, boolean isSelectItem, SQLExpr expr) {
      Scope current = this.scope.getCurrent();
      field.alias = alias == null ? field.name : alias;
      field.alias = current.dialector.wrap(field.alias);
      field.name = current.dialector.wrap(field.name);
      field.isSelectItem = isSelectItem;
      field.ref = expr;
      field.table = this.scope.getCurrent().getTable(expr);
      field.tables.add(field.table);
      field.exprs.add(expr);
      AliasField aliasField = new AliasField();
      aliasField.alias = alias;
      aliasField.field = field;
      aliasField.expr = expr;
      aliasField.isOutput = isSelectItem;
      aliasField.scope = this.scope.getCurrent();
   }

   private TableMemo registerTable(SQLTableSource x) {
      Scope current = this.scope.getCurrent();
      if (x instanceof SQLExprTableSource) {
         SQLExprTableSource exprTableSource = (SQLExprTableSource)x;
         TableMemo table = new TableMemo(x);
         SQLExprTableSource tableSource = (SQLExprTableSource)x;
         String tableName = current.dialector.wrap(tableSource.getTableName());
         String schemaName = current.dialector.wrap(tableSource.getSchema() == null ? this.scope.getDefaultSchema() : tableSource.getSchema());
         table.name = tableName;
         table.alias = current.dialector.wrap(tableSource.getAlias() == null ? table.name : tableSource.getAlias());
         table.nowName = table.alias;
         if (table.name == null) {
            table.name = table.alias;
         }

         if (table.name.equals("*") && exprTableSource.getExpr() != null && exprTableSource.getExpr() instanceof SQLPropertyExpr) {
            return null;
         } else {
            if (table.name == null && table.alias != null) {
               table.name = table.alias;
            }

            if (exprTableSource.getExpr() != null && exprTableSource.getExpr() instanceof SQLMethodInvokeExpr) {
               table.isSub = true;
            }

            table.schema = schemaName;
            TableMemo refTable = current.getParentTable(schemaName, tableName);
            if (refTable != null && refTable.topTable) {
               table.schema = refTable.schema;
               table.topTable = true;
               table.scope = current;
               table.refTable = refTable;
               refTable.getChildren().add(table);
               current.addTable(table);
               table.topTable = refTable.topTable;
               return refTable;
            } else {
               boolean isFunction = false;
               SQLExpr expr = ((SQLExprTableSource)x).getExpr();
               isFunction = expr instanceof SQLMethodInvokeExpr;
               this.setTableRelation(table);
               table.system = this.scope.dialector.isSystemTable(table.name);
               if (!table.isSub && !isFunction && !table.system) {
                  this.scope.context.append(table);
               }

               x.putAttribute("table", table);
               return table;
            }
         }
      } else if (x instanceof SQLSubqueryTableSource) {
         SQLSubqueryTableSource tableSource = (SQLSubqueryTableSource)x;
         TableMemo table = new TableMemo(x);
         table.name = current.dialector.wrap(tableSource.getAlias());
         table.alias = table.name;
         table.nowName = table.name;
         table.schema = current.dialector.wrap(this.scope.getDefaultSchema());
         table.isSub = true;
         this.setTableRelation(table);
         x.putAttribute("table", table);
         return table;
      } else if (x instanceof SQLLateralViewTableSource) {
         SQLLateralViewTableSource tableSource = (SQLLateralViewTableSource)x;
         TableMemo table = new TableMemo(x);
         table.name = current.dialector.wrap(tableSource.getAlias());
         table.alias = table.name;
         table.schema = current.dialector.wrap(this.scope.getDefaultSchema());
         table.isSub = true;
         this.setTableRelation(table);
         x.putAttribute("table", table);
         return table;
      } else if (x instanceof SQLUnionQueryTableSource) {
         SQLUnionQueryTableSource tableSource = (SQLUnionQueryTableSource)x;
         TableMemo table = new TableMemo(x);
         table.name = current.dialector.wrap(tableSource.getAlias());
         table.alias = table.name;
         table.schema = current.dialector.wrap(this.scope.getDefaultSchema());
         table.nowName = table.name;
         table.isSub = true;
         this.setTableRelation(table);
         x.putAttribute("table", table);
         return table;
      } else {
         return null;
      }
   }

   private TableMemo registerTable(SQLWithSubqueryClause.Entry x) {
      Scope current = this.scope.getCurrent();
      TableMemo table = new TableMemo(x);
      table.name = current.dialector.wrap(x.getAlias());
      table.nowName = table.name;
      table.alias = table.name;
      table.schema = current.dialector.wrap(this.scope.getDefaultSchema());
      table.isSub = true;
      table.topTable = true;
      this.setTableRelation(table);
      return table;
   }

   private void setTableRelation(TableMemo table) {
      Scope current = this.scope.getCurrent();
      table.name = current.dialector.wrap(table.name);
      table.alias = current.dialector.wrap(table.alias);
      table.schema = current.dialector.wrap(table.schema);
      table.scope = current;
      current.addTable(table);
      TableScope tableScope = current.getNearestParentTableScope();
      if (tableScope != null) {
         TableMemo parentTable = tableScope.table;
         if (parentTable != null) {
            parentTable.getChildren().add(table);
            if (table.isSub) {
               parentTable.isSub = true;
            }
         }
      }

   }

   private TableScope enterTableScope(SQLTableSource x) {
      TableScope ts = new TableScope();
      ts.ref = x;
      ts.alias = ts.name = x.getAlias();
      this.scope.enterScope((Scope)ts);
      return ts;
   }

   private ClauseScope enterClauseScope(SQLObject x) {
      ClauseScope clauseScope = new ClauseScope();
      clauseScope.ref = x;
      this.scope.enterScope((Scope)clauseScope);
      return clauseScope;
   }

   private void setAlias(SQLSelectItem x) {
      if (x.getAlias() == null) {
         SQLExpr e = x.getExpr();
         if (e instanceof SQLIdentifierExpr) {
            x.setAlias(((SQLIdentifierExpr)e).getName());
         } else if (e instanceof SQLPropertyExpr) {
            x.setAlias(((SQLPropertyExpr)e).getName());
         } else if (e instanceof SQLNumericLiteralExpr) {
            x.setAlias("`" + e + "`");
         } else {
            x.setAlias(this.scope.dialector.wrapAlias(e.toString()));
         }

      }
   }

   public void endVisit(SQLMethodInvokeExpr x) {
      if ("LATERAL".equalsIgnoreCase(x.getMethodName())) {
         this.scope.getCurrent().isolated = false;

         for(Scope s : this.scope.getCurrent().getChildren()) {
            s.isolated = false;
         }
      }

   }
}
