package com.alibaba.druid.sql.ast.expr;

import com.alibaba.druid.FastsqlException;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLDataTypeImpl;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class SQLIntervalExpr extends SQLExprImpl implements SQLReplaceable {
   public static final SQLDataType DATA_TYPE = new SQLDataTypeImpl("interval");
   private SQLExpr value;
   private SQLIntervalUnit unit;

   public SQLIntervalExpr() {
   }

   public SQLIntervalExpr(SQLExpr value, SQLIntervalUnit unit) {
      this.setValue(value);
      this.unit = unit;
   }

   public SQLIntervalExpr clone() {
      SQLIntervalExpr x = new SQLIntervalExpr();
      if (this.value != null) {
         x.setValue(this.value.clone());
      }

      x.unit = this.unit;
      return x;
   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      if (this.value == expr) {
         this.setValue(target);
         return true;
      } else {
         return false;
      }
   }

   public SQLExpr getValue() {
      return this.value;
   }

   public void setValue(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.value = x;
   }

   public SQLIntervalUnit getUnit() {
      return this.unit;
   }

   public void setUnit(SQLIntervalUnit unit) {
      this.unit = unit;
   }

   public void output(Appendable buf) {
      try {
         buf.append("INTERVAL ");
         this.value.output(buf);
         if (this.unit != null) {
            buf.append(' ');
            buf.append(this.unit.name());
         }

      } catch (IOException ex) {
         throw new FastsqlException("output error", ex);
      }
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this) && this.value != null) {
         this.value.accept(visitor);
      }

      visitor.endVisit(this);
   }

   public List getChildren() {
      return Collections.singletonList(this.value);
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
      result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         SQLIntervalExpr other = (SQLIntervalExpr)obj;
         if (this.unit != other.unit) {
            return false;
         } else {
            if (this.value == null) {
               if (other.value != null) {
                  return false;
               }
            } else if (!this.value.equals(other.value)) {
               return false;
            }

            return true;
         }
      }
   }

   public SQLDataType computeDataType() {
      return DATA_TYPE;
   }
}
