package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLAlterTableDropPartition extends SQLObjectImpl implements SQLAlterTableItem {
   private boolean ifExists = false;
   private boolean purge;
   private final List<SQLExpr> partitions = new ArrayList(4);

   public List<SQLExpr> getPartitions() {
      return this.partitions;
   }

   public void addPartition(SQLExpr partition) {
      if (partition != null) {
         partition.setParent(this);
      }

      this.partitions.add(partition);
   }

   public boolean isIfExists() {
      return this.ifExists;
   }

   public void setIfExists(boolean ifExists) {
      this.ifExists = ifExists;
   }

   public boolean isPurge() {
      return this.purge;
   }

   public void setPurge(boolean purge) {
      this.purge = purge;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.partitions);
      }

      visitor.endVisit(this);
   }
}
