package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class SQLAlterTablePartitionLifecycle extends SQLObjectImpl implements SQLAlterTableItem {
   private SQLIntegerExpr lifecycle;

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.lifecycle);
      }

      visitor.endVisit(this);
   }

   public SQLIntegerExpr getLifecycle() {
      return this.lifecycle;
   }

   public void setLifecycle(SQLIntegerExpr lifecycle) {
      if (lifecycle != null) {
         lifecycle.setParent(this);
      }

      this.lifecycle = lifecycle;
   }
}
