package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class SQLColumnCheck extends SQLConstraintImpl implements SQLColumnConstraint, SQLReplaceable {
   private SQLExpr expr;

   public SQLColumnCheck() {
   }

   public SQLColumnCheck(SQLExpr expr) {
      this.setExpr(expr);
   }

   public SQLExpr getExpr() {
      return this.expr;
   }

   public void setExpr(SQLExpr expr) {
      if (expr != null) {
         expr.setParent(this);
      }

      this.expr = expr;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.getName());
         this.acceptChild(visitor, this.getExpr());
      }

      visitor.endVisit(this);
   }

   public SQLColumnCheck clone() {
      SQLColumnCheck x = new SQLColumnCheck();
      super.cloneTo((SQLConstraintImpl)x);
      if (this.expr != null) {
         x.setExpr(this.expr.clone());
      }

      return x;
   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      if (this.expr == expr) {
         this.setExpr(target);
         return true;
      } else if (this.getName() == expr) {
         this.setName((SQLName)target);
         return true;
      } else if (this.getComment() == expr) {
         this.setComment(target);
         return true;
      } else {
         return false;
      }
   }
}
