package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.sql.ast.SQLHint;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLLateralViewTableSource extends SQLTableSourceImpl {
   private SQLTableSource tableSource;
   private boolean outer;
   private SQLMethodInvokeExpr method;
   private List<SQLName> columns = new ArrayList(2);

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.tableSource);
         this.acceptChild(visitor, this.method);
         this.acceptChild(visitor, this.columns);
      }

      visitor.endVisit(this);
   }

   public SQLTableSource getTableSource() {
      return this.tableSource;
   }

   public void setTableSource(SQLTableSource tableSource) {
      if (tableSource != null) {
         tableSource.setParent(this);
      }

      this.tableSource = tableSource;
   }

   public SQLMethodInvokeExpr getMethod() {
      return this.method;
   }

   public void setMethod(SQLMethodInvokeExpr method) {
      if (method != null) {
         method.setParent(this);
      }

      this.method = method;
   }

   public List<SQLName> getColumns() {
      return this.columns;
   }

   public void setColumns(List<SQLName> columns) {
      this.columns = columns;
   }

   public SQLTableSource findTableSource(long alias_hash) {
      long hash = this.aliasHashCode64();
      if (hash != 0L && hash == alias_hash) {
         return this;
      } else {
         for(SQLName column : this.columns) {
            if (column.nameHashCode64() == alias_hash) {
               return this;
            }
         }

         if (this.tableSource != null) {
            return this.tableSource.findTableSource(alias_hash);
         } else {
            return null;
         }
      }
   }

   public SQLTableSource findTableSourceWithColumn(long columnNameHash, String columnName, int option) {
      for(SQLName column : this.columns) {
         if (column.nameHashCode64() == columnNameHash) {
            return this;
         }
      }

      if (this.tableSource != null) {
         return this.tableSource.findTableSourceWithColumn(columnNameHash, columnName, option);
      } else {
         return null;
      }
   }

   public SQLLateralViewTableSource clone() {
      SQLLateralViewTableSource x = new SQLLateralViewTableSource();
      x.setAlias(this.alias);
      x.outer = this.outer;
      if (this.tableSource != null) {
         x.setTableSource(this.tableSource.clone());
      }

      if (this.method != null) {
         x.setMethod(this.method.clone());
      }

      for(SQLName column : this.columns) {
         SQLName e2 = column.clone();
         e2.setParent(x);
         x.getColumns().add(e2);
      }

      if (this.flashback != null) {
         x.setFlashback(this.flashback.clone());
      }

      if (this.hints != null) {
         for(SQLHint e : this.hints) {
            SQLHint e2 = e.clone();
            e2.setParent(x);
            x.getHints().add(e2);
         }
      }

      return x;
   }

   public boolean isOuter() {
      return this.outer;
   }

   public void setOuter(boolean outer) {
      this.outer = outer;
   }
}
