package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.ast.SQLStatementImpl;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class SQLShowSessionStatement extends SQLStatementImpl implements SQLShowStatement, SQLReplaceable {
   protected SQLExpr like;

   public SQLExpr getLike() {
      return this.like;
   }

   public void setLike(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.like = x;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this) && this.like != null) {
         this.like.accept(visitor);
      }

   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      if (this.like == expr) {
         this.setLike(target);
         return true;
      } else {
         return false;
      }
   }
}
