package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.ast.SQLStatementImpl;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class SQLShowTableGroupsStatement extends SQLStatementImpl implements SQLShowStatement, SQLReplaceable {
   protected SQLName database;

   public SQLName getDatabase() {
      return this.database;
   }

   public void setDatabase(SQLName database) {
      if (database != null) {
         database.setParent(this);
      }

      this.database = database;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.database);
      }

   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      if (this.database == expr) {
         this.setDatabase((SQLName)target);
         return true;
      } else {
         return false;
      }
   }
}
