package com.alibaba.druid.sql.dialect.db2.ast.stmt;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.statement.SQLGrantStatement;
import com.alibaba.druid.sql.dialect.db2.ast.DB2SQLObject;
import com.alibaba.druid.sql.dialect.db2.ast.expr.DB2SQLObjectCollection;
import com.alibaba.druid.sql.dialect.db2.visitor.DB2ASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

import java.util.List;

public class DB2GrantStatement extends SQLGrantStatement implements DB2SQLObject {
   private boolean on;
   private SQLExpr roleName;
   DB2SQLObjectCollection groups = new DB2SQLObjectCollection();

   public boolean isOn() {
      return this.on;
   }

   public void setOn(boolean on) {
      this.on = on;
   }

   public SQLExpr getRoleName() {
      return this.roleName;
   }

   public void setRoleName(SQLExpr roleName) {
      this.roleName = roleName;
   }

   public DB2GrantStatement() {
      this.dbType = DbType.db2;
   }

   public void addGroup(SQLObject o) {
      this.groups.add(o);
      o.setParent(this);
   }

   public DB2SQLObjectCollection getGroups() {
      return this.groups;
   }

   public void setGroups(DB2SQLObjectCollection groups) {
      this.groups = groups;
   }

   public void accept0(SQLASTVisitor visitor) {
      this.accept0((DB2ASTVisitor)visitor);
   }

   public void accept0(DB2ASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.privileges);
         this.acceptChild(visitor, this.resource);
         this.acceptChild(visitor, this.users);
         this.acceptChild(visitor, (List<SQLObject>)this.groups);
         if (this.groups != null && this.groups.size() > 0) {
            for(SQLObject group : this.groups) {
               this.acceptChild(visitor, group);
            }
         }
      }

      visitor.endVisit(this);
   }
}
