package com.alibaba.druid.sql.dialect.dm.ast.stmt;

import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLPartitionValue;
import com.alibaba.druid.sql.ast.SQLSubPartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.druid.sql.dialect.dm.ast.DmSQLObjectImpl;
import com.alibaba.druid.sql.dialect.dm.visitor.DmASTVisitor;

public class DmAlterTableModifyPartition extends DmSQLObjectImpl implements SQLAlterTableItem {
   private SQLName name;
   private Type type;
   private SQLSubPartition subPartition;
   private SQLPartitionValue values;
   private Action action;

   public void accept0(DmASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.subPartition);
         this.acceptChild(visitor, this.values);
      }

      visitor.endVisit(this);
   }

   public SQLName getName() {
      return this.name;
   }

   public void setName(SQLName name) {
      this.name = name;
   }

   public Type getType() {
      return this.type;
   }

   public void setType(Type type) {
      this.type = type;
   }

   public SQLSubPartition getSubPartition() {
      return this.subPartition;
   }

   public void setSubPartition(SQLSubPartition subPartition) {
      this.subPartition = subPartition;
   }

   public SQLPartitionValue getValues() {
      return this.values;
   }

   public void setValues(SQLPartitionValue values) {
      this.values = values;
   }

   public Action getAction() {
      return this.action;
   }

   public void setAction(Action action) {
      this.action = action;
   }

   public static enum Type {
      PARTITION,
      SUBPARTITION;
   }

   public static enum Action {
      ADD,
      DROP;
   }
}
