package com.alibaba.druid.sql.dialect.dm.ast.stmt;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.dialect.dm.ast.DmSQLObjectImpl;
import com.alibaba.druid.sql.dialect.dm.visitor.DmASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class DmExceptionStatement extends DmStatementImpl implements DmStatement {
   private List<Item> items = new ArrayList();

   public List<Item> getItems() {
      return this.items;
   }

   public void addItem(Item item) {
      if (item != null) {
         item.setParent(this);
      }

      this.items.add(item);
   }

   public void accept0(DmASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.items);
      }

      visitor.endVisit(this);
   }

   public DmExceptionStatement clone() {
      DmExceptionStatement x = new DmExceptionStatement();

      for(Item item : this.items) {
         Item item2 = item.clone();
         item2.setParent(x);
         x.items.add(item2);
      }

      return x;
   }

   public static class Item extends DmSQLObjectImpl {
      private SQLExpr when;
      private List<SQLStatement> statements = new ArrayList();

      public SQLExpr getWhen() {
         return this.when;
      }

      public void setWhen(SQLExpr when) {
         this.when = when;
      }

      public List<SQLStatement> getStatements() {
         return this.statements;
      }

      public void setStatement(SQLStatement statement) {
         if (statement != null) {
            statement.setParent(this);
            this.statements.add(statement);
         }

      }

      public void accept0(DmASTVisitor visitor) {
         if (visitor.visit(this)) {
            this.acceptChild(visitor, this.when);
            this.acceptChild(visitor, this.statements);
         }

         visitor.endVisit(this);
      }

      public Item clone() {
         Item x = new Item();
         if (this.when != null) {
            x.setWhen(this.when.clone());
         }

         for(SQLStatement stmt : this.statements) {
            SQLStatement stmt2 = stmt.clone();
            stmt2.setParent(x);
            x.statements.add(stmt2);
         }

         return x;
      }
   }
}
