package com.alibaba.druid.sql.dialect.dm.ast.stmt;

import com.alibaba.druid.sql.ast.statement.SQLColumnReference;
import com.alibaba.druid.sql.dialect.dm.ast.DMSQLObject;
import com.alibaba.druid.sql.dialect.dm.visitor.DmASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class DmSQLColumnReference extends SQLColumnReference implements DMSQLObject {
   private Boolean pendant;
   private Boolean withIndex;

   protected void accept0(SQLASTVisitor v) {
      if (v instanceof DmASTVisitor) {
         this.accept0((DmASTVisitor)v);
      } else {
         if (v instanceof SQLASTOutputVisitor) {
            ((SQLASTOutputVisitor)v).print(this.toString());
         }

      }
   }

   public void accept0(DmASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.getName());
      }

      visitor.endVisit(this);
   }

   public Boolean getPendant() {
      return this.pendant;
   }

   public void setPendant(Boolean pendant) {
      this.pendant = pendant;
   }

   public Boolean getWithIndex() {
      return this.withIndex;
   }

   public void setWithIndex(Boolean withIndex) {
      this.withIndex = withIndex;
   }
}
