package com.alibaba.druid.sql.dialect.dm.ast.stmt;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.dialect.dm.visitor.DmASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class DmSelectSubqueryTableSource extends SQLSubqueryTableSource implements DmSelectTableSource {
   protected DmSelectPivotBase pivot;

   public DmSelectSubqueryTableSource() {
   }

   public DmSelectSubqueryTableSource(String alias) {
      super(alias);
   }

   public DmSelectSubqueryTableSource(SQLSelect select, String alias) {
      super(select, alias);
   }

   public DmSelectSubqueryTableSource(SQLSelect select) {
      super(select);
   }

   public DmSelectPivotBase getPivot() {
      return this.pivot;
   }

   public void setPivot(DmSelectPivotBase pivot) {
      this.pivot = pivot;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor instanceof DmASTVisitor) {
         this.accept0((DmASTVisitor)visitor);
      }

   }

   protected void accept0(DmASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.getHints());
         this.acceptChild(visitor, this.select);
         this.acceptChild(visitor, this.pivot);
         this.acceptChild(visitor, this.flashback);
      }

      visitor.endVisit(this);
   }

   public String toString() {
      return SQLUtils.toDmString(this);
   }

   public DmSelectSubqueryTableSource clone() {
      DmSelectSubqueryTableSource x = new DmSelectSubqueryTableSource();
      this.cloneTo(x);
      if (this.pivot != null) {
         this.setParent(this.pivot.clone());
      }

      return x;
   }
}
