package com.alibaba.druid.sql.dialect.kingbase.ast.expression;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.druid.sql.dialect.kingbase.KingbaseExpr;
import com.alibaba.druid.sql.dialect.kingbase.visitor.KingbaseASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class KingbaseForUpdateExpr extends SQLExprImpl implements KingbaseExpr, SQLLiteralExpr, SQLReplaceable {
   private LockStrength lockStrength;
   private List<SQLExpr> ofTables = new ArrayList();
   private LockType lockType;

   public boolean replace(SQLExpr expr, SQLExpr target) {
      for(int i = 0; i < this.ofTables.size(); ++i) {
         SQLExpr e = (SQLExpr)this.ofTables.get(i);
         if (e == expr) {
            this.ofTables.set(i, target);
            return true;
         }
      }

      return false;
   }

   protected void accept0(SQLASTVisitor v) {
      this.accept0((KingbaseASTVisitor)v);
   }

   public void accept0(KingbaseASTVisitor visitor) {
      if (visitor.visit(this) && this.ofTables != null && this.ofTables.size() > 0) {
         for(SQLExpr ofTable : this.ofTables) {
            ofTable.accept(visitor);
         }
      }

   }

   public LockStrength getLockStrength() {
      return this.lockStrength;
   }

   public void setLockStrength(LockStrength lockStrength) {
      this.lockStrength = lockStrength;
   }

   public List<SQLExpr> getOfTables() {
      return this.ofTables;
   }

   public void setOfTables(List<SQLExpr> ofTables) {
      this.ofTables = ofTables;
   }

   public LockType getLockType() {
      return this.lockType;
   }

   public void setLockType(LockType lockType) {
      this.lockType = lockType;
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.lockStrength == null ? 0 : this.lockStrength.hashCode());
      result = 31 * result + (this.lockType == null ? 0 : this.lockType.hashCode());
      result = 31 * result + (this.ofTables == null ? 0 : this.ofTables.hashCode());
      return result;
   }

   public KingbaseForUpdateExpr clone() {
      KingbaseForUpdateExpr x = new KingbaseForUpdateExpr();
      x.lockStrength = this.lockStrength;
      x.lockType = this.lockType;
      if (this.ofTables != null) {
         for(SQLExpr ofTable : this.ofTables) {
            x.ofTables.add(ofTable.clone());
         }
      }

      return x;
   }

   public boolean equals(Object obj) {
      if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         KingbaseForUpdateExpr other = (KingbaseForUpdateExpr)obj;
         if (this.lockStrength != other.lockStrength) {
            return false;
         } else if (this.lockType != other.lockType) {
            return false;
         } else {
            if (this.ofTables == null) {
               if (other.lockType != null) {
                  return false;
               }
            } else if (!this.ofTables.equals(other.ofTables)) {
               return false;
            }

            return true;
         }
      }
   }

   public static enum LockStrength {
      UPDATE("UPDATE"),
      NO_KEY_UPDATE("NO KEY UPDATE"),
      SHARE("SHARE"),
      KEY_SHARE("KEY SHARE");

      public final String name;
      public final String name_lower;

      private LockStrength(String name) {
         this.name = name;
         this.name_lower = name.toLowerCase();
      }
   }

   public static enum LockType {
      NOWAIT("NOWAIT"),
      SKIP_LOCKED("SKIP LOCKED");

      public final String name;
      public final String name_lower;

      private LockType(String name) {
         this.name = name;
         this.name_lower = name.toLowerCase();
      }
   }
}
