package com.alibaba.druid.sql.dialect.oracle.ast.expr;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.dialect.oracle.ast.OracleSQLObjectImpl;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import java.util.Arrays;
import java.util.List;

public class OracleRangeExpr extends OracleSQLObjectImpl implements SQLExpr {
   private SQLExpr lowBound;
   private SQLExpr upBound;

   public OracleRangeExpr() {
   }

   public OracleRangeExpr(SQLExpr lowBound, SQLExpr upBound) {
      this.setLowBound(lowBound);
      this.setUpBound(upBound);
   }

   public void accept0(OracleASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.lowBound);
         this.acceptChild(visitor, this.upBound);
      }

      visitor.endVisit(this);
   }

   public List<SQLObject> getChildren() {
      return Arrays.asList(this.lowBound, this.upBound);
   }

   public SQLExpr getLowBound() {
      return this.lowBound;
   }

   public void setLowBound(SQLExpr lowBound) {
      if (lowBound != null) {
         lowBound.setParent(this);
      }

      this.lowBound = lowBound;
   }

   public SQLExpr getUpBound() {
      return this.upBound;
   }

   public void setUpBound(SQLExpr upBound) {
      if (upBound != null) {
         upBound.setParent(this);
      }

      this.upBound = upBound;
   }

   public OracleRangeExpr clone() {
      OracleRangeExpr x = new OracleRangeExpr();
      if (this.lowBound != null) {
         x.setLowBound(this.lowBound.clone());
      }

      if (this.upBound != null) {
         x.setUpBound(this.upBound.clone());
      }

      return x;
   }
}
