package com.alibaba.druid.sql.dialect.oracle.ast.stmt;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLCommentHint;
import com.alibaba.druid.sql.ast.SQLHint;
import com.alibaba.druid.sql.ast.statement.SQLErrorLoggingClause;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.OracleReturningClause;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class OracleInsertStatement extends SQLInsertStatement implements OracleStatement {
   private SQLSelect select;
   private OracleReturningClause returning;
   private SQLErrorLoggingClause errorLogging;
   private List<SQLHint> hints = new ArrayList();

   public OracleInsertStatement() {
      this.dbType = DbType.oracle;
   }

   public void cloneTo(OracleInsertStatement x) {
      if (x.getSelect() != null) {
         x.setSelect(this.select.clone());
      }

      super.cloneTo(x);
      if (this.returning != null) {
         x.setReturning(this.returning.clone());
      }

      if (this.errorLogging != null) {
         x.setErrorLogging(this.errorLogging.clone());
      }

      for(SQLHint hint : this.hints) {
         SQLHint h2 = hint.clone();
         h2.setParent(x);
         x.hints.add(h2);
      }

   }

   public List<SQLHint> getHints() {
      return this.hints;
   }

   public void setHints(List<SQLHint> hints) {
      this.hints = hints;
   }

   public OracleReturningClause getReturning() {
      return this.returning;
   }

   public void setReturning(OracleReturningClause returning) {
      this.returning = returning;
   }

   public SQLErrorLoggingClause getErrorLogging() {
      return this.errorLogging;
   }

   public void setErrorLogging(SQLErrorLoggingClause errorLogging) {
      this.errorLogging = errorLogging;
   }

   protected void accept0(SQLASTVisitor visitor) {
      this.accept0((OracleASTVisitor)visitor);
   }

   public void accept0(OracleASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.select);
         if (this.tableSource != null) {
            this.acceptChild(visitor, this.getTableSource());
         }

         this.acceptChild(visitor, this.getColumns());
         this.acceptChild(visitor, this.getValues());
         this.acceptChild(visitor, this.getQuery());
         this.acceptChild(visitor, this.returning);
         this.acceptChild(visitor, this.errorLogging);
      }

      visitor.endVisit(this);
   }

   public OracleInsertStatement clone() {
      OracleInsertStatement x = new OracleInsertStatement();
      this.cloneTo(x);
      return x;
   }

   public List<SQLCommentHint> getHeadHintsDirect() {
      return null;
   }

   public SQLSelect getSelect() {
      return this.select;
   }

   public void setSelect(SQLSelect select) {
      this.select = select;
   }
}
