package com.alibaba.druid.sql.dialect.postgresql.parser;

import com.alibaba.druid.sql.ast.SQLCommentHint;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLLimit;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLOver;
import com.alibaba.druid.sql.ast.SQLParameter;
import com.alibaba.druid.sql.ast.SQLWindow;
import com.alibaba.druid.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLListExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUnionOperator;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.ast.statement.SQLUnionQueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLValuesTableSource;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGColumnSimpleDefinitionExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.tablesource.PGExprTableSource;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.tablesource.PGMethodInvokeTableSource;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.tablesource.PGRowsFromTableSource;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.tablesource.PGSubqueryTableSource;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.tablesource.PGTableSource;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.tablesource.PGValuesTableSource;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGFunctionTableSource;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGSelectQueryBlock;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.SQLSelectListCache;
import com.alibaba.druid.sql.parser.SQLSelectParser;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;
import java.util.List;

public class PGSelectParser extends SQLSelectParser {
   public PGSelectParser(SQLExprParser exprParser) {
      super(exprParser);
   }

   public PGSelectParser(SQLExprParser exprParser, SQLSelectListCache selectListCache) {
      super(exprParser, selectListCache);
   }

   public PGSelectParser(String sql) {
      this((SQLExprParser)(new PGExprParser(sql)));
   }

   protected SQLExprParser createExprParser() {
      return new PGExprParser(this.lexer);
   }

   public SQLSelectQuery query(SQLObject parent, boolean acceptUnion) {
      if (this.lexer.token() == Token.VALUES) {
         return this.valuesQuery(acceptUnion);
      } else if (this.lexer.token() == Token.LPAREN) {
         this.lexer.nextToken();
         SQLSelectQuery select = this.query();
         if (select instanceof SQLSelectQueryBlock) {
            ((SQLSelectQueryBlock)select).setParenthesized(true);
         }

         this.accept(Token.RPAREN);
         return this.queryRest(select, acceptUnion);
      } else {
         PGSelectQueryBlock queryBlock = new PGSelectQueryBlock();
         if (this.lexer.hasComment() && this.lexer.isKeepComments()) {
            queryBlock.addBeforeComment(this.lexer.readAndResetComments());
         }

         if (this.lexer.token() == Token.SELECT) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.COMMENT) {
               this.lexer.nextToken();
            }

            if (this.lexer.token() == Token.DISTINCT) {
               queryBlock.setDistionOption(2);
               this.lexer.nextToken();
               if (this.lexer.token() == Token.ON) {
                  this.lexer.nextToken();

                  while(true) {
                     this.lexer.nextToken();
                     SQLExpr expr = this.exprParser.expr();
                     this.lexer.nextToken();
                     queryBlock.getDistinctOn().add(expr);
                     if (this.lexer.token() != Token.COMMA) {
                        break;
                     }

                     this.lexer.nextToken();
                  }
               }
            } else if (this.lexer.token() == Token.ALL) {
               queryBlock.setDistionOption(1);
               this.lexer.nextToken();
            }

            this.parseSelectList(queryBlock);
            if (this.lexer.token() == Token.INTO) {
               this.lexer.nextToken();
               if (this.lexer.token() == Token.TEMPORARY) {
                  this.lexer.nextToken();
                  queryBlock.setIntoOption(PGSelectQueryBlock.IntoOption.TEMPORARY);
               } else if (this.lexer.token() == Token.TEMP) {
                  this.lexer.nextToken();
                  queryBlock.setIntoOption(PGSelectQueryBlock.IntoOption.TEMP);
               } else if (this.lexer.token() == Token.UNLOGGED) {
                  this.lexer.nextToken();
                  queryBlock.setIntoOption(PGSelectQueryBlock.IntoOption.UNLOGGED);
               }

               if (this.lexer.token() == Token.TABLE) {
                  this.lexer.nextToken();
               }

               SQLExpr name = this.createExprParser().name();
               PGExprTableSource ts = new PGExprTableSource();
               ts.setExpr(name);
               queryBlock.setInto(ts);
            }
         }

         if (this.lexer.token() == Token.TABLE) {
            this.lexer.nextToken();
            queryBlock.putAttribute("$table-query", true);
         }

         this.parseFrom(queryBlock);
         this.parseWhere(queryBlock);
         this.parseGroupBy(queryBlock);
         if (this.lexer.token() == Token.WINDOW) {
            this.parseWindow(queryBlock);
         }

         queryBlock.setOrderBy(this.createExprParser().parseOrderBy());

         while(true) {
            SQLLimit limit;
            for(; this.lexer.token() == Token.LIMIT; queryBlock.setLimit(limit)) {
               limit = new SQLLimit();
               limit.setType(SQLLimit.Type.LIMIT);
               this.lexer.nextToken();
               if (this.lexer.token() == Token.ALL) {
                  limit.setRowCount(new SQLIdentifierExpr("ALL"));
                  this.lexer.nextToken();
               } else {
                  limit.setRowCount(this.expr());
                  if (this.lexer.token() == Token.OFFSET) {
                     this.lexer.nextToken();
                     limit.setOffset(this.expr());
                  }
               }
            }

            if (this.lexer.token() != Token.OFFSET) {
               if (this.lexer.token() == Token.FETCH) {
                  this.lexer.nextToken();
                  PGSelectQueryBlock.FetchClause fetch = new PGSelectQueryBlock.FetchClause();
                  if (this.lexer.token() == Token.FIRST) {
                     fetch.setOption(PGSelectQueryBlock.FetchClause.Option.FIRST);
                  } else {
                     if (this.lexer.token() != Token.NEXT) {
                        throw new ParserException("expect 'FIRST' or 'NEXT'. " + this.lexer.info());
                     }

                     fetch.setOption(PGSelectQueryBlock.FetchClause.Option.NEXT);
                  }

                  this.lexer.nextToken();
                  SQLExpr count = this.expr();
                  fetch.setCount(count);
                  if (this.lexer.token() != Token.ROW && this.lexer.token() != Token.ROWS) {
                     throw new ParserException("expect 'ROW' or 'ROWS'. " + this.lexer.info());
                  }

                  this.lexer.nextToken();
                  if (this.lexer.token() != Token.ONLY) {
                     throw new ParserException("expect 'ONLY'. " + this.lexer.info());
                  }

                  this.lexer.nextToken();
                  queryBlock.setFetch(fetch);
               }

               PGSelectQueryBlock.ForClause forClause;
               for(PGSelectQueryBlock.ForClauses forClauses = null; this.lexer.token() == Token.FOR; forClauses.addForClause(forClause)) {
                  if (forClauses == null) {
                     forClauses = new PGSelectQueryBlock.ForClauses();
                     queryBlock.setForClause(forClauses);
                  }

                  this.lexer.nextToken();
                  forClause = new PGSelectQueryBlock.ForClause();
                  if (this.lexer.token() == Token.UPDATE) {
                     forClause.setOption(PGSelectQueryBlock.ForClause.Option.UPDATE);
                     this.lexer.nextToken();
                  } else if (this.lexer.token() == Token.SHARE) {
                     forClause.setOption(PGSelectQueryBlock.ForClause.Option.SHARE);
                     this.lexer.nextToken();
                  } else if (this.lexer.identifierEquals("NO")) {
                     this.lexer.nextToken();
                     this.accept(Token.KEY);
                     this.accept(Token.UPDATE);
                     forClause.setOption(PGSelectQueryBlock.ForClause.Option.NO_KEY_UPDATE);
                  } else {
                     if (this.lexer.token() != Token.KEY) {
                        throw new ParserException("expect 'FIRST' or 'NEXT'. " + this.lexer.info());
                     }

                     this.lexer.nextToken();
                     this.accept(Token.SHARE);
                     forClause.setOption(PGSelectQueryBlock.ForClause.Option.KEY_SHARE);
                  }

                  if (this.lexer.token() == Token.OF) {
                     this.lexer.nextToken();

                     while(true) {
                        SQLExpr expr = this.exprParser.expr();
                        forClause.getOf().add(expr);
                        if (this.lexer.token() != Token.COMMA) {
                           break;
                        }

                        this.lexer.nextToken();
                     }
                  }

                  if (this.lexer.token() == Token.NOWAIT) {
                     this.lexer.nextToken();
                     forClause.setNoWait(true);
                  } else if (this.lexer.identifierEquals(FnvHash.Constants.SKIP)) {
                     this.lexer.nextToken();
                     this.acceptIdentifier("LOCKED");
                     forClause.setSkipLocked(true);
                  }
               }

               return this.queryRest(queryBlock, acceptUnion);
            }

            limit = queryBlock.getLimit();
            if (limit == null) {
               limit = new SQLLimit();
               queryBlock.setLimit(limit);
            }

            limit.setType(SQLLimit.Type.LIMIT_OFFSET);
            this.lexer.nextToken();
            SQLExpr offset = this.expr();
            limit.setOffset(offset);
            if (this.lexer.token() == Token.ROW || this.lexer.token() == Token.ROWS) {
               this.lexer.nextToken();
            }
         }
      }
   }

   public SQLTableSource parseTableSource() {
      if (this.lexer.token() == Token.LPAREN) {
         this.lexer.nextToken();
         SQLTableSource tableSource;
         if (this.lexer.token() != Token.SELECT && this.lexer.token() != Token.WITH && this.lexer.token() != Token.SEL) {
            if (this.lexer.token() == Token.VALUES) {
               tableSource = new PGValuesTableSource();
               PGValuesTableSource ts = (PGValuesTableSource)tableSource;
               this.lexer.nextToken();

               do {
                  if (this.lexer.token() == Token.COMMA) {
                     this.lexer.nextToken();
                  }

                  if (this.lexer.token() == Token.LPAREN) {
                     this.lexer.nextToken();
                  }

                  PGValuesTableSource.ValueRow row = new PGValuesTableSource.ValueRow();

                  do {
                     if (this.lexer.token() == Token.COMMA) {
                        this.lexer.nextToken();
                     }

                     SQLExpr expr = this.exprParser.expr();
                     row.getVals().add(expr);
                  } while(this.lexer.token() != Token.RPAREN);

                  this.accept(Token.RPAREN);
                  ts.getRows().add(row);
               } while(this.lexer.token() == Token.COMMA);

               this.accept(Token.RPAREN);
               tableSource.setAlias(this.lexer.stringVal());
               this.lexer.nextToken();
            } else if (this.lexer.token() == Token.LPAREN) {
               tableSource = this.parseTableSource();
               this.accept(Token.RPAREN);
            } else {
               tableSource = this.parseTableSource();
               this.accept(Token.RPAREN);
            }
         } else {
            SQLSelect select = this.select();
            this.accept(Token.RPAREN);
            if (select.getQuery() instanceof SQLSelectQueryBlock) {
               ((SQLSelectQueryBlock)select.getQuery()).setParenthesized(true);
            }

            SQLSelectQuery query = this.queryRest(select.getQuery(), true);
            if (query instanceof SQLUnionQuery) {
               tableSource = new SQLUnionQueryTableSource((SQLUnionQuery)query);
            } else {
               tableSource = new SQLSubqueryTableSource(select);
            }
         }

         if (this.lexer.token() == Token.AS) {
            this.lexer.nextToken();
            String alias = this.tableAlias(true);
            tableSource.setAlias(alias);
            if (tableSource instanceof SQLValuesTableSource && ((SQLValuesTableSource)tableSource).getColumns().size() == 0) {
               SQLValuesTableSource values = (SQLValuesTableSource)tableSource;
               this.accept(Token.LPAREN);
               this.exprParser.names(values.getColumns(), values);
               this.accept(Token.RPAREN);
            } else if (tableSource instanceof SQLSubqueryTableSource) {
               SQLSubqueryTableSource values = (SQLSubqueryTableSource)tableSource;
               if (this.lexer.token() == Token.LPAREN) {
                  this.lexer.nextToken();
                  this.exprParser.names(values.getColumns(), values);
                  this.accept(Token.RPAREN);
               }
            }
         }

         return this.parseTableSourceRest(tableSource);
      } else if (this.lexer.token() != Token.VALUES) {
         if (this.lexer.token() == Token.SELECT) {
            throw new ParserException("TODO " + this.lexer.info());
         } else {
            SQLExprTableSource tableReference = new SQLExprTableSource();
            this.parseTableSourceQueryTableExpr(tableReference);
            SQLTableSource tableSrc = this.parseTableSourceRest(tableReference);
            if (this.lexer.hasComment() && this.lexer.isKeepComments()) {
               tableSrc.addAfterComment(this.lexer.readAndResetComments());
            }

            return tableSrc;
         }
      } else {
         this.lexer.nextToken();
         SQLValuesTableSource tableSource = new SQLValuesTableSource();

         while(true) {
            this.accept(Token.LPAREN);
            SQLListExpr listExpr = new SQLListExpr();
            this.exprParser.exprList(listExpr.getItems(), listExpr);
            this.accept(Token.RPAREN);
            listExpr.setParent(tableSource);
            tableSource.getValues().add(listExpr);
            if (this.lexer.token() != Token.COMMA) {
               if (this.lexer.token() == Token.RPAREN) {
                  return tableSource;
               } else {
                  String alias = this.tableAlias();
                  if (alias != null) {
                     tableSource.setAlias(alias);
                  }

                  this.accept(Token.LPAREN);
                  this.exprParser.names(tableSource.getColumns(), tableSource);
                  this.accept(Token.RPAREN);
                  return tableSource;
               }
            }

            this.lexer.nextToken();
         }
      }
   }

   public SQLTableSource parseTableSourceRest(SQLTableSource tableSource) {
      Boolean only = (Boolean)tableSource.getAttribute("table-only");
      Boolean withOrdinality = (Boolean)tableSource.getAttribute("table-with-ordinality");
      Boolean rowFrom = (Boolean)tableSource.getAttribute("ts-rows-from");
      if (tableSource instanceof SQLExprTableSource && !(tableSource instanceof PGTableSource)) {
         SQLExprTableSource exprTableSource = (SQLExprTableSource)tableSource;
         SQLTableSource gts = this.parseExprTableSource(exprTableSource);
         if (gts instanceof SQLExprTableSource) {
            gts = this.parseMethodDataSource((SQLExprTableSource)gts);
         }

         return !(gts instanceof PGRowsFromTableSource) && !(gts instanceof PGMethodInvokeTableSource) ? super.parseTableSourceRest(gts) : gts;
      } else if (tableSource instanceof SQLSubqueryTableSource && !(tableSource instanceof PGTableSource)) {
         PGSubqueryTableSource ts = new PGSubqueryTableSource();
         SQLSubqueryTableSource subquery = (SQLSubqueryTableSource)tableSource;
         subquery.cloneTo(ts);
         if (only != null) {
            ts.setOnly(only);
         }

         return super.parseTableSourceRest(ts);
      } else {
         if (this.lexer.token() == Token.IDENTITY && tableSource instanceof SQLExprTableSource) {
            this.lexer.nextToken();
            String alias = null;
            if (this.lexer.token() == Token.IDENTIFIER) {
               alias = this.lexer.stringVal();
               this.lexer.nextToken();
            }

            if (this.lexer.token() == Token.LPAREN) {
               SQLExprTableSource exprTableSource = (SQLExprTableSource)tableSource;
               PGFunctionTableSource functionTableSource = new PGFunctionTableSource(exprTableSource.getExpr());
               if (alias != null) {
                  functionTableSource.setAlias(alias);
               }

               this.lexer.nextToken();
               this.parserParameters(functionTableSource.getParameters());
               this.accept(Token.RPAREN);
               return super.parseTableSourceRest(functionTableSource);
            }

            if (alias != null) {
               tableSource.setAlias(alias);
               return super.parseTableSourceRest(tableSource);
            }
         }

         if (!tableSource.getClass().equals(PGValuesTableSource.class)) {
            return super.parseTableSourceRest(tableSource);
         } else {
            if (this.lexer.token() == Token.LPAREN) {
               PGValuesTableSource ts = (PGValuesTableSource)tableSource;

               while(this.lexer.token() != Token.RPAREN) {
                  this.lexer.nextToken();
                  SQLExpr expr = this.exprParser.expr();
                  ts.addColumnAlias((SQLName)expr);
               }

               this.lexer.nextToken();
            }

            return tableSource;
         }
      }
   }

   private SQLTableSource parseExprTableSource(SQLExprTableSource tableSource) {
      if (tableSource instanceof PGTableSource) {
         return tableSource;
      } else if (!(tableSource instanceof SQLExprTableSource)) {
         return tableSource;
      } else {
         Boolean only = (Boolean)tableSource.getAttribute("table-only");
         SQLExpr expr = tableSource.getExpr();
         if (expr instanceof SQLMethodInvokeExpr) {
            return tableSource;
         } else {
            PGExprTableSource ts = new PGExprTableSource();
            tableSource.cloneTo(ts);
            if (only != null) {
               ts.setOnly(only);
            }

            if (this.lexer.token() == Token.AS) {
               this.lexer.nextToken();
            }

            String alias = null;
            if (!this.lexer.identifierEquals("NATURAL") && !this.lexer.identifierEquals("CROSS") && this.lexer.token() == Token.IDENTIFIER) {
               alias = this.lexer.stringVal();
               ts.setAlias(alias);
               this.lexer.nextToken();
            }

            this.parseColumns(ts);
            return this.parseTableSourceRest(ts);
         }
      }
   }

   private SQLTableSource parseMethodDataSource(SQLExprTableSource tableSource) {
      SQLExpr expr = tableSource.getExpr();
      if (!(expr instanceof SQLMethodInvokeExpr)) {
         return tableSource;
      } else {
         PGMethodInvokeTableSource ts = new PGMethodInvokeTableSource();
         SQLMethodInvokeExpr method = (SQLMethodInvokeExpr)expr;
         ts.setExpr(method.getMethodName());

         for(SQLExpr parameter : method.getParameters()) {
            SQLExpr p = parameter.clone();
            ts.getParameters().add(p);
            p.setParent(ts);
         }

         PGTableSource gts = null;
         PGRowsFromTableSource rts = null;
         Boolean rowFrom = (Boolean)tableSource.getAttribute("ts-rows-from");
         if (rowFrom != null && rowFrom) {
            rts = new PGRowsFromTableSource();
            rts.addTableSource(ts);
            gts = rts;
         } else {
            gts = ts;
         }

         if (rowFrom != null) {
            ts.setRowsFrom(rowFrom);

            do {
               if (this.lexer.token() == Token.AS) {
                  this.lexer.nextToken();
               }

               this.parseColumns(ts);
               if (this.lexer.token() == Token.COMMA) {
                  this.lexer.nextToken();
                  SQLTableSource nts = this.parseTableSource();
                  ts = (PGMethodInvokeTableSource)nts;
                  rts.addTableSource(ts);
               }
            } while(this.lexer.token() == Token.COMMA);

            this.accept(Token.RPAREN);
         }

         if (this.lexer.token() == Token.WITH) {
            this.lexer.nextToken();
            this.lexer.nextToken();
            ts.setWithOrdinality(true);
            if (rts != null) {
               ts.setWithOrdinality(true);
            }
         }

         if (this.lexer.token() == Token.AS) {
            this.lexer.nextToken();
         }

         String alias = null;
         if (this.lexer.token() == Token.IDENTIFIER) {
            alias = this.lexer.stringVal();
            gts.setAlias(alias);
            this.lexer.nextToken();
         }

         this.parseColumns(gts);
         return (SQLTableSource)(gts != null ? gts : ts);
      }
   }

   private void parseColumns(PGTableSource gts) {
      if (this.lexer.token() == Token.LPAREN) {
         this.lexer.nextToken();

         while(this.lexer.token() != Token.RPAREN) {
            SQLName name = this.exprParser.name();
            if (this.lexer.token() != Token.COMMA && this.lexer.token() != Token.RPAREN) {
               SQLExpr type = new SQLIdentifierExpr(this.lexer.stringVal());
               PGColumnSimpleDefinitionExpr def = new PGColumnSimpleDefinitionExpr();
               def.setName(name);
               def.setType(type);
               if (gts instanceof PGMethodInvokeTableSource) {
                  PGMethodInvokeTableSource mits = (PGMethodInvokeTableSource)gts;
                  mits.addColumnAlias(def);
               } else if (gts instanceof PGRowsFromTableSource) {
                  PGRowsFromTableSource mits = (PGRowsFromTableSource)gts;
                  mits.addColumnAlias(def);
               }

               this.lexer.nextToken();
            } else {
               gts.addColumnAlias(name);
            }

            if (this.lexer.token() == Token.COMMA) {
               this.lexer.nextToken();
            }
         }

         this.accept(Token.RPAREN);
      }

   }

   private void parserParameters(List<SQLParameter> parameters) {
      do {
         SQLParameter parameter = new SQLParameter();
         parameter.setName(this.exprParser.name());
         parameter.setDataType(this.exprParser.parseDataType());
         parameters.add(parameter);
         if (this.lexer.token() == Token.COMMA || this.lexer.token() == Token.SEMI) {
            this.lexer.nextToken();
         }
      } while(this.lexer.token() != Token.BEGIN && this.lexer.token() != Token.RPAREN);

   }

   public SQLSelectQuery queryRest(SQLSelectQuery selectQuery, boolean acceptUnion) {
      if (!(selectQuery instanceof PGSelectQueryBlock)) {
         new PGSelectQueryBlock();
      }

      if (!acceptUnion) {
         return selectQuery;
      } else if (this.lexer.token() != Token.UNION) {
         if (this.lexer.token() == Token.EXCEPT) {
            this.lexer.nextToken();
            SQLUnionQuery union = new SQLUnionQuery();
            union.setLeft(selectQuery);
            if (this.lexer.token() == Token.ALL) {
               this.lexer.nextToken();
               union.setOperator(SQLUnionOperator.EXCEPT_ALL);
            } else if (this.lexer.token() == Token.DISTINCT) {
               this.lexer.nextToken();
               union.setOperator(SQLUnionOperator.EXCEPT_DISTINCT);
            } else {
               union.setOperator(SQLUnionOperator.EXCEPT);
            }

            boolean paren = this.lexer.token() == Token.LPAREN;
            SQLSelectQuery right = this.query(union, false);
            union.setRight(right);
            if (!paren) {
               if (right instanceof SQLSelectQueryBlock) {
                  SQLSelectQueryBlock rightQuery = (SQLSelectQueryBlock)right;
                  SQLOrderBy orderBy = rightQuery.getOrderBy();
                  if (orderBy != null) {
                     union.setOrderBy(orderBy);
                     rightQuery.setOrderBy((SQLOrderBy)null);
                  }

                  SQLLimit limit = rightQuery.getLimit();
                  if (limit != null) {
                     union.setLimit(limit);
                     rightQuery.setLimit((SQLLimit)null);
                  }
               } else if (right instanceof SQLUnionQuery) {
                  SQLUnionQuery rightUnion = (SQLUnionQuery)right;
                  SQLOrderBy orderBy = rightUnion.getOrderBy();
                  if (orderBy != null) {
                     union.setOrderBy(orderBy);
                     rightUnion.setOrderBy((SQLOrderBy)null);
                  }

                  SQLLimit limit = rightUnion.getLimit();
                  if (limit != null) {
                     union.setLimit(limit);
                     rightUnion.setLimit((SQLLimit)null);
                  }
               }
            }

            return this.queryRest(union, true);
         } else if (this.lexer.token() == Token.INTERSECT) {
            this.lexer.nextToken();
            SQLUnionQuery union = new SQLUnionQuery();
            union.setLeft(selectQuery);
            if (this.lexer.token() == Token.DISTINCT) {
               this.lexer.nextToken();
               union.setOperator(SQLUnionOperator.INTERSECT_DISTINCT);
            } else if (this.lexer.token() == Token.ALL) {
               this.lexer.nextToken();
               union.setOperator(SQLUnionOperator.INTERSECT_ALL);
            } else {
               union.setOperator(SQLUnionOperator.INTERSECT);
            }

            boolean paren = this.lexer.token() == Token.LPAREN;
            SQLSelectQuery right = this.query(union, false);
            union.setRight(right);
            if (!paren) {
               if (right instanceof SQLSelectQueryBlock) {
                  SQLSelectQueryBlock rightQuery = (SQLSelectQueryBlock)right;
                  SQLOrderBy orderBy = rightQuery.getOrderBy();
                  if (orderBy != null) {
                     union.setOrderBy(orderBy);
                     rightQuery.setOrderBy((SQLOrderBy)null);
                  }

                  SQLLimit limit = rightQuery.getLimit();
                  if (limit != null) {
                     union.setLimit(limit);
                     rightQuery.setLimit((SQLLimit)null);
                  }
               } else if (right instanceof SQLUnionQuery) {
                  SQLUnionQuery rightUnion = (SQLUnionQuery)right;
                  SQLOrderBy orderBy = rightUnion.getOrderBy();
                  if (orderBy != null) {
                     union.setOrderBy(orderBy);
                     rightUnion.setOrderBy((SQLOrderBy)null);
                  }

                  SQLLimit limit = rightUnion.getLimit();
                  if (limit != null) {
                     union.setLimit(limit);
                     rightUnion.setLimit((SQLLimit)null);
                  }
               }
            }

            return this.queryRest(union, true);
         } else if (acceptUnion && this.lexer.token() == Token.MINUS) {
            this.lexer.nextToken();
            SQLUnionQuery union = new SQLUnionQuery();
            union.setLeft(selectQuery);
            if (this.lexer.token() == Token.ALL) {
               this.lexer.nextToken();
               union.setOperator(SQLUnionOperator.MINUS_ALL);
            } else if (this.lexer.token() == Token.DISTINCT) {
               this.lexer.nextToken();
               union.setOperator(SQLUnionOperator.MINUS_DISTINCT);
            } else {
               union.setOperator(SQLUnionOperator.MINUS);
            }

            SQLSelectQuery right = this.query(union, false);
            union.setRight(right);
            return this.queryRest(union, true);
         } else {
            return selectQuery;
         }
      } else {
         SQLUnionQuery union;
         do {
            this.lexer.nextToken();
            union = this.createSQLUnionQuery();
            if (union.getRelations().isEmpty()) {
               union.setLeft(selectQuery);
            }

            if (this.lexer.token() == Token.ALL) {
               union.setOperator(SQLUnionOperator.UNION_ALL);
               this.lexer.nextToken();
            } else if (this.lexer.token() == Token.DISTINCT) {
               union.setOperator(SQLUnionOperator.DISTINCT);
               this.lexer.nextToken();
            }

            boolean paren = this.lexer.token() == Token.LPAREN;
            SQLSelectQuery right = this.query(paren ? null : union, false);
            union.setRight(right);

            while(this.lexer.isEnabled(SQLParserFeature.EnableMultiUnion) && this.lexer.token() == Token.UNION) {
               Lexer.SavePoint mark = this.lexer.mark();
               this.lexer.nextToken();
               if (this.lexer.token() == Token.ALL) {
                  if (union.getOperator() != SQLUnionOperator.UNION_ALL) {
                     this.lexer.reset(mark);
                     break;
                  }

                  this.lexer.nextToken();
               } else if (this.lexer.token() == Token.DISTINCT) {
                  if (union.getOperator() != SQLUnionOperator.DISTINCT) {
                     this.lexer.reset(mark);
                     break;
                  }

                  this.lexer.nextToken();
               } else if (union.getOperator() != SQLUnionOperator.UNION) {
                  this.lexer.reset(mark);
                  break;
               }

               paren = this.lexer.token() == Token.LPAREN;
               SQLSelectQuery r = this.query(paren ? null : union, false);
               union.addRelation(r);
               right = r;
            }

            if (!paren) {
               if (right instanceof SQLSelectQueryBlock) {
                  SQLSelectQueryBlock rightQuery = (SQLSelectQueryBlock)right;
                  SQLOrderBy orderBy = rightQuery.getOrderBy();
                  if (orderBy != null) {
                     union.setOrderBy(orderBy);
                     rightQuery.setOrderBy((SQLOrderBy)null);
                  }

                  SQLLimit limit = rightQuery.getLimit();
                  if (limit != null) {
                     union.setLimit(limit);
                     rightQuery.setLimit((SQLLimit)null);
                  }
               } else if (right instanceof SQLUnionQuery) {
                  SQLUnionQuery rightUnion = (SQLUnionQuery)right;
                  SQLOrderBy orderBy = rightUnion.getOrderBy();
                  if (orderBy != null) {
                     union.setOrderBy(orderBy);
                     rightUnion.setOrderBy((SQLOrderBy)null);
                  }

                  SQLLimit limit = rightUnion.getLimit();
                  if (limit != null) {
                     union.setLimit(limit);
                     rightUnion.setLimit((SQLLimit)null);
                  }
               }
            }

            union = this.unionRest(union);
            selectQuery = union;
         } while(this.lexer.token() == Token.UNION);

         selectQuery = this.queryRest(union, true);
         return selectQuery;
      }
   }

   protected void parseWindow(SQLSelectQueryBlock queryBlock) {
      if (this.lexer.identifierEquals(FnvHash.Constants.WINDOW) || this.lexer.token() == Token.WINDOW) {
         this.lexer.nextToken();

         while(true) {
            SQLName name = this.exprParser.name();
            this.accept(Token.AS);
            SQLOver over = new SQLOver();
            this.exprParser.over(over);
            queryBlock.addWindow(new SQLWindow(name, over));
            if (this.lexer.token() != Token.COMMA) {
               return;
            }

            this.lexer.nextToken();
         }
      }
   }

   public void parseFrom(SQLSelectQueryBlock queryBlock) {
      if (this.lexer.token() != Token.EOF && this.lexer.token() != Token.SEMI && this.lexer.token() != Token.ORDER && this.lexer.token() != Token.RPAREN && this.lexer.token() != Token.UNION) {
         Boolean tableQuery = (Boolean)queryBlock.getAttribute("$table-query");
         if (this.lexer.token() != Token.FROM && tableQuery != null && tableQuery && tableQuery != null && tableQuery) {
            SQLSelectItem item = new SQLSelectItem();
            SQLAllColumnExpr expr = new SQLAllColumnExpr();
            item.setExpr(expr);
            queryBlock.getSelectList().add(item);
         }

         if (this.lexer.token() != Token.FROM) {
            if (this.lexer.token() == Token.ONLY) {
               this.lexer.nextToken();
            }

            SQLTableSource from = this.parseTableSource();
            if (from instanceof PGExprTableSource) {
               PGExprTableSource gpFrom = (PGExprTableSource)from;
               if (gpFrom.getExpr() == null) {
                  return;
               }
            }

            queryBlock.setFrom(from);
         } else if (this.lexer.token() == Token.FROM) {
            this.lexer.nextToken();
            queryBlock.setFrom(this.parseTableSource());
         }
      }
   }

   protected void parseTableSourceQueryTableExpr(SQLExprTableSource tableReference) {
      if (this.lexer.token() == Token.ONLY) {
         tableReference.putAttribute("table-only", true);
         this.lexer.nextToken();
      }

      if (this.lexer.token() == Token.ROWS) {
         this.lexer.nextToken();
         tableReference.putAttribute("ts-rows-from", true);
         this.accept(Token.FROM);
         this.accept(Token.LPAREN);
      }

      if (this.lexer.token() != Token.LITERAL_ALIAS && !this.lexer.identifierEquals(FnvHash.Constants.IDENTIFIED) && this.lexer.token() != Token.LITERAL_CHARS) {
         if (this.lexer.token() == Token.HINT) {
            SQLCommentHint hint = this.exprParser.parseHint();
            tableReference.setHint(hint);
         }

         SQLExpr expr = null;
         if (this.lexer.token() == Token.IDENTIFIER) {
            this.lexer.mark();
            SQLName name = new SQLIdentifierExpr(this.lexer.stringVal());
            this.lexer.nextToken();
            if (this.lexer.token() != Token.LPAREN) {
               if (this.lexer.token() == Token.STAR) {
                  this.lexer.nextToken();
                  expr = name;
               } else {
                  this.lexer.reset();
                  if (this.lexer.token() != Token.SET) {
                     expr = this.expr();
                     if (this.lexer.token() == Token.STAR) {
                        this.lexer.nextToken();
                     }
                  } else {
                     expr = name;
                  }
               }
            } else {
               this.lexer.reset();
               if (this.lexer.token() != Token.SET) {
                  expr = this.expr();
               } else {
                  expr = name;
               }
            }
         }

         if (expr instanceof SQLBinaryOpExpr) {
            throw new ParserException("Invalid from clause : " + expr.toString().replace("\n", " "));
         } else {
            if (this.lexer.token() == Token.MONKEYS_AT) {
               this.lexer.nextToken();
               SQLExpr linkExpr = this.expr().clone();
               linkExpr.setParent(tableReference);
            }

            tableReference.setExpr(expr);
         }
      } else {
         tableReference.setExpr((SQLExpr)this.exprParser.name());
      }
   }
}
