package com.alibaba.druid.sql.dialect.spark.ast.expr;

import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.dialect.spark.visitor.SparkVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.List;

public class SparkSQLSubqueryTableSource extends SQLSubqueryTableSource implements SparkSelectTableSource {
   protected SparkSelectPivotBase pivot;

   public SparkSQLSubqueryTableSource() {
   }

   public SparkSQLSubqueryTableSource(String alias) {
      super(alias);
   }

   public SparkSQLSubqueryTableSource(SQLSelect select, String alias) {
      super(alias);
      this.setSelect(select);
   }

   public SparkSQLSubqueryTableSource(SQLSelect select) {
      this.setSelect(select);
   }

   public SparkSQLSubqueryTableSource(SQLSelectQuery query) {
      this(new SQLSelect(query));
   }

   public SparkSQLSubqueryTableSource(SQLSelectQuery query, String alias) {
      this(new SQLSelect(query), alias);
   }

   public SQLSelect getSelect() {
      return this.select;
   }

   public void setSelect(SQLSelect x) {
      if (x != null) {
         x.setParent(this);
      }

      this.select = x;
   }

   public void cloneTo(SparkSQLSubqueryTableSource x) {
      x.alias = this.alias;
      if (this.select != null) {
         x.select = this.select.clone();
         x.select.setParent(x);
      }

      for(SQLName column : this.columns) {
         SQLName c2 = column.clone();
         c2.setParent(x);
         x.columns.add(c2);
      }

      if (this.pivot != null) {
         x.pivot = this.pivot.clone();
      }

   }

   public SparkSQLSubqueryTableSource clone() {
      SparkSQLSubqueryTableSource x = new SparkSQLSubqueryTableSource();
      this.cloneTo(x);
      return x;
   }

   public SQLTableSource findTableSourceWithColumn(String columnName) {
      if (this.select == null) {
         return null;
      } else {
         SQLSelectQueryBlock queryBlock = this.select.getFirstQueryBlock();
         if (queryBlock == null) {
            return null;
         } else {
            return queryBlock.findSelectItem(columnName) != null ? this : null;
         }
      }
   }

   public SQLTableSource findTableSourceWithColumn(long columnNameHash, String columnName, int option) {
      if (this.select == null) {
         return null;
      } else {
         SQLSelectQueryBlock queryBlock = this.select.getFirstQueryBlock();
         if (queryBlock == null) {
            return null;
         } else {
            return queryBlock.findSelectItem(columnNameHash) != null ? this : null;
         }
      }
   }

   public boolean equals(Object o) {
      if (this == o) {
         return true;
      } else if (o != null && this.getClass() == o.getClass()) {
         SparkSQLSubqueryTableSource that = (SparkSQLSubqueryTableSource)o;
         if (this.pivot == null && that.pivot != null) {
            return false;
         } else if (this.pivot != null && that.pivot == null) {
            return false;
         } else {
            boolean eq = this.select != null ? this.select.equals(that.select) : that.select == null;
            if (this.pivot != null) {
               eq = eq && this.pivot.equals(that.pivot);
            }

            return eq;
         }
      } else {
         return false;
      }
   }

   public int hashCode() {
      int hash = this.select != null ? this.select.hashCode() : 0;
      hash += this.pivot != null ? this.pivot.hashCode() : 0;
      return hash;
   }

   public List<SQLName> getColumns() {
      return this.columns;
   }

   public void addColumn(SQLName column) {
      column.setParent(this);
      this.columns.add(column);
   }

   public SQLColumnDefinition findColumn(long columnNameHash) {
      SQLSelectQueryBlock queryBlock = this.select.getFirstQueryBlock();
      if (queryBlock != null) {
         return queryBlock.findColumn(columnNameHash);
      } else if (this.select.getQuery() instanceof SQLUnionQuery && ((SQLUnionQuery)this.select.getQuery()).getFirstQueryBlock() instanceof SQLSelectQueryBlock) {
         SQLSelectQueryBlock left = ((SQLUnionQuery)this.select.getQuery()).getFirstQueryBlock();
         return left.findColumn(columnNameHash);
      } else {
         return null;
      }
   }

   public SparkSelectPivotBase getPivot() {
      return this.pivot;
   }

   public void setPivot(SparkSelectPivotBase pivot) {
      this.pivot = pivot;
   }

   protected void accept0(SQLASTVisitor visitor) {
      this.accept0((SparkVisitor)visitor);
   }

   public void accept0(SparkVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.select);
         this.acceptChild(visitor, this.pivot);
      }

      visitor.endVisit(this);
   }
}
