package com.alibaba.druid.sql.dialect.spark.ast.expr;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.dialect.spark.ast.SparkSqlExprImpl;
import com.alibaba.druid.sql.dialect.spark.visitor.SparkVisitor;
import java.util.ArrayList;
import java.util.List;
import util.sqlparse.visitor.common.Objects;

public class SparkSampleExpr extends SparkSqlExprImpl {
   private SQLExpr percent;
   private SQLExpr rows;
   private SQLExpr bucket;
   private SQLExpr bucketOutOf;

   public SQLExpr getPercent() {
      return this.percent;
   }

   public void setPercent(SQLExpr percent) {
      this.percent = percent;
   }

   public SQLExpr getRows() {
      return this.rows;
   }

   public void setRows(SQLExpr rows) {
      this.rows = rows;
   }

   public SQLExpr getBucket() {
      return this.bucket;
   }

   public void setBucket(SQLExpr bucket) {
      this.bucket = bucket;
   }

   public SQLExpr getBucketOutOf() {
      return this.bucketOutOf;
   }

   public void setBucketOutOf(SQLExpr bucketOutOf) {
      this.bucketOutOf = bucketOutOf;
   }

   public List<SQLObject> getChildren() {
      List<SQLObject> list = new ArrayList();
      if (this.percent != null) {
         list.add(this.percent);
      }

      if (this.rows != null) {
         list.add(this.rows);
      }

      if (this.bucket != null) {
         list.add(this.bucket);
      }

      if (this.bucketOutOf != null) {
         list.add(this.bucketOutOf);
      }

      return list;
   }

   public void accept0(SparkVisitor v) {
      if (v.visit(this)) {
         this.acceptChild(v, this.percent);
         this.acceptChild(v, this.rows);
         this.acceptChild(v, this.bucket);
         this.acceptChild(v, this.bucketOutOf);
      }

      v.endVisit(this);
   }

   public SparkSampleExpr clone() {
      SparkSampleExpr expr = new SparkSampleExpr();
      if (this.percent != null) {
         expr.percent = this.percent.clone();
      }

      if (this.rows != null) {
         expr.rows = this.rows.clone();
      }

      if (this.bucket != null) {
         expr.bucket = this.bucket.clone();
      }

      if (this.bucketOutOf != null) {
         expr.bucketOutOf = this.bucketOutOf.clone();
      }

      return expr;
   }

   public boolean equals(Object o) {
      if (this == o) {
         return true;
      } else if (o != null && this.getClass() == o.getClass()) {
         SparkSampleExpr that = (SparkSampleExpr)o;
         return Objects.equals(this.percent, that.percent) && Objects.equals(this.rows, that.rows) && Objects.equals(this.bucket, that.bucket) && Objects.equals(this.bucketOutOf, that.bucketOutOf);
      } else {
         return false;
      }
   }

   public int hashCode() {
      return Objects.hash(this.percent, this.rows, this.bucket, this.bucketOutOf);
   }
}
