package com.alibaba.druid.sql.dialect.spark.ast.statement;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.dialect.spark.ast.expr.SparkDefProperty;
import com.alibaba.druid.sql.dialect.spark.visitor.SparkVisitor;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.List;

public class SparkCreateDatabaseStatement extends SparkStatementImpl {
   private SQLExpr type;
   private boolean exists;
   private SQLExpr name;
   private SQLExpr comment;
   private SQLExpr location;
   private List<SparkDefProperty> props = new ArrayList();

   public SQLExpr getName() {
      return this.name;
   }

   public void setName(SQLExpr name) {
      this.name = name;
   }

   public SQLExpr getType() {
      return this.type;
   }

   public void setType(SQLExpr type) {
      this.type = type;
   }

   public boolean isExists() {
      return this.exists;
   }

   public void setExists(boolean exists) {
      this.exists = exists;
   }

   public SQLExpr getComment() {
      return this.comment;
   }

   public void setComment(SQLExpr comment) {
      this.comment = comment;
   }

   public SQLExpr getLocation() {
      return this.location;
   }

   public void setLocation(SQLExpr location) {
      this.location = location;
   }

   public List<SparkDefProperty> getProps() {
      return this.props;
   }

   public void setProps(List<SparkDefProperty> props) {
      this.props = props;
   }

   public List<SQLObject> getChildren() {
      List<SQLObject> children = new ArrayList();
      if (this.type != null) {
         children.add(this.type);
      }

      if (this.name != null) {
         children.add(this.name);
      }

      if (this.comment != null) {
         children.add(this.comment);
      }

      if (this.location != null) {
         children.add(this.location);
      }

      if (this.props != null) {
         children.addAll(this.props);
      }

      return children;
   }

   public void accept0(SparkVisitor v) {
      if (v.visit(this)) {
         this.acceptChild(v, this.type);
         this.acceptChild(v, this.name);
         this.acceptChild(v, this.comment);
         this.acceptChild(v, this.location);
         this.acceptChild(v, this.props);
      }

      v.endVisit(this);
   }

   public SparkCreateDatabaseStatement clone() {
      SparkCreateDatabaseStatement stmt = new SparkCreateDatabaseStatement();
      stmt.type = this.type.clone();
      stmt.name = this.name.clone();
      stmt.comment = this.comment == null ? null : this.comment.clone();
      stmt.location = this.location == null ? null : this.location.clone();

      for(SparkDefProperty prop : this.props) {
         stmt.props.add(prop.clone());
      }

      return stmt;
   }

   public boolean equals(Object o) {
      if (this == o) {
         return true;
      } else if (!this.objectNullEquals(this, o)) {
         return false;
      } else {
         SparkCreateDatabaseStatement that = (SparkCreateDatabaseStatement)o;
         if (this.exists != that.exists) {
            return false;
         } else if (!this.objectEquals(this.type, that.type)) {
            return false;
         } else if (!this.objectEquals(this.name, that.name)) {
            return false;
         } else if (!this.objectEquals(this.comment, that.comment)) {
            return false;
         } else if (!this.objectEquals(this.location, that.location)) {
            return false;
         } else if (this.props.size() != that.props.size()) {
            return false;
         } else {
            for(int i = 0; i < this.props.size(); ++i) {
               if (!this.objectEquals(this.props.get(i), that.props.get(i))) {
                  return false;
               }
            }

            return true;
         }
      }
   }

   public int hashCode() {
      int hash = this.exists ? 1 : 0;
      hash = 31 * hash + (this.type == null ? 0 : this.type.hashCode());
      hash = 31 * hash + (this.name == null ? 0 : this.name.hashCode());
      hash = 31 * hash + (this.comment == null ? 0 : this.comment.hashCode());
      hash = 31 * hash + (this.location == null ? 0 : this.location.hashCode());
      hash = 31 * hash + Objects.hashCode(new Object[]{this.props});
      return hash;
   }
}
