package com.alibaba.druid.sql.dialect.sqlserver.ast;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.dialect.sqlserver.visitor.SQLServerASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class SQLServerSelectQueryBlock extends SQLSelectQueryBlock {
   protected SQLExpr on;
   private SQLServerTop top;

   public SQLServerSelectQueryBlock() {
      this.dbType = DbType.sqlserver;
   }

   public SQLServerTop getTop() {
      return this.top;
   }

   public void setTop(SQLServerTop top) {
      if (top != null) {
         top.setParent(this);
      }

      this.top = top;
   }

   public void setTop(int rowCount) {
      this.setTop(new SQLServerTop(new SQLIntegerExpr(rowCount)));
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor instanceof SQLServerASTVisitor) {
         this.accept0((SQLServerASTVisitor)visitor);
      } else {
         super.accept0(visitor);
      }

   }

   protected void accept0(SQLServerASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.top);
         this.acceptChild(visitor, this.selectList);
         this.acceptChild(visitor, this.from);
         this.acceptChild(visitor, this.where);
         this.acceptChild(visitor, this.groupBy);
      }

      visitor.endVisit(this);
   }

   public void limit(int rowCount, int offset) {
      if (offset <= 0) {
         this.setTop(rowCount);
      } else {
         throw new UnsupportedOperationException("not support offset");
      }
   }

   public SQLExpr getOn() {
      return this.on;
   }

   public void setOn(SQLExpr on) {
      if (on != null) {
         on.setParent(this);
      }

      this.on = on;
   }
}
