package com.alibaba.druid.support.logging;

import java.util.logging.Level;
import java.util.logging.Logger;

public class Jdk14LoggingImpl implements Log {
   private Logger log;
   private int errorCount;
   private int warnCount;
   private int infoCount;
   private int debugCount;
   private String loggerName;

   public Jdk14LoggingImpl(String loggerName) {
      this.loggerName = loggerName;
      this.log = Logger.getLogger(loggerName);
   }

   public boolean isDebugEnabled() {
      return this.log.isLoggable(Level.FINE);
   }

   public void error(String s, Throwable e) {
      this.log.logp(Level.SEVERE, this.loggerName, Thread.currentThread().getStackTrace()[1].getMethodName(), s, e);
      ++this.errorCount;
   }

   public void error(String s) {
      this.log.logp(Level.SEVERE, this.loggerName, Thread.currentThread().getStackTrace()[1].getMethodName(), s);
      ++this.errorCount;
   }

   public void debug(String s) {
      ++this.debugCount;
      this.log.logp(Level.FINE, this.loggerName, Thread.currentThread().getStackTrace()[1].getMethodName(), s);
   }

   public void debug(String s, Throwable e) {
      ++this.debugCount;
      this.log.logp(Level.FINE, this.loggerName, Thread.currentThread().getStackTrace()[1].getMethodName(), s, e);
   }

   public void warn(String s) {
      this.log.logp(Level.WARNING, this.loggerName, Thread.currentThread().getStackTrace()[1].getMethodName(), s);
      ++this.warnCount;
   }

   public void warn(String s, Throwable e) {
      this.log.logp(Level.WARNING, this.loggerName, Thread.currentThread().getStackTrace()[1].getMethodName(), s, e);
      ++this.warnCount;
   }

   public int getWarnCount() {
      return this.warnCount;
   }

   public int getErrorCount() {
      return this.errorCount;
   }

   public void resetStat() {
      this.errorCount = 0;
      this.warnCount = 0;
      this.infoCount = 0;
      this.debugCount = 0;
   }

   public boolean isInfoEnabled() {
      return this.log.isLoggable(Level.INFO);
   }

   public void info(String msg) {
      this.log.logp(Level.INFO, this.loggerName, Thread.currentThread().getStackTrace()[1].getMethodName(), msg);
      ++this.infoCount;
   }

   public int getInfoCount() {
      return this.infoCount;
   }

   public boolean isWarnEnabled() {
      return this.log.isLoggable(Level.WARNING);
   }

   public int getDebugCount() {
      return this.debugCount;
   }

   public boolean isErrorEnabled() {
      return this.log.isLoggable(Level.SEVERE);
   }
}
