package com.alibaba.druid.util.jdbc;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class LocalResultSet extends ResultSetBase {
   private int rowIndex = -1;
   private List<Object[]> rows = new ArrayList();

   public LocalResultSet(Statement statement) {
      super(statement);
   }

   public List<Object[]> getRows() {
      return this.rows;
   }

   public synchronized boolean next() throws SQLException {
      if (this.closed) {
         throw new SQLException();
      } else if (this.rowIndex < this.rows.size() - 1) {
         ++this.rowIndex;
         return true;
      } else {
         return false;
      }
   }

   public Object getObjectInternal(int columnIndex) {
      Object[] row = this.rows.get(this.rowIndex);
      return row[columnIndex - 1];
   }

   public synchronized boolean previous() throws SQLException {
      if (this.closed) {
         throw new SQLException();
      } else if (this.rowIndex > 0) {
         --this.rowIndex;
         return true;
      } else {
         return false;
      }
   }

   public void updateObject(int columnIndex, Object x) throws SQLException {
      Object[] row = this.rows.get(this.rowIndex);
      row[columnIndex - 1] = x;
   }
}
