package com.palacesun.engine.gateway.util;

import com.palacesun.engine.gateway.EncryptionGatewayManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.Date;
import java.util.Deque;

public class GatewaySocketLogUtil {
   public static SimpleDateFormat sdf;

   public static void writeLog(String content) {
      if (isSave()) {
         FileWriter fileWriter = null;
         BufferedWriter bufferedWriter = null;

         try {
            fileWriter = new FileWriter(System.getProperty("user.home") + "/gatewaySocketLog.txt", true);
            bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write(content(content));
         } catch (IOException e) {
            throw new RuntimeException(e);
         } finally {
            try {
               if (null != bufferedWriter) {
                  bufferedWriter.close();
               }
            } catch (IOException e) {
               throw new RuntimeException(e);
            }

            try {
               if (null != fileWriter) {
                  fileWriter.close();
               }
            } catch (IOException e) {
               throw new RuntimeException(e);
            }

         }
      }

   }

   public static void writeLogBatch(Deque<String> contents) {
      if (isSave()) {
         for(String content : contents) {
            FileWriter fileWriter = null;
            BufferedWriter bufferedWriter = null;

            try {
               fileWriter = new FileWriter(System.getProperty("user.home") + "/gatewaySocketLog.txt", true);
               bufferedWriter = new BufferedWriter(fileWriter);
               bufferedWriter.write(content);
            } catch (IOException e) {
               throw new RuntimeException(e);
            } finally {
               try {
                  if (null != bufferedWriter) {
                     bufferedWriter.close();
                  }
               } catch (IOException e) {
                  throw new RuntimeException(e);
               }

               try {
                  if (null != fileWriter) {
                     fileWriter.close();
                  }
               } catch (IOException e) {
                  throw new RuntimeException(e);
               }

            }
         }
      }

   }

   public static void writeKeyCache(String content) {
      FileWriter fileWriter = null;
      BufferedWriter bufferedWriter = null;

      try {
         String path = EncryptionGatewayManager.getParameterValue("encryption.location");
         if (path != null && !"".equals(path)) {
            String pathTemp = path.replace("encryption.properties", "");
            File file = new File(pathTemp);
            if (!file.exists()) {
               file.mkdirs();
            }

            fileWriter = new FileWriter(path, false);
            bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write(content);
            return;
         }
      } catch (IOException e) {
         throw new RuntimeException(e);
      } finally {
         try {
            if (null != bufferedWriter) {
               bufferedWriter.close();
            }
         } catch (IOException e) {
            throw new RuntimeException(e);
         }

         try {
            if (null != fileWriter) {
               fileWriter.close();
            }
         } catch (IOException e) {
            throw new RuntimeException(e);
         }

      }

   }

   public static void writeDigestKeyCache(String content) {
      FileWriter fileWriter = null;
      BufferedWriter bufferedWriter = null;

      try {
         String path = EncryptionGatewayManager.getParameterValue("digest.location");
         if (path != null && !"".equals(path)) {
            String pathTemp = path.replace("digest.properties", "");
            File file = new File(pathTemp);
            if (!file.exists()) {
               file.mkdirs();
            }

            fileWriter = new FileWriter(path, false);
            bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write(content);
            return;
         }
      } catch (IOException e) {
         throw new RuntimeException(e);
      } finally {
         try {
            if (null != bufferedWriter) {
               bufferedWriter.close();
            }
         } catch (IOException e) {
            throw new RuntimeException(e);
         }

         try {
            if (null != fileWriter) {
               fileWriter.close();
            }
         } catch (IOException e) {
            throw new RuntimeException(e);
         }

      }

   }

   public static String content(String content) {
      StringBuffer result = new StringBuffer("");
      result.append(sdf.format(new Date()) + " --> ");
      result.append(content);
      result.append("\r\n");
      return result.toString();
   }

   public static void writeBlankRows() {
      if (isSave()) {
         FileWriter fileWriter = null;
         BufferedWriter bufferedWriter = null;

         try {
            fileWriter = new FileWriter(System.getProperty("user.home") + "/gatewaySocketLog.txt", true);
            bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write("\r\n");
            bufferedWriter.write("\r\n");
            bufferedWriter.write("\r\n");
            bufferedWriter.write("\r\n");
         } catch (IOException e) {
            throw new RuntimeException(e);
         } finally {
            try {
               if (null != bufferedWriter) {
                  bufferedWriter.close();
               }
            } catch (IOException e) {
               throw new RuntimeException(e);
            }

            try {
               if (null != fileWriter) {
                  fileWriter.close();
               }
            } catch (IOException e) {
               throw new RuntimeException(e);
            }

         }
      }

   }

   public static boolean isSave() {
      try {
         String isSave = EncryptionGatewayManager.getParameterValue("isSave");
         return "true".equalsIgnoreCase(isSave);
      } catch (Exception var1) {
         return false;
      } catch (Throwable var2) {
         return false;
      }
   }

   static {
      if (isSave()) {
         InnerThread innerThread = new InnerThread();
         innerThread.start();
      }

      sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
   }

   public static class InnerThread extends Thread {
      public void run() {
         long timeInterval = 600000L;
         int linesToKeep = 500;

         while(true) {
            try {
               Thread.sleep(timeInterval);
               Deque<String> deque = new ArrayDeque();
               File file = new File(System.getProperty("user.home") + "/gatewaySocketLog.txt");
               if (file.exists()) {
                  FileInputStream fis = new FileInputStream(file);

                  String line;
                  for(BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fis)); (line = bufferedReader.readLine()) != null; deque.offerLast(line)) {
                     if (deque.size() == linesToKeep) {
                        deque.pollFirst();
                     }
                  }

                  boolean delete = false;

                  for(int i = 0; !delete && i <= 5; ++i) {
                     delete = file.delete();
                  }

                  GatewaySocketLogUtil.writeLogBatch(deque);
               }
            } catch (InterruptedException e) {
               throw new RuntimeException(e);
            } catch (FileNotFoundException e) {
               throw new RuntimeException(e);
            } catch (IOException e) {
               throw new RuntimeException(e);
            }
         }
      }
   }
}
