package com.palacesun.engine.spy;

import com.palacesun.masking.tools.ruleload.RuleLoadUtil;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEventListener;

public class MaskingPool implements PooledConnection, Serializable {
   static final long serialVersionUID = -203725628718322873L;
   private Hashtable eventListeners;
   private SQLException sqlException;
   protected boolean autoCommit;
   private ConnectionEventListener iccEventListener;
   public Properties cachedConnectionAttributes;
   public Properties unMatchedCachedConnAttr;
   public int closeOption;
   private long lastAccessedTime;
   protected String dataSourceInstanceNameKey;
   protected String dataSourceHostNameKey;
   protected String dataSourceDbUniqNameKey;
   protected boolean connectionMarkedDown;
   protected boolean needToAbort;
   boolean localTxnCommitOnClose;
   private Connection connection;

   public MaskingPool() {
      this((Connection)null);
   }

   public MaskingPool(String var1, String var2) throws SQLException {
      this.eventListeners = null;
      this.sqlException = null;
      this.autoCommit = true;
      this.iccEventListener = null;
      this.cachedConnectionAttributes = null;
      this.unMatchedCachedConnAttr = null;
      this.closeOption = 0;
      this.lastAccessedTime = 0L;
      this.dataSourceInstanceNameKey = null;
      this.dataSourceHostNameKey = null;
      this.dataSourceDbUniqNameKey = null;
      this.connectionMarkedDown = false;
      this.needToAbort = false;
      this.localTxnCommitOnClose = false;
      RuleLoadUtil.writeLog("@@插件@@---MaskingPool---var1:" + var1 + "--var2:" + var2);
      Connection connection = (new MaskingDriverPoolDataSource()).getConnection(var1, var2);
      if (connection != null) {
         this.initialize(connection);
      }

   }

   public MaskingPool(String var1, String var2, String var3) throws SQLException {
      this.eventListeners = null;
      this.sqlException = null;
      this.autoCommit = true;
      this.iccEventListener = null;
      this.cachedConnectionAttributes = null;
      this.unMatchedCachedConnAttr = null;
      this.closeOption = 0;
      this.lastAccessedTime = 0L;
      this.dataSourceInstanceNameKey = null;
      this.dataSourceHostNameKey = null;
      this.dataSourceDbUniqNameKey = null;
      this.connectionMarkedDown = false;
      this.needToAbort = false;
      this.localTxnCommitOnClose = false;
      Properties var4 = new Properties();
      var4.put("user", var2);
      var4.put("password", var3);
      Connection connection = (new MaskingDriverPoolDataSource()).getConnection(var1, var2, var3);
      if (connection != null) {
         this.initialize(connection);
      }

   }

   public MaskingPool(Connection var1) {
      this.eventListeners = null;
      this.sqlException = null;
      this.autoCommit = true;
      this.iccEventListener = null;
      this.cachedConnectionAttributes = null;
      this.unMatchedCachedConnAttr = null;
      this.closeOption = 0;
      this.lastAccessedTime = 0L;
      this.dataSourceInstanceNameKey = null;
      this.dataSourceHostNameKey = null;
      this.dataSourceDbUniqNameKey = null;
      this.connectionMarkedDown = false;
      this.needToAbort = false;
      this.localTxnCommitOnClose = false;
      this.initialize(var1);
   }

   public MaskingPool(Connection var1, boolean var2) {
      this(var1);
      this.autoCommit = var2;
   }

   private void initialize(Connection var1) {
      this.connection = var1;
      this.eventListeners = new Hashtable(10);
      this.lastAccessedTime = 0L;
   }

   public synchronized void addConnectionEventListener(ConnectionEventListener var1) {
      if (this.eventListeners == null) {
         this.sqlException = new SQLException("Listener Hashtable Null");
      } else {
         this.eventListeners.put(var1, var1);
      }

   }

   public synchronized void close() throws SQLException {
      this.connection = null;
      this.lastAccessedTime = 0L;
      this.iccEventListener = null;
   }

   public synchronized Connection getConnection() throws SQLException {
      return this.connection;
   }

   public Connection getLogicalHandle() throws SQLException {
      return this.connection;
   }

   public Connection getPhysicalHandle() throws SQLException {
      return this.connection;
   }

   public synchronized void setLastAccessedTime(long var1) throws SQLException {
      this.lastAccessedTime = var1;
   }

   public long getLastAccessedTime() throws SQLException {
      return this.lastAccessedTime;
   }

   public synchronized void removeConnectionEventListener(ConnectionEventListener var1) {
      if (this.eventListeners == null) {
         this.sqlException = new SQLException("Listener Hashtable Null");
      } else {
         this.eventListeners.remove(var1);
      }

   }

   public void addStatementEventListener(StatementEventListener statementEventListener) {
   }

   public void removeStatementEventListener(StatementEventListener statementEventListener) {
   }

   public synchronized void registerImplicitCacheConnectionEventListener(ConnectionEventListener var1) {
      if (this.iccEventListener != null) {
         this.sqlException = new SQLException("Implicit cache listeneralready registered");
      } else {
         this.iccEventListener = var1;
      }

   }

   public void logicalCloseForImplicitConnectionCache() {
      if (this.closeOption == 4096) {
         this.callImplicitCacheListener(102);
      } else {
         this.callImplicitCacheListener(101);
      }

   }

   public void logicalClose() {
      if (this.cachedConnectionAttributes != null) {
         this.logicalCloseForImplicitConnectionCache();
      } else {
         this.callListener(101);
      }

   }

   private void callListener(int var1) {
      if (this.eventListeners != null) {
         Enumeration var2 = this.eventListeners.keys();
         ConnectionEvent var3 = new ConnectionEvent(this, this.sqlException);

         while(var2.hasMoreElements()) {
            ConnectionEventListener var4 = (ConnectionEventListener)var2.nextElement();
            ConnectionEventListener var5 = (ConnectionEventListener)this.eventListeners.get(var4);
            if (var1 == 101) {
               var5.connectionClosed(var3);
            } else if (var1 == 102) {
               var5.connectionErrorOccurred(var3);
            }
         }
      }

   }

   private void callImplicitCacheListener(int var1) {
      if (this.iccEventListener != null) {
         ConnectionEvent var2 = new ConnectionEvent(this, this.sqlException);
         switch (var1) {
            case 101:
               this.iccEventListener.connectionClosed(var2);
               break;
            case 102:
               this.iccEventListener.connectionErrorOccurred(var2);
         }
      }

   }
}
