package com.palacesun.masking.appuser;

import com.palacesun.engine.gateway.EncryptionGatewayManager;

public abstract class AppUser {
   public static final String OPEN = "1";

   public abstract String getLoginUser();

   public abstract String getRequestUrl();

   public static String loginUser() {
      AppUser appUser;
      if ("1".equals(EncryptionGatewayManager.getParameterValue("maskingRule"))) {
         appUser = new SpringAppUser();
      } else {
         appUser = new DefUser();
      }

      return appUser.getLoginUser();
   }

   public static String requestUrl() {
      AppUser appUser;
      if ("1".equals(EncryptionGatewayManager.getParameterValue("maskingRule"))) {
         appUser = new SpringAppUser();
      } else {
         appUser = new DefUser();
      }

      return appUser.getRequestUrl();
   }
}
