package com.palacesun.masking.tools;

import com.palacesun.engine.gateway.EncryptionGatewayManager;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class AuthUtil {
   public static ArrayList<JSONArray> toArrayByEncryptionFileReader() {
      ArrayList<JSONArray> arrayList = new ArrayList();

      try {
         InputStream fr = AuthUtil.class.getResourceAsStream("/encryption.properties");
         BufferedReader bf = new BufferedReader(new InputStreamReader(fr));

         String str;
         while((str = bf.readLine()) != null) {
            JSONArray jsonObject = JSONObject.parseArray(str);
            arrayList.add(jsonObject);
         }

         bf.close();
         fr.close();
      } catch (IOException e) {
         e.printStackTrace();
      }

      return arrayList;
   }

   public static ArrayList<JSONArray> toArrayByEncryptionFileReaderFromRoot() {
      ArrayList<JSONArray> arrayList = new ArrayList();

      try {
         String path = EncryptionGatewayManager.getParameterValue("encryption.location");
         InputStream fr = new FileInputStream(path);
         BufferedReader bf = new BufferedReader(new InputStreamReader(fr));

         String str;
         while((str = bf.readLine()) != null) {
            JSONArray jsonObject = JSONObject.parseArray(str);
            arrayList.add(jsonObject);
         }

         bf.close();
         fr.close();
      } catch (IOException e) {
         e.printStackTrace();
      }

      return arrayList;
   }

   public static ArrayList<JSONArray> toArrayByMaskingFileReader() {
      ArrayList<JSONArray> arrayList = new ArrayList();

      try {
         InputStream fr = AuthUtil.class.getResourceAsStream("/masking.properties");
         BufferedReader bf = new BufferedReader(new InputStreamReader(fr));

         String str;
         while((str = bf.readLine()) != null) {
            JSONArray jsonObject = JSONObject.parseArray(str);
            arrayList.add(jsonObject);
         }

         bf.close();
         fr.close();
      } catch (IOException e) {
         e.printStackTrace();
      }

      return arrayList;
   }
}
