package util.cacheTest;

import bean.Column;
import bean.DataBase;
import bean.Schema;
import bean.Table;
import bean.View;
import java.io.IOException;
import java.util.List;
import util.JdbcUtil;

public class PostgresTest {
   public static void main(String[] args) throws IOException {
      testCache();
   }

   static void testCache() throws IOException {
      String content = "{\n      \"ip_port\": \"192.168.2.173:5432\",\n      \"url\": \"jdbc:postgresql://192.168.2.173:5432/postgres\",\n      \"username\": \"postgres\",\n      \"isIgnorecase\":\"0\",\n      \"password\": \"postgres\",\n      \"dbType\": \"postgresql\",\n      \"redisMode\": \"none\",\n      \"redisIp\": \"192.168.2.105\",\n      \"redisPort\": \"6379\",\n      \"redisUsername\": \"\",\n      \"redisPassword\": \"redis\",\n      \"redisDatabase\": \"0\",\n      \"excludeSchema\": [\"encryption_test2\",\"ghca_static_develop\",\"ghca_static_develop_test\",\"pg_catalog\",\"information_schema\",\"sysaudit\",\"sysmac\",\"sys\",\"sysmac\",\"sysmac\",\"sysmac\",\"ry\"]\n    }";
      JdbcUtil.initData(content);

      for(DataBase dataBase : JdbcUtil.dataBaseList) {
         System.out.println("*********************************************" + dataBase);
         List<Schema> schemaList = dataBase.getSchemaList();
         if (schemaList != null) {
            for(Schema schema : schemaList) {
               System.out.println("====================================" + schema.getName());
               List<Table> tableList = schema.getTableList();
               if (tableList != null) {
                  for(Table table : tableList) {
                     System.out.println("-------------------------------" + table.getName());

                     for(Column column : table.getColumnList()) {
                        System.out.println(String.format("\t\t %s\t%s\t%s\t%s\t%d", column.getColumnName(), column.getDataType(), column.getLength(), column.getRemark(), column.getPk()));
                     }
                  }
               }

               List<View> viewList = schema.getViewList();
               if (viewList != null) {
                  System.out.println("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%" + schema.getName());

                  for(View view : viewList) {
                     System.out.println(String.format("\t\t %s\t%s\t%s", view.getName(), view.getSchema(), view.getCreate_sql()));
                  }
               }
            }
         }
      }

   }
}
