package util.getdata;

import bean.Column;
import bean.DataBase;
import bean.Schema;
import bean.Table;
import bean.View;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import util.JdbcCacheUtil;

public class CacheGbase8S extends CacheData {
   private String urlTemplate = "jdbc:gbasedbt-sqli://{ip_port}/{schema}:GBASEDBTSERVER={servername}";

   public CacheGbase8S(DataBase dataBase, CountDownLatch cdl) {
      super(dataBase, cdl);
   }

   public void run() {
      System.out.println("gbase8s开始缓存");

      try {
         this.cacheWriteToRedis();
      } catch (Exception e) {
         e.printStackTrace();
      } finally {
         try {
            JdbcCacheUtil.closeConnection(this.connection);
            if (this.statement != null) {
               this.statement.close();
            }
         } catch (SQLException throwables) {
            throwables.printStackTrace();
         }

         this.getCdl().countDown();
         System.out.println("gbase8s结束缓存");
      }

   }

   public List<Schema> cacheToMemory() throws ClassNotFoundException, SQLException {
      Class.forName("com.gbasedbt.jdbc.Driver");
      this.connection = JdbcCacheUtil.getConnection(this.DataBase.getUrl(), this.DataBase.getUsername(), this.DataBase.getPassword());
      this.statement = this.connection.createStatement();
      List<Schema> schemaList = this.getSchema(this.statement);

      for(Schema schema : schemaList) {
         try {
            String schemaName = schema.getRealName();
            if (!this.DataBase.getExcludeSchema().contains(schemaName)) {
               List<Table> tableList = this.getTable(this.statement, schemaName);
               schema.setTableList(tableList);

               for(Table table : tableList) {
                  List<Column> columnList = this.getColumn(this.statement, schemaName, table.getRealName());
                  table.setColumnList(columnList);
               }

               List<View> viewList = this.getView(this.statement, schemaName);
               schema.setViewList(viewList);
               schema.setSynonymList(new ArrayList());
            }
         } catch (Exception var9) {
         }
      }

      return schemaList;
   }

   public List<Schema> getSchema(Statement statement) throws SQLException {
      List<Schema> schemas = new ArrayList();
      String sql = "select  distinct trim(name) as SCHEMA_NAME from sysmaster:sysdatabases";
      ResultSet resultSet = statement.executeQuery(sql);

      while(resultSet.next()) {
         Schema schema = new Schema(resultSet.getString("SCHEMA_NAME"));
         schema.setRealName(resultSet.getString("SCHEMA_NAME"));
         schemas.add(schema);
      }

      resultSet.close();
      return schemas;
   }

   public List<Table> getTable(Statement statement, String schema) throws SQLException {
      List<Table> tables = new ArrayList();
      String sql = "select t.tabname, c.comments from " + schema + ":systables t left join " + schema + ":syscomms c on t.tabid= c.tabid   where t.statlevel = 'A' and t.tabtype = 'T'";
      ResultSet resultSet = statement.executeQuery(sql);

      while(resultSet.next()) {
         Table table = new Table(resultSet.getString("tabname"), schema);
         table.setRealName(resultSet.getString("tabname"));
         tables.add(table);
      }

      resultSet.close();
      return tables;
   }

   public List<Column> getColumn(Statement statement, String schema, String table) throws SQLException {
      List<Column> columns = new ArrayList();
      String sql = "select sc.colname as COLUMN_NAME  from " + schema + ":syscolumns sc," + schema + ":systables t where sc.tabid = t.tabid and t.tabname = '" + table + "'";
      ResultSet resultSet = statement.executeQuery(sql);

      while(resultSet.next()) {
         columns.add(new Column(resultSet.getString("COLUMN_NAME"), schema, table, ""));
      }

      resultSet.close();
      return columns;
   }

   public List<View> getView(Statement statement, String schema) throws SQLException {
      List<View> views = new ArrayList();
      String sql = "select t.tabname,s.viewtext from " + schema + ":systables t  left join " + schema + ":sysviews s on t.tabid = s.tabid where t.tabtype = 'V' and t.statlevel = 'A'";
      ResultSet resultSet = statement.executeQuery(sql);

      while(resultSet.next()) {
         String table_name = resultSet.getString("tabname");
         String view_definition = resultSet.getString("viewtext").replaceAll("`", "");
         views.add(new View(table_name, view_definition));
      }

      resultSet.close();
      return views;
   }
}
