package util.sqlparse.visitor.mongo.test;

import bean.DataBase;
import bean.Schema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import util.JdbcUtil;
import util.SqlUtil;
import util.getdata.DatabaseCache;

public class DesensitizationTest {
   public static void main(String[] args) throws Exception {
      String sql = "{\"find\": \"student\", \"filter\": {}, \"sort\": {}, \"projection\": {\"_id\": 1, \"name\": 1.0}, \"lsid\": {\"id\": {\"$binary\": {\"base64\": \"ox8E0sqfQzW4ULnhWahC8A==\", \"subType\": \"04\"}}}, \"$db\": \"test\"}";
      mongoDesensitization();
   }

   static Map<String, Object> mongoParseTest(String sql) throws Exception {
      String content = "{\n      \"ip_port\": \"192.168.2.118:27017\",\n      \"url\": \"jdbc:mongodb://192.168.2.118:27017/test\",\n      \"username\": \"\",\n      \"isIgnorecase\":\"0\",\n      \"password\": \"\",\n      \"dbType\": \"mongodb\",\n      \"servername\": \"test\",\n      \"redisMode\": \"none\",\n      \"redisIp\": \"192.168.2.105\",\n      \"redisPort\": \"6379\",\n      \"redisUsername\": \"\",\n      \"redisPassword\": \"redis\",\n      \"redisDatabase\": \"0\",\n      \"excludeSchema\": [\"encryption_test2\",\"ghca_static_develop\",\"ghca_static_develop_test\",\"pg_catalog\",\"information_schema\",\"sysaudit\",\"sysmac\",\"sys\",\"sysmac\",\"sysmac\",\"sysmac\",\"ry\"]\n    }";
      JdbcUtil.initData(content);

      try {
         Thread.sleep(3000L);
      } catch (InterruptedException e) {
         e.printStackTrace();
      }

      DataBase dataBase = (DataBase)JdbcUtil.dataBaseList.get(0);
      DatabaseCache simpleCache = dataBase.simpleCache;
      Schema ry = simpleCache.getSchema("ry");
      System.out.println(ry == null ? "" : ry.getName());
      Map<String, String> params = new HashMap();
      params.put("dbType", "mongodb");
      params.put("schema", "test");
      params.put("url", "jdbc:mongodb://192.168.2.118:27017/test");
      params.put("replaceSchema", ".*");
      params.put("replaceNewTable", "people_bk");
      params.put("replaceTable", ".*");
      params.put("replaceColumn", ".*");
      params.put("expression", "concat(substr(${value},1,1),'**')");
      params.put("limit", "3");
      params.put("sql", sql);
      SqlUtil sqlUtil = new SqlUtil();
      Map<String, Object> stringObjectMap = sqlUtil.parseSqlStructureAnd(params);
      System.out.println(stringObjectMap);
      System.out.println(stringObjectMap.get("sh-sql"));
      return stringObjectMap;
   }

   static void mongoDesensitization() throws Exception {
      String sql = "";
      sql = "{\"find\": \"inventory\", \"filter\": {},\"maxTimeMS\": 2,  \"lsid\": {\"id\": {\"$binary\": {\"base64\": \"ox8E0sqfQzW4ULnhWahC8A==\", \"subType\": \"04\"}}}, \"$db\": \"test\"}";
      Map<String, Object> stringObjectMap = mongoParseTest(sql);
      Map<String, Object> params = new HashMap();
      params.put("sql", sql);
      params.put("dbType", "mongodb");
      params.put("schema", "test");
      params.put("url", "jdbc:mongodb://192.168.2.118:27017/test");
      params.put("replaceSchema", "test");
      params.put("replaceTable", "inventory");
      params.put("replaceColumn", ".*item.*");
      params.put("expression", "[{$project:{${value}:{$concat:[{$substrCP:[\"${value}\",0,1]},\"*\"]}}},{$project:{${value}:{$cond: {if: { $eq: [ \"*\", \"${value}\" ] },then: \"$$REMOVE\",else: \"${value}\"}}}}]");
      SqlUtil sqlUtil = new SqlUtil();
      String newsql = sqlUtil.desensitization(params);
      System.out.println(newsql);
      stringObjectMap = mongoParseTest(newsql);
   }

   static void mongoFieldReplace() throws Exception {
      String sql = "";
      sql = "{\"aggregate\": \"student\", \"pipeline\": [{\"$group\": {\"_id\": \"$by_user\", \"_title\": \"$title\", \"num_tutorial\": {\"$sum\": 1.0}}}], \"cursor\": {}, \"lsid\": {\"id\": {\"$binary\": {\"base64\": \"llOcfkriSp+7D52dvwx8FA==\", \"subType\": \"04\"}}}, \"$db\": \"test\"}";
      Map<String, Object> stringObjectMap = mongoParseTest(sql);
      Map<String, Object> params = new HashMap();
      params.put("sql", sql);
      params.put("dbType", "mongodb");
      params.put("schema", "test");
      params.put("url", "jdbc:mongodb://192.168.2.118:27017/test");
      String filedfullname = "test.inventory.item";
      String[] split = filedfullname.split("\\.");
      params.put("replaceSchema", split[0]);
      params.put("replaceTable", split[1]);
      params.put("replaceColumn", split[2]);
      params.put("expression", "{$concat:[{$substrCP:[${value},0,1]},\"**\"]}");
      SqlUtil sqlUtil = new SqlUtil();
      String newsql = sqlUtil.column_desensitization(params);
      System.out.println(newsql);
      stringObjectMap = mongoParseTest(newsql);
   }

   static void mongoTableReplace() throws Exception {
      String sqls = "";
      sqls = "{\"find\": \"student\", \"filter\": {}, \"sort\": {}, \"projection\": {\"_id\": 0.0, \"name\": 1.0}, \"lsid\": {\"id\": {\"$binary\": {\"base64\": \"ox8E0sqfQzW4ULnhWahC8A==\", \"subType\": \"04\"}}}, \"$db\": \"test\"}";
      sqls = "{\"aggregate\": \"student\", \"pipeline\": [{\"$group\": {\"_id\": \"$by_user\", \"_title\": \"$title\", \"num_tutorial\": {\"$sum\": 1.0}}}], \"cursor\": {}, \"lsid\": {\"id\": {\"$binary\": {\"base64\": \"llOcfkriSp+7D52dvwx8FA==\", \"subType\": \"04\"}}}, \"$db\": \"test\"}";
      Map<String, Object> stringObjectMap = mongoParseTest(sqls);
      String sql = (String)stringObjectMap.get("sql");
      Map<String, String> params = new HashMap();
      params.put("sql", sqls);
      params.put("dbType", "mongodb");
      params.put("schema", "test");
      params.put("url", "jdbc:mongodb://192.168.2.118:27017/test");
      params.put("replaceNewTable", "studentsss");
      params.put("replaceTable", "student");
      SqlUtil sqlUtil = new SqlUtil();
      String newSql = sqlUtil.table_desensitization(params);
      System.out.println(newSql);
      System.out.println("---------------------------");
   }

   static void mongoParseRowVisitTest8() throws Exception {
      String sqls = "";
      sqls = "{\"find\": \"inventory\", \"filter\": {\"item\": {$eq: \"pencil\"}}, \"sort\": {\"item\": 1}, \"projection\": {\"_id\": 1.0, \"item\": 1.0,\"item2\": 1.0}, \"lsid\": {\"id\": {\"$binary\": {\"base64\": \"ox8E0sqfQzW4ULnhWahC8A==\", \"subType\": \"04\"}}}, \"$db\": \"test\"}";
      Map<String, Object> stringObjectMap = mongoParseTest(sqls);
      String tableName = "inventory";
      String columnName = "item";
      String columnData = "pencil";
      Map<String, List<String>> modifyTable = new HashMap();
      List<String> valueList = new ArrayList();
      valueList.add(columnData);
      modifyTable.put(tableName, valueList);
      Map<String, String> tableKeyWord = new HashMap();
      tableKeyWord.put(tableName, columnName);
      String dbType = "mongodb";
      String sql = (String)stringObjectMap.get("sql");
      String operateType = "select";
      Map<String, Object> param = new HashMap();
      param.put("sql", sqls);
      param.put("url", "jdbc:mongodb://192.168.2.118:27017/test");
      param.put("schema", "test");
      param.put("modifyTable", modifyTable);
      param.put("tableKeyWord", tableKeyWord);
      param.put("operateType", operateType);
      param.put("dbType", dbType);
      param.put("limit", "2");
      SqlUtil util = new SqlUtil();
      String newSQL = util.rowVisitControl(param);
      System.out.println(newSQL);
      mongoParseTest(newSQL);
      System.out.println("---------------------------");
   }
}
