package util.sqlparse.visitor.spark.visitor;

import java.util.List;
import util.sqlparse.visitor.common.ScopeDialector;
import util.sqlparse.visitor.common.memo.FieldMemo;
import util.sqlparse.visitor.common.memo.TableMemo;
import util.sqlparse.visitor.common.scope.Scope;

public class SparkScopeDialector extends ScopeDialector {
   public SparkScopeDialector() {
   }

   public SparkScopeDialector(Scope scope) {
      super(scope);
   }

   public String wrap(String text) {
      if (text == null) {
         return null;
      } else if (text.contains("`")) {
         return text;
      } else {
         return this.scope.context.getDataBase() != null && this.scope.context.getDataBase().isCaseSensitive() ? text : text;
      }
   }

   public String wrapAlias(String text) {
      if (text == null) {
         return null;
      } else if (text.contains("`")) {
         return text;
      } else {
         return this.scope.context.getDataBase() != null && this.scope.context.getDataBase().isCaseSensitive() ? text : "`" + text + "`";
      }
   }

   public boolean expandAllColumns(TableMemo table, boolean isSub, List<FieldMemo> fields) {
      return true;
   }

   public ScopeDialector clone(Scope scope) {
      return new SparkScopeDialector(scope);
   }

   public boolean isEqual(String name1, String name2) {
      if (name1 == null && name2 != null) {
         return false;
      } else if (name1 != null && name2 == null) {
         return false;
      } else if (name1 == null && name2 == null) {
         return true;
      } else {
         name1 = name1.replace("`", "");
         name2 = name2.replace("`", "");
         return name1.equalsIgnoreCase(name2);
      }
   }
}
