package com.alibaba.druid.sql.ast;

import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class SQLArgument extends SQLObjectImpl {
   private SQLParameter.ParameterType type;
   private SQLExpr expr;

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.expr);
      }

      visitor.endVisit(this);
   }

   public SQLArgument clone() {
      SQLArgument x = new SQLArgument();
      x.type = this.type;
      if (this.expr != null) {
         x.setExpr(this.expr.clone());
      }

      return x;
   }

   public SQLParameter.ParameterType getType() {
      return this.type;
   }

   public SQLExpr getExpr() {
      return this.expr;
   }

   public void setType(SQLParameter.ParameterType type) {
      this.type = type;
   }

   public void setExpr(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.expr = x;
   }
}
